/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jsoninput.JsonInput;
import org.pentaho.di.trans.steps.jsoninput.JsonInputData;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JsonInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private String[] fileName;
    private String[] fileMask;
    private String[] fileRequired;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private JsonInputField[] inputFields;
    private String valueField;
    private boolean inFields;
    private boolean IsAFile;
    private boolean addResultFile;
    private boolean IsIgnoreEmptyFile;
    private String[] includeSubFolders;
    private boolean doNotFailIfNoFile;
    private boolean ignoreMissingPath;
    private boolean readurl;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public boolean addResultFile() {
        return this.addResultFile;
    }

    public boolean isReadUrl() {
        return this.readurl;
    }

    public void setReadUrl(boolean readurl) {
        this.readurl = readurl;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public JsonInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(JsonInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String getFieldValue() {
        return this.valueField;
    }

    public void setFieldValue(String value) {
        this.valueField = value;
    }

    public boolean isInFields() {
        return this.inFields;
    }

    public void setInFields(boolean inFields) {
        this.inFields = inFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public boolean isIgnoreEmptyFile() {
        return this.IsIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean IsIgnoreEmptyFile) {
        this.IsIgnoreEmptyFile = IsIgnoreEmptyFile;
    }

    public boolean isdoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setdoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    public void setIgnoreMissingPath(boolean ignoreMissingPath) {
        this.ignoreMissingPath = ignoreMissingPath;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean getIsAFile() {
        return this.IsAFile;
    }

    public void setIsAFile(boolean IsAFile) {
        this.IsAFile = IsAFile;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        JsonInputMeta retval = (JsonInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.excludeFileMask[i] = this.excludeFileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (JsonInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(400);
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addresultfile", (boolean)this.addResultFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"readurl", (boolean)this.readurl));
        retval.append("    " + XMLHandler.addTagValue((String)"IsIgnoreEmptyFile", (boolean)this.IsIgnoreEmptyFile));
        retval.append("    " + XMLHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    " + XMLHandler.addTagValue((String)"ignoreMissingPath", (boolean)this.ignoreMissingPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            JsonInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"IsInFields", (boolean)this.inFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"IsAFile", (boolean)this.IsAFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"valueField", (String)this.valueField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    public String getRequiredFilesDesc(String tt) {
        if (Const.isEmpty((String)tt)) {
            return RequiredFilesDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.addResultFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addresultfile"));
            this.readurl = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"readurl"));
            this.IsIgnoreEmptyFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsIgnoreEmptyFile"));
            this.ignoreMissingPath = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignoreMissingPath"));
            this.doNotFailIfNoFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                JsonInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new JsonInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.inFields = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsInFields"));
            this.IsAFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsAFile"));
            this.valueField = XMLHandler.getTagValue((Node)stepnode, (String)"valueField");
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.sizeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorLoadingXML", (String[])new String[]{e.toString()}));
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new JsonInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.IsIgnoreEmptyFile = false;
        this.ignoreMissingPath = false;
        this.doNotFailIfNoFile = true;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.IsAFile = false;
        this.addResultFile = false;
        this.readurl = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new JsonInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.inFields = false;
        this.valueField = "";
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            JsonInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v2 = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMeta(space.environmentSubstitute(this.filenameField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getShortFileNameField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getExtensionField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getPathField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getSizeField()), 5);
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.isHiddenField()), 4);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getLastModificationDateField()), 3);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getRootUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.addResultFile = rep.getStepAttributeBoolean(id_step, "addresultfile");
            this.readurl = rep.getStepAttributeBoolean(id_step, "readurl");
            this.IsIgnoreEmptyFile = rep.getStepAttributeBoolean(id_step, "IsIgnoreEmptyFile");
            this.ignoreMissingPath = rep.getStepAttributeBoolean(id_step, "ignoreMissingPath");
            this.doNotFailIfNoFile = rep.getStepAttributeBoolean(id_step, "doNotFailIfNoFile");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
            }
            for (i = 0; i < nrFields; ++i) {
                JsonInputField field = new JsonInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setPath(rep.getStepAttributeString(id_step, i, "field_path"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(JsonInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.inFields = rep.getStepAttributeBoolean(id_step, "IsInFields");
            this.IsAFile = rep.getStepAttributeBoolean(id_step, "IsAFile");
            this.valueField = rep.getStepAttributeString(id_step, "valueField");
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.sizeFieldName = rep.getStepAttributeString(id_step, "sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "addresultfile", this.addResultFile);
            rep.saveStepAttribute(id_transformation, id_step, "readurl", this.readurl);
            rep.saveStepAttribute(id_transformation, id_step, "IsIgnoreEmptyFile", this.IsIgnoreEmptyFile);
            rep.saveStepAttribute(id_transformation, id_step, "ignoreMissingPath", this.ignoreMissingPath);
            rep.saveStepAttribute(id_transformation, id_step, "doNotFailIfNoFile", this.doNotFailIfNoFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                JsonInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_path", field.getPath());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "IsInFields", this.inFields);
            rep.saveStepAttribute(id_transformation, id_step, "IsAFile", this.IsAFile);
            rep.saveStepAttribute(id_transformation, id_step, "valueField", this.valueField);
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (!this.isInFields()) {
            if (input.length <= 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (this.getInputFields().length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInputField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isInFields()) {
            if (Const.isEmpty((String)this.getFieldValue())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.FieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(transMeta);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new JsonInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new JsonInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileInputList fileList;
            ArrayList<String> newFilenames = new ArrayList<String>();
            if (!this.isInFields() && (fileList = this.getFiles(space)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject.getName().getPath());
                }
                this.fileName = newFilenames.toArray(new String[newFilenames.size()]);
                this.fileMask = new String[newFilenames.size()];
                this.fileRequired = new String[newFilenames.size()];
                for (int i = 0; i < newFilenames.size(); ++i) {
                    this.fileRequired[i] = YES;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

