/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;

public class SelectValues
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SelectValuesMeta.class;
    private SelectValuesMeta meta;
    private SelectValuesData data;

    public SelectValues(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized Object[] selectValues(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        if (this.data.firstselect) {
            this.data.firstselect = false;
            this.data.fieldnrs = new int[this.meta.getSelectName().length];
            for (int i = 0; i < this.data.fieldnrs.length; ++i) {
                this.data.fieldnrs[i] = rowMeta.indexOfValue(this.meta.getSelectName()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.CouldNotFindField", (String[])new String[]{this.meta.getSelectName()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            int[] cnt = new int[this.meta.getSelectName().length];
            for (int i = 0; i < this.meta.getSelectName().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < this.meta.getSelectName().length; ++j) {
                    String two;
                    String one = Const.NVL((String)this.meta.getSelectRename()[i], (String)this.meta.getSelectName()[i]);
                    if (one.equals(two = Const.NVL((String)this.meta.getSelectRename()[j], (String)this.meta.getSelectName()[j]))) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.FieldCouldNotSpecifiedMoreThanTwice", (String[])new String[]{one}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            if (this.meta.isSelectingAndSortingUnspecifiedFields()) {
                ArrayList<String> extra = new ArrayList<String>();
                ArrayList<Integer> unspecifiedKeyNrs = new ArrayList<Integer>();
                for (int i = 0; i < rowMeta.size(); ++i) {
                    String fieldName = rowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])this.meta.getSelectName()) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    int index = rowMeta.indexOfValue(fieldName);
                    unspecifiedKeyNrs.add(index);
                }
                this.data.extraFieldnrs = new int[unspecifiedKeyNrs.size()];
                for (int i = 0; i < this.data.extraFieldnrs.length; ++i) {
                    this.data.extraFieldnrs[i] = (Integer)unspecifiedKeyNrs.get(i);
                }
            } else {
                this.data.extraFieldnrs = new int[0];
            }
        }
        Object[] outputData = new Object[this.data.selectRowMeta.size()];
        int outputIndex = 0;
        for (int idx : this.data.fieldnrs) {
            if (idx < rowMeta.size()) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(idx);
                outputData[outputIndex++] = valueMeta.cloneValueData(rowData[idx]);
                continue;
            }
            if (!this.log.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"SelectValues.Log.MixingStreamWithDifferentFields", (String[])new String[0]));
        }
        for (int idx : this.data.extraFieldnrs) {
            outputData[outputIndex++] = rowData[idx];
        }
        return outputData;
    }

    private synchronized Object[] removeValues(RowMetaInterface rowMeta, Object[] rowData) {
        if (this.data.firstdeselect) {
            this.data.firstdeselect = false;
            this.data.removenrs = new int[this.meta.getDeleteName().length];
            for (int i = 0; i < this.data.removenrs.length; ++i) {
                this.data.removenrs[i] = rowMeta.indexOfValue(this.meta.getDeleteName()[i]);
                if (this.data.removenrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.CouldNotFindField", (String[])new String[]{this.meta.getDeleteName()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            int[] cnt = new int[this.meta.getDeleteName().length];
            for (int i = 0; i < this.meta.getDeleteName().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < this.meta.getDeleteName().length; ++j) {
                    if (this.meta.getDeleteName()[i].equals(this.meta.getDeleteName()[j])) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.FieldCouldNotSpecifiedMoreThanTwice2", (String[])new String[]{this.meta.getDeleteName()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            Arrays.sort(this.data.removenrs);
        }
        return RowDataUtil.removeItems((Object[])rowData, (int[])this.data.removenrs);
    }

    private synchronized Object[] metadataValues(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        if (this.data.firstmetadata) {
            int i;
            this.data.firstmetadata = false;
            this.data.metanrs = new int[this.meta.getMeta().length];
            for (int i2 = 0; i2 < this.data.metanrs.length; ++i2) {
                this.data.metanrs[i2] = rowMeta.indexOfValue(this.meta.getMeta()[i2].getName());
                if (this.data.metanrs[i2] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.CouldNotFindField", (String[])new String[]{this.meta.getMeta()[i2].getName()}));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            int[] cnt = new int[this.meta.getMeta().length];
            for (i = 0; i < this.meta.getMeta().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < this.meta.getMeta().length; ++j) {
                    if (this.meta.getMeta()[i].getName().equals(this.meta.getMeta()[j].getName())) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.FieldCouldNotSpecifiedMoreThanTwice2", (String[])new String[]{this.meta.getMeta()[i].getName()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            for (i = 0; i < this.data.metanrs.length; ++i) {
                SelectMetadataChange change = this.meta.getMeta()[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.metanrs[i]);
                if (!Const.isEmpty((String)change.getConversionMask())) {
                    valueMeta.setConversionMask(change.getConversionMask());
                }
                valueMeta.setDateFormatLenient(change.isDateFormatLenient());
                valueMeta.setDateFormatLocale(EnvUtil.createLocale((String)change.getDateFormatLocale()));
                valueMeta.setDateFormatTimeZone(EnvUtil.createTimeZone((String)change.getDateFormatTimeZone()));
                valueMeta.setLenientStringToNumber(change.isLenientStringToNumber());
                if (!Const.isEmpty((String)change.getEncoding())) {
                    valueMeta.setStringEncoding(change.getEncoding());
                }
                if (!Const.isEmpty((String)change.getDecimalSymbol())) {
                    valueMeta.setDecimalSymbol(change.getDecimalSymbol());
                }
                if (!Const.isEmpty((String)change.getGroupingSymbol())) {
                    valueMeta.setGroupingSymbol(change.getGroupingSymbol());
                }
                if (Const.isEmpty((String)change.getCurrencySymbol())) continue;
                valueMeta.setCurrencySymbol(change.getCurrencySymbol());
            }
        }
        for (int i = 0; i < this.data.metanrs.length; ++i) {
            int index = this.data.metanrs[i];
            ValueMetaInterface fromMeta = rowMeta.getValueMeta(index);
            ValueMetaInterface toMeta = this.data.metadataRowMeta.getValueMeta(index);
            if (fromMeta.isStorageBinaryString() && this.meta.getMeta()[i].getStorageType() == 0) {
                rowData[index] = fromMeta.convertBinaryStringToNativeType((byte[])rowData[index]);
            }
            if (this.meta.getMeta()[i].getType() == 0 || fromMeta.getType() == toMeta.getType()) continue;
            rowData[index] = toMeta.convertData(fromMeta, rowData[index]);
        }
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SelectValuesMeta)smi;
        this.data = (SelectValuesData)sdi;
        Object[] rowData = this.getRow();
        if (rowData == null) {
            this.setOutputDone();
            return false;
        }
        Object[] rowCopy = null;
        if (this.getStepMeta().isDoingErrorHandling()) {
            rowCopy = this.getInputRowMeta().cloneRow(rowData);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"SelectValues.Log.GotRowFromPreviousStep", (String[])new String[0]) + this.getInputRowMeta().getString(rowData));
        }
        if (this.first) {
            this.first = false;
            this.data.selectRowMeta = this.getInputRowMeta().clone();
            this.meta.getSelectFields(this.data.selectRowMeta, this.getStepname());
            this.data.deselectRowMeta = this.data.selectRowMeta.clone();
            this.meta.getDeleteFields(this.data.deselectRowMeta);
            this.data.metadataRowMeta = this.data.deselectRowMeta.clone();
            this.meta.getMetadataFields(this.data.metadataRowMeta, this.getStepname());
        }
        try {
            Object[] outputData = rowData;
            if (this.data.select) {
                outputData = this.selectValues(this.getInputRowMeta(), outputData);
            }
            if (this.data.deselect) {
                outputData = this.removeValues(this.data.selectRowMeta, outputData);
            }
            if (this.data.metadata) {
                outputData = this.metadataValues(this.data.deselectRowMeta, outputData);
            }
            if (outputData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.metadataRowMeta, outputData);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SelectValues.Log.WroteRowToNextStep", (String[])new String[0]) + this.data.metadataRowMeta.getString(outputData));
            }
        }
        catch (KettleException e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), rowCopy, 1L, e.getMessage(), null, "SELECT001");
            }
            throw e;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SelectValues.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SelectValuesMeta)smi;
        this.data = (SelectValuesData)sdi;
        if (super.init(smi, sdi)) {
            boolean atLeastOne;
            this.data.firstselect = true;
            this.data.firstdeselect = true;
            this.data.firstmetadata = true;
            this.data.select = false;
            this.data.deselect = false;
            this.data.metadata = false;
            if (!Const.isEmpty((String[])this.meta.getSelectName())) {
                this.data.select = true;
            }
            if (!Const.isEmpty((String[])this.meta.getDeleteName())) {
                this.data.deselect = true;
            }
            if (!Const.isEmpty((Object[])this.meta.getMeta())) {
                this.data.metadata = true;
            }
            boolean bl = atLeastOne = this.data.select || this.data.deselect || this.data.metadata;
            if (!atLeastOne) {
                this.setErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.InputShouldContainData", (String[])new String[0]));
            }
            return atLeastOne;
        }
        return false;
    }
}

