/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileFilter;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;

public class TextFileInputMetaInjection
implements StepMetaInjectionInterface {
    private TextFileInputMeta meta;

    public TextFileInputMetaInjection(TextFileInputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] aggEntries;
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.FILE_TYPE, Entry.SEPARATOR, Entry.ENCLOSURE, Entry.ESCAPE_CHAR, Entry.BREAK_IN_ENCLOSURE, Entry.HEADER_PRESENT, Entry.NR_HEADER_LINES, Entry.HAS_FOOTER, Entry.NR_FOOTER_LINES, Entry.HAS_WRAPPED_LINES, Entry.NR_WRAPS, Entry.HAS_PAGED_LAYOUT, Entry.NR_DOC_HEADER_LINES, Entry.NR_LINES_PER_PAGE, Entry.COMPRESSION_TYPE, Entry.NO_EMPTY_LINES, Entry.INCLUDE_FILENAME, Entry.FILENAME_FIELD, Entry.INCLUDE_ROW_NUMBER, Entry.ROW_NUMBER_BY_FILE, Entry.ROW_NUMBER_FIELD, Entry.FILE_FORMAT, Entry.ROW_LIMIT, Entry.DATE_FORMAT_LENIENT, Entry.DATE_FORMAT_LOCALE, Entry.ACCEPT_FILE_NAMES, Entry.ACCEPT_FILE_STEP, Entry.ACCEPT_FILE_FIELD, Entry.PASS_THROUGH_FIELDS, Entry.ADD_FILES_TO_RESULT, Entry.FILE_SHORT_FILE_FIELDNAME, Entry.FILE_PATH_FIELDNAME, Entry.FILE_HIDDEN_FIELDNAME, Entry.FILE_LAST_MODIFICATION_FIELDNAME, Entry.FILE_URI_FIELDNAME, Entry.FILE_EXTENSION_FIELDNAME, Entry.FILE_SIZE_FIELDNAME, Entry.SKIP_BAD_FILES, Entry.FILE_ERROR_FIELD, Entry.FILE_ERROR_MESSAGE_FIELD, Entry.IGNORE_ERRORS, Entry.ERROR_COUNT_FIELD, Entry.ERROR_FIELDS_FIELD, Entry.ERROR_TEXT_FIELD, Entry.WARNING_FILES_TARGET_DIR, Entry.WARNING_FILES_EXTENTION, Entry.ERROR_FILES_TARGET_DIR, Entry.ERROR_FILES_EXTENTION, Entry.LINE_NR_FILES_TARGET_DIR, Entry.LINE_NR_FILES_EXTENTION, Entry.ERROR_LINES_SKIPPED}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry filesEntry = new StepInjectionMetaEntry(Entry.FILENAME_LINES.name(), 0, Entry.FILENAME_LINES.description);
        all.add(filesEntry);
        StepInjectionMetaEntry fileEntry = new StepInjectionMetaEntry(Entry.FILENAME_LINE.name(), 0, Entry.FILENAME_LINE.description);
        filesEntry.getDetails().add(fileEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.FILENAME, Entry.FILEMASK, Entry.EXCLUDE_FILEMASK, Entry.FILE_REQUIRED, Entry.INCLUDE_SUBFOLDERS}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fileEntry.getDetails().add(metaEntry);
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.FIELDS.name(), 0, Entry.FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.FIELD.name(), 0, Entry.FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : aggEntries = new Entry[]{Entry.FIELD_NAME, Entry.FIELD_POSITION, Entry.FIELD_LENGTH, Entry.FIELD_TYPE, Entry.FIELD_IGNORE, Entry.FIELD_FORMAT, Entry.FIELD_TRIM_TYPE, Entry.FIELD_PRECISION, Entry.FIELD_DECIMAL, Entry.FIELD_GROUP, Entry.FIELD_CURRENCY, Entry.FIELD_REPEAT, Entry.FIELD_NULL_STRING, Entry.FIELD_IF_NULL}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<FileLine> fileLines = new ArrayList<FileLine>();
        ArrayList<TextFileInputField> fields = new ArrayList<TextFileInputField>();
        ArrayList<TextFileFilter> filters = new ArrayList<TextFileFilter>();
        block85: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case FILENAME_LINES: {
                    String value;
                    Entry metaEntry;
                    List<StepInjectionMetaEntry> entries;
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.FILENAME_LINE) continue;
                        FileLine fileLine = new FileLine();
                        entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FILENAME: {
                                    fileLine.filename = value;
                                    break;
                                }
                                case FILEMASK: {
                                    fileLine.includeMask = value;
                                    break;
                                }
                                case EXCLUDE_FILEMASK: {
                                    fileLine.excludeMask = value;
                                    break;
                                }
                                case FILE_REQUIRED: {
                                    fileLine.required = value;
                                    break;
                                }
                                case INCLUDE_SUBFOLDERS: {
                                    fileLine.includeSubfolders = value;
                                    break;
                                }
                            }
                        }
                        fileLines.add(fileLine);
                    }
                    continue block85;
                }
                case FIELDS: {
                    String value;
                    Entry metaEntry;
                    List<StepInjectionMetaEntry> entries;
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.FIELD) continue;
                        TextFileInputField field = new TextFileInputField();
                        entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FIELD_NAME: {
                                    field.setName(value);
                                    break;
                                }
                                case FIELD_POSITION: {
                                    field.setPosition(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_LENGTH: {
                                    field.setLength(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_TYPE: {
                                    field.setType(ValueMeta.getType((String)value));
                                    break;
                                }
                                case FIELD_IGNORE: {
                                    field.setIgnored("Y".equalsIgnoreCase(value));
                                    break;
                                }
                                case FIELD_FORMAT: {
                                    field.setFormat(value);
                                    break;
                                }
                                case FIELD_TRIM_TYPE: {
                                    field.setTrimType(ValueMeta.getTrimTypeByCode((String)value));
                                    break;
                                }
                                case FIELD_PRECISION: {
                                    field.setPrecision(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_DECIMAL: {
                                    field.setDecimalSymbol(value);
                                    break;
                                }
                                case FIELD_GROUP: {
                                    field.setGroupSymbol(value);
                                    break;
                                }
                                case FIELD_CURRENCY: {
                                    field.setCurrencySymbol(value);
                                    break;
                                }
                                case FIELD_REPEAT: {
                                    field.setRepeated("Y".equalsIgnoreCase(value));
                                    break;
                                }
                                case FIELD_NULL_STRING: {
                                    field.setNullString(value);
                                    break;
                                }
                                case FIELD_IF_NULL: {
                                    field.setIfNullValue(value);
                                    break;
                                }
                            }
                        }
                        fields.add(field);
                    }
                    continue block85;
                }
                case FILTERS: {
                    String value;
                    Entry metaEntry;
                    List<StepInjectionMetaEntry> entries;
                    Entry fieldEntry;
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.FILTER) continue;
                        TextFileFilter filterLine = new TextFileFilter();
                        entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FILTER_POSITION: {
                                    filterLine.setFilterPosition(Const.toInt((String)value, (int)0));
                                    break;
                                }
                                case FILTER_STRING: {
                                    filterLine.setFilterString(value);
                                    break;
                                }
                                case FILTER_LAST_LINE: {
                                    filterLine.setFilterLastLine("Y".equalsIgnoreCase(value));
                                    break;
                                }
                                case FILTER_POSITIVE: {
                                    filterLine.setFilterPositive("Y".equalsIgnoreCase(value));
                                    break;
                                }
                            }
                        }
                        filters.add(filterLine);
                    }
                    continue block85;
                }
                case FILE_TYPE: {
                    this.meta.setFileType(lookValue);
                    break;
                }
                case SEPARATOR: {
                    this.meta.setSeparator(lookValue);
                    break;
                }
                case ENCLOSURE: {
                    this.meta.setEnclosure(lookValue);
                    break;
                }
                case ESCAPE_CHAR: {
                    this.meta.setEscapeCharacter(lookValue);
                    break;
                }
                case BREAK_IN_ENCLOSURE: {
                    this.meta.setBreakInEnclosureAllowed("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case HEADER_PRESENT: {
                    this.meta.setHeader("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case NR_HEADER_LINES: {
                    this.meta.setNrHeaderLines(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case HAS_FOOTER: {
                    this.meta.setFooter("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case NR_FOOTER_LINES: {
                    this.meta.setNrFooterLines(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case HAS_WRAPPED_LINES: {
                    this.meta.setLineWrapped("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case NR_WRAPS: {
                    this.meta.setNrWraps(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case HAS_PAGED_LAYOUT: {
                    this.meta.setLayoutPaged("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case NR_DOC_HEADER_LINES: {
                    this.meta.setNrLinesDocHeader(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case NR_LINES_PER_PAGE: {
                    this.meta.setNrLinesPerPage(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case COMPRESSION_TYPE: {
                    this.meta.setFileCompression(lookValue);
                    break;
                }
                case NO_EMPTY_LINES: {
                    this.meta.setNoEmptyLines("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case INCLUDE_FILENAME: {
                    this.meta.setIncludeFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILENAME_FIELD: {
                    this.meta.setFilenameField(lookValue);
                    break;
                }
                case INCLUDE_ROW_NUMBER: {
                    this.meta.setIncludeRowNumber("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ROW_NUMBER_BY_FILE: {
                    this.meta.setRowNumberByFile("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ROW_NUMBER_FIELD: {
                    this.meta.setRowNumberField(lookValue);
                    break;
                }
                case FILE_FORMAT: {
                    this.meta.setFileFormat(lookValue);
                    break;
                }
                case ROW_LIMIT: {
                    this.meta.setRowLimit(Const.toInt((String)lookValue, (int)-1));
                    break;
                }
                case DATE_FORMAT_LENIENT: {
                    this.meta.setDateFormatLenient("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case DATE_FORMAT_LOCALE: {
                    this.meta.setDateFormatLocale(new Locale(lookValue));
                    break;
                }
                case ACCEPT_FILE_NAMES: {
                    this.meta.setAcceptingFilenames("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ACCEPT_FILE_STEP: {
                    this.meta.setAcceptingStepName(lookValue);
                    break;
                }
                case ACCEPT_FILE_FIELD: {
                    this.meta.setAcceptingField(lookValue);
                    break;
                }
                case PASS_THROUGH_FIELDS: {
                    this.meta.setPassingThruFields("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ADD_FILES_TO_RESULT: {
                    this.meta.setAddResultFile("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILE_SHORT_FILE_FIELDNAME: {
                    this.meta.setShortFileNameField(lookValue);
                    break;
                }
                case FILE_PATH_FIELDNAME: {
                    this.meta.setPathField(lookValue);
                    break;
                }
                case FILE_HIDDEN_FIELDNAME: {
                    this.meta.setIsHiddenField(lookValue);
                    break;
                }
                case FILE_LAST_MODIFICATION_FIELDNAME: {
                    this.meta.setLastModificationDateField(lookValue);
                    break;
                }
                case FILE_URI_FIELDNAME: {
                    this.meta.setUriField(lookValue);
                    break;
                }
                case FILE_EXTENSION_FIELDNAME: {
                    this.meta.setExtensionField(lookValue);
                    break;
                }
                case FILE_SIZE_FIELDNAME: {
                    this.meta.setSizeField(lookValue);
                    break;
                }
                case SKIP_BAD_FILES: {
                    this.meta.setSkipBadFiles("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILE_ERROR_FIELD: {
                    this.meta.setFileErrorField(lookValue);
                    break;
                }
                case FILE_ERROR_MESSAGE_FIELD: {
                    this.meta.setFileErrorMessageField(lookValue);
                    break;
                }
                case IGNORE_ERRORS: {
                    this.meta.setErrorIgnored("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ERROR_COUNT_FIELD: {
                    this.meta.setErrorCountField(lookValue);
                    break;
                }
                case ERROR_FIELDS_FIELD: {
                    this.meta.setErrorFieldsField(lookValue);
                    break;
                }
                case ERROR_TEXT_FIELD: {
                    this.meta.setErrorTextField(lookValue);
                    break;
                }
                case WARNING_FILES_TARGET_DIR: {
                    this.meta.setWarningFilesDestinationDirectory(lookValue);
                    break;
                }
                case WARNING_FILES_EXTENTION: {
                    this.meta.setWarningFilesExtension(lookValue);
                    break;
                }
                case ERROR_FILES_TARGET_DIR: {
                    this.meta.setErrorFilesDestinationDirectory(lookValue);
                    break;
                }
                case ERROR_FILES_EXTENTION: {
                    this.meta.setErrorLineFilesExtension(lookValue);
                    break;
                }
                case LINE_NR_FILES_TARGET_DIR: {
                    this.meta.setLineNumberFilesDestinationDirectory(lookValue);
                    break;
                }
                case LINE_NR_FILES_EXTENTION: {
                    this.meta.setLineNumberFilesExtension(lookValue);
                    break;
                }
                case ERROR_LINES_SKIPPED: {
                    this.meta.setErrorLineSkipped("Y".equalsIgnoreCase(lookValue));
                    break;
                }
            }
        }
        if (fields.size() > 0) {
            this.meta.setInputFields(fields.toArray(new TextFileInputField[fields.size()]));
        }
        if (fileLines.size() > 0) {
            this.meta.allocateFiles(fileLines.size());
            for (int i = 0; i < fileLines.size(); ++i) {
                FileLine fileLine = (FileLine)fileLines.get(i);
                this.meta.getFileName()[i] = fileLine.filename;
                this.meta.getFileMask()[i] = fileLine.includeMask;
                this.meta.getExludeFileMask()[i] = fileLine.excludeMask;
                this.meta.getExludeFileMask()[i] = fileLine.excludeMask;
                this.meta.getFileRequired()[i] = fileLine.required;
                this.meta.getIncludeSubFolders()[i] = fileLine.includeSubfolders;
            }
        }
        if (filters.size() > 0) {
            this.meta.setFilter(filters.toArray(new TextFileFilter[filters.size()]));
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public TextFileInputMeta getMeta() {
        return this.meta;
    }

    private class FileLine {
        String filename;
        String includeMask;
        String excludeMask;
        String required;
        String includeSubfolders;

        private FileLine() {
        }
    }

    private static enum Entry {
        FILE_TYPE(2, "File type (CSV/Fixed)"),
        SEPARATOR(2, "The field separator"),
        ENCLOSURE(2, "The field enclosure"),
        ESCAPE_CHAR(2, "The escape character"),
        BREAK_IN_ENCLOSURE(2, "Is a break allowed in an enclosure? (Y/N)"),
        HEADER_PRESENT(2, "Is there a header present? (Y/N)"),
        NR_HEADER_LINES(2, "The number of header lines"),
        HAS_FOOTER(2, "Is there a footer present? (Y/N)"),
        NR_FOOTER_LINES(2, "The number of footer lines"),
        HAS_WRAPPED_LINES(2, "Are the lines wrapped? (Y/N)"),
        NR_WRAPS(2, "The number of times a line is wrapped"),
        HAS_PAGED_LAYOUT(2, "Is the layout paged? (Y/N)"),
        NR_DOC_HEADER_LINES(2, "The number of document header lines"),
        NR_LINES_PER_PAGE(2, "The number of lines per page"),
        COMPRESSION_TYPE(2, "The compression type used (None, Zip or GZip)"),
        NO_EMPTY_LINES(2, "Skip empty lines? (Y/N)"),
        INCLUDE_FILENAME(2, "Include filename in the output? (Y/N)"),
        FILENAME_FIELD(2, "The name of the filename field in the output"),
        INCLUDE_ROW_NUMBER(2, "Include a row number in the output? (Y/N)"),
        ROW_NUMBER_BY_FILE(2, "Reset the row number for each file? (Y/N)"),
        ROW_NUMBER_FIELD(2, "The name of the row number field in the output"),
        FILE_FORMAT(2, "File format (DOS, UNIX, mixed)"),
        ROW_LIMIT(2, "The maximum number of lines to read."),
        DATE_FORMAT_LENIENT(2, "Use a lenient date parsing algorithm? (Y/N)"),
        DATE_FORMAT_LOCALE(2, "The date format locale"),
        ACCEPT_FILE_NAMES(2, "Accept file names? (Y/N)"),
        ACCEPT_FILE_STEP(2, "The source step for the file names"),
        ACCEPT_FILE_FIELD(2, "The input field for the file names"),
        PASS_THROUGH_FIELDS(2, "Pass through fields? (Y/N)"),
        ADD_FILES_TO_RESULT(2, "Add file names to the result files? (Y/N)"),
        FILE_SHORT_FILE_FIELDNAME(2, "The short file output fieldname"),
        FILE_PATH_FIELDNAME(2, "The path output fieldname"),
        FILE_HIDDEN_FIELDNAME(2, "The hidden output fieldname"),
        FILE_LAST_MODIFICATION_FIELDNAME(2, "The last modification time output fieldname"),
        FILE_URI_FIELDNAME(2, "The URI output fieldname"),
        FILE_EXTENSION_FIELDNAME(2, "The extension output fieldname"),
        FILE_SIZE_FIELDNAME(2, "The file size output fieldname"),
        SKIP_BAD_FILES(2, "Skip bad files? (Y/N)"),
        FILE_ERROR_FIELD(2, "The output field for the error files"),
        FILE_ERROR_MESSAGE_FIELD(2, "The output field for the file error messages"),
        IGNORE_ERRORS(2, "Ignore errors? (Y/N)"),
        ERROR_COUNT_FIELD(2, "The output field for the number of errors"),
        ERROR_FIELDS_FIELD(2, "The output field for the fields in error"),
        ERROR_TEXT_FIELD(2, "The output field for the error text"),
        WARNING_FILES_TARGET_DIR(2, "The target directory for the warning files"),
        WARNING_FILES_EXTENTION(2, "The warning files' extension"),
        ERROR_FILES_TARGET_DIR(2, "The target directory for the error files"),
        ERROR_FILES_EXTENTION(2, "The error files' extension"),
        LINE_NR_FILES_TARGET_DIR(2, "The target directory for the line number files"),
        LINE_NR_FILES_EXTENTION(2, "The line number files' extension"),
        ERROR_LINES_SKIPPED(2, "Skip error lines? (Y/N)"),
        FILENAME_LINES(0, "The list of file definitions"),
        FILENAME_LINE(0, "One file definition line"),
        FILENAME(2, "The filename or directory"),
        FILEMASK(2, "The file mask (regex)"),
        EXCLUDE_FILEMASK(2, "The mask for the files to exclude (regex)"),
        FILE_REQUIRED(2, "Is this a required file (Y/N)"),
        INCLUDE_SUBFOLDERS(2, "Include sub-folders when searching files? (Y/N)"),
        FIELDS(0, "The fields"),
        FIELD(0, "One field"),
        FIELD_NAME(2, "Name"),
        FIELD_POSITION(2, "Position"),
        FIELD_LENGTH(2, "Length"),
        FIELD_TYPE(2, "Data type (String, Number, ...)"),
        FIELD_IGNORE(2, "Ignore? (Y/N)"),
        FIELD_FORMAT(2, "Format"),
        FIELD_TRIM_TYPE(2, "Trim type (none, left, right, both)"),
        FIELD_PRECISION(2, "Precision"),
        FIELD_DECIMAL(2, "Decimal symbol"),
        FIELD_GROUP(2, "Grouping symbol"),
        FIELD_CURRENCY(2, "Currency symbol"),
        FIELD_REPEAT(2, "Repeat values? (Y/N)"),
        FIELD_NULL_STRING(2, "The null string"),
        FIELD_IF_NULL(2, "The default value if null"),
        FILTERS(0, "The filter definitions"),
        FILTER(0, "One filter definition"),
        FILTER_POSITION(2, "Position"),
        FILTER_STRING(2, "Filter string"),
        FILTER_LAST_LINE(2, "Stop reading when filter found? (Y/N)"),
        FILTER_POSITIVE(2, "Only match the filter lines? (Y/N)");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

