/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputsax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxData;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxField;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxFieldPosition;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxMeta;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLInputSaxDataRetriever
extends DefaultHandler {
    XMLInputSaxMeta meta;
    XMLInputSaxData data;
    int[] position = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private List<XMLInputSaxFieldPosition> pathToRootElement = new ArrayList<XMLInputSaxFieldPosition>();
    private List<XMLInputSaxFieldPosition> _pathToRootElement = new ArrayList<XMLInputSaxFieldPosition>();
    private List<XMLInputSaxField> fields = new ArrayList<XMLInputSaxField>();
    private int fieldToFill = -1;
    private Object[] emptyRow;
    private Object[] row;
    private List<Object[]> rowSet = new ArrayList<Object[]>();
    private int counter = 0;
    private int _counter = -1;
    private boolean rootFound = false;
    private String sourceFile;
    private String tempVal;
    private StringBuffer charactersBuffer;
    private LogChannelInterface log;

    public XMLInputSaxDataRetriever(LogChannelInterface log, String sourceFile, XMLInputSaxMeta meta, XMLInputSaxData data) {
        int i;
        this.log = log;
        this.meta = meta;
        this.data = data;
        this.charactersBuffer = new StringBuffer();
        for (i = 0; i < meta.getInputPosition().length; ++i) {
            this.pathToRootElement.add(meta.getInputPosition()[i]);
        }
        for (i = 0; i < meta.getInputFields().length; ++i) {
            this.fields.add(meta.getInputFields()[i]);
        }
        this.sourceFile = sourceFile;
        this.emptyRow = this.buildEmptyRow();
        this.row = new Object[this.emptyRow.length];
        System.arraycopy(this.emptyRow, 0, this.row, 0, this.emptyRow.length);
    }

    public void runExample() {
        this.parseDocument();
    }

    private void parseDocument() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.sourceFile, (DefaultHandler)this);
        }
        catch (SAXException se) {
            this.log.logError(Const.getStackTracker((Throwable)se));
        }
        catch (ParserConfigurationException pce) {
            this.log.logError(Const.getStackTracker((Throwable)pce));
        }
        catch (IOException ie) {
            this.log.logError(Const.getStackTracker((Throwable)ie));
        }
    }

    private XMLInputSaxFieldPosition[] pathFromRoot() {
        int s = this._pathToRootElement.size() - this.pathToRootElement.size();
        if (s > 0) {
            XMLInputSaxFieldPosition[] ret = new XMLInputSaxFieldPosition[s];
            for (int i = 0; i < s; ++i) {
                ret[i] = this.pathToRootElement.get(i + this.pathToRootElement.size());
            }
            return ret;
        }
        return null;
    }

    private String naming(XMLInputSaxFieldPosition[] path) {
        String ret = "";
        for (int i = 0; i < path.length; ++i) {
            String name = path[i].getType() == 2 ? path[i].getAttributeValue() : path[i].getName() + path[i].getElementNr();
            ret = i > 0 ? ret + "_" + name : ret + name;
        }
        return ret;
    }

    private Object[] buildEmptyRow() {
        XMLInputSaxField[] fields = this.meta.getInputFields();
        Object[] row = RowDataUtil.allocateRowData((int)fields.length);
        return row;
    }

    private void counterUp() {
        if (this.counter == this.pathToRootElement.size() - 1) {
            this.rootFound = true;
            ++this.counter;
        } else {
            ++this.counter;
        }
    }

    private boolean comparePaths(int count) {
        for (int i = 0; i <= count; ++i) {
            if (this.pathToRootElement.get(i).equals(this.pathToRootElement.get(i))) continue;
            return false;
        }
        return true;
    }

    private void counterDown() {
        if (this.counter - 1 == this._counter && this.comparePaths(this._counter)) {
            this._pathToRootElement.remove(this._counter);
            --this.counter;
            --this._counter;
            if (this.rootFound) {
                this.rootFound = false;
                this.rowSet.add(this.row);
                this.row = new Object[this.emptyRow.length];
                System.arraycopy(this.emptyRow, 0, this.row, 0, this.emptyRow.length);
            }
        } else {
            this._pathToRootElement.remove(this._counter);
            --this._counter;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int n = this._counter + 1;
        this.position[n] = this.position[n] + 1;
        ++this._counter;
        try {
            if (!this.rootFound) {
                XMLInputSaxFieldPosition el = this.pathToRootElement.get(this.counter);
                if (this.counter == this._counter && qName.equalsIgnoreCase(el.getName())) {
                    if (el.getType() == 2) {
                        String att2;
                        String att1 = attributes.getValue(el.getAttribute());
                        if (att1.equals(att2 = el.getAttributeValue())) {
                            this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, el.getAttribute(), el.getAttributeValue()));
                            if (this.counter == this.pathToRootElement.size() - 1) {
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    XMLInputSaxFieldPosition tempP = new XMLInputSaxFieldPosition(attributes.getQName(i), 3, i + 1);
                                    XMLInputSaxField tempF = new XMLInputSaxField(tempP.getName(), new XMLInputSaxFieldPosition[]{tempP});
                                    int p = this.fields.indexOf(tempF);
                                    if (p < 0) continue;
                                    this.setValueToRow(attributes.getValue(i), p);
                                }
                            }
                            this.counterUp();
                        } else {
                            this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                        }
                    } else {
                        this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                        this.counterUp();
                    }
                    if (this.rootFound && attributes.getLength() > 0) {
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            int attributeID = this.meta.getDefiningAttributeNormalID(attributes.getQName(i));
                            if (attributeID < 0) continue;
                            this.setValueToRow(attributes.getValue(i), attributeID);
                        }
                    }
                } else {
                    this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                }
            } else {
                XMLInputSaxField tempF = null;
                if (attributes.getLength() == 0) {
                    this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                    XMLInputSaxFieldPosition[] path = this.pathFromRoot();
                    tempF = new XMLInputSaxField(this.naming(path), path);
                } else {
                    String attribute = this.meta.getDefiningAttribute(qName);
                    this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, attribute, attributes.getValue(attribute)));
                    XMLInputSaxFieldPosition[] path = this.pathFromRoot();
                    tempF = new XMLInputSaxField(this.naming(path), path);
                }
                int p = this.fields.indexOf(tempF);
                if (p >= 0) {
                    this.fieldToFill = p;
                }
            }
        }
        catch (KettleValueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal = new String(ch, start, length);
        if (this.tempVal != null) {
            this.charactersBuffer.append(this.tempVal);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tempVal = this.charactersBuffer.toString();
        this.charactersBuffer = new StringBuffer();
        try {
            if (this.fieldToFill >= 0) {
                if (this.tempVal == null) {
                    this.tempVal = "";
                }
                this.setValueToRow(this.tempVal, this.fieldToFill);
            }
            this.fieldToFill = -1;
        }
        catch (KettleValueException e) {
            throw new RuntimeException(e);
        }
        this.position[this._counter + 1] = -1;
        this.counterDown();
    }

    private void setValueToRow(String value, int fieldnr) throws KettleValueException {
        XMLInputSaxField xmlInputField = this.fields.get(fieldnr);
        switch (xmlInputField.getTrimType()) {
            case 1: {
                value = Const.ltrim((String)value);
                break;
            }
            case 2: {
                value = Const.rtrim((String)value);
                break;
            }
            case 3: {
                value = Const.trim((String)value);
                break;
            }
        }
        ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(fieldnr);
        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(fieldnr);
        this.row[fieldnr] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
        if (xmlInputField.isRepeated() && this.row[fieldnr] == null && this.data.previousRow != null) {
            Object previous;
            this.row[fieldnr] = previous = this.data.previousRow[fieldnr];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        List<Object[]> list = this.rowSet;
        synchronized (list) {
            return !this.rowSet.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getNext() {
        List<Object[]> list = this.rowSet;
        synchronized (list) {
            if (!this.rowSet.isEmpty()) {
                Object[] ret = this.rowSet.get(0);
                this.rowSet.remove(0);
                return ret;
            }
            return null;
        }
    }
}

