/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.controllers;

import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class OrderController
extends AbstractXulEventHandler {
    private Workspace workspace;
    private BindingFactory bf;
    private XulTree orderTree;

    @Bindable
    public void init() {
        this.orderTree = (XulTree)this.document.getElementById("orderTable");
        this.bf.createBinding((Object)this.workspace, "orders", (Object)this.orderTree, "elements", new BindingConvertor[0]);
        BindingConvertor<int[], Boolean> buttonConvertor = new BindingConvertor<int[], Boolean>(){

            public Boolean sourceToTarget(int[] value) {
                return value == null || value.length == 0;
            }

            public int[] targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.orderTree, "selectedRows", "orderUp", "disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)this.orderTree, "selectedRows", "orderDown", "disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)this.orderTree, "selectedRows", "orderRemove", "disabled", new BindingConvertor[]{buttonConvertor});
    }

    public int getSelectedIndex() {
        int[] rows = this.orderTree.getAbsoluteSelectedRows();
        return rows != null && rows.length == 0 ? -1 : rows[0];
    }

    @Bindable
    public void moveUp() {
        try {
            int prevIndex = this.getSelectedIndex();
            this.workspace.getOrders().moveChildUp(this.getSelectedIndex());
            this.orderTree.clearSelection();
            this.orderTree.setSelectedRows(new int[]{prevIndex - 1});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Bindable
    public void moveDown() {
        int prevIndex = this.getSelectedIndex();
        try {
            this.workspace.getOrders().moveChildDown(this.getSelectedIndex());
            this.orderTree.clearSelection();
            this.orderTree.setSelectedRows(new int[]{prevIndex + 1});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Bindable
    public void remove() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        this.workspace.getOrders().remove(this.getSelectedIndex());
        this.orderTree.clearSelection();
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return "orderController";
    }
}

