/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.controllers;

import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumn;
import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class SelectedColumnController
extends AbstractXulEventHandler {
    private XulTree columnTree;
    private Workspace workspace;
    private BindingFactory bf;
    private static XulDialog denyRemoveColumnDialog;

    @Bindable
    public void init() {
        this.columnTree = (XulTree)this.document.getElementById("selectedColumnTree");
        BindingConvertor<int[], Boolean> buttonConvertor = new BindingConvertor<int[], Boolean>(){

            public Boolean sourceToTarget(int[] value) {
                return value == null || value.length == 0;
            }

            public int[] targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.columnTree, "selectedRows", "colUp", "disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)this.columnTree, "selectedRows", "colDown", "disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)this.columnTree, "selectedRows", "colRemove", "disabled", new BindingConvertor[]{buttonConvertor});
        denyRemoveColumnDialog = (XulDialog)this.document.getElementById("denyRemoveColumnDialog");
    }

    public int getSelectedIndex() {
        int[] rows = this.columnTree.getAbsoluteSelectedRows();
        return rows != null && rows.length == 0 ? -1 : rows[0];
    }

    @Bindable
    public void moveUp() {
        try {
            int prevIndex = this.getSelectedIndex();
            this.workspace.getSelections().moveChildUp(this.getSelectedIndex());
            this.columnTree.clearSelection();
            this.columnTree.setSelectedRows(new int[]{prevIndex - 1});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Bindable
    public void moveDown() {
        int prevIndex = this.getSelectedIndex();
        try {
            this.workspace.getSelections().moveChildDown(this.getSelectedIndex());
            this.columnTree.clearSelection();
            this.columnTree.setSelectedRows(new int[]{prevIndex + 1});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Bindable
    public void remove() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        if (((UIColumn)this.workspace.getSelections().get(this.getSelectedIndex())).isPersistent()) {
            if (denyRemoveColumnDialog == null) {
                throw new IllegalStateException("Error dialog has not been loaded yet");
            }
            denyRemoveColumnDialog.show();
            return;
        }
        this.workspace.getSelections().remove(this.getSelectedIndex());
        this.columnTree.clearSelection();
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return "selectedColumns";
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    @Bindable
    public static void closeDenyRemoveColumnDialog() {
        if (denyRemoveColumnDialog == null) {
            throw new IllegalStateException("Error dialog has not been loaded yet");
        }
        denyRemoveColumnDialog.hide();
    }
}

