/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.models;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.pentaho.commons.metadata.mqleditor.AggType;
import org.pentaho.commons.metadata.mqleditor.ColumnType;
import org.pentaho.commons.metadata.mqleditor.CombinationType;
import org.pentaho.commons.metadata.mqleditor.MqlCondition;
import org.pentaho.commons.metadata.mqleditor.Operator;
import org.pentaho.commons.metadata.mqleditor.beans.Condition;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumn;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class UICondition
extends XulEventSourceAdapter
implements MqlCondition {
    private String defaultValue;
    private UIColumn column;
    private Operator operator = Operator.EQUAL;
    private String value;
    private CombinationType combinationType = CombinationType.AND;
    private boolean parameterized;
    private boolean valueDisabled;
    private AggType selectedAggType;
    private boolean topMost;

    public UICondition() {
    }

    public UICondition(UIColumn column, Operator operator, String value) {
        this();
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    public UICondition(Condition bean) {
        if (bean.getColumn() != null) {
            this.column = new UIColumn(bean.getColumn());
        }
        this.defaultValue = bean.getDefaultValue();
        this.operator = bean.getOperator();
        this.value = bean.getValue();
        this.combinationType = bean.getCombinationType();
        this.column = new UIColumn(bean.getColumn());
        this.selectedAggType = bean.getSelectedAggType();
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    @Bindable
    public UIColumn getColumn() {
        return this.column;
    }

    @Bindable
    public void setColumn(UIColumn column) {
        this.column = column;
        if (this.operator == Operator.EQUAL) {
            this.setOperator(column.getType() == ColumnType.TEXT ? Operator.EXACTLY_MATCHES : Operator.EQUAL);
        }
    }

    @Override
    @Bindable
    public Operator getOperator() {
        return this.operator;
    }

    @Bindable
    public void setOperator(Operator operator) {
        this.operator = operator;
        switch (this.operator) {
            case IS_NULL: 
            case IS_NOT_NULL: {
                this.setValueDisabled(true);
                break;
            }
            default: {
                this.setValueDisabled(false);
            }
        }
    }

    @Bindable
    public void setOperator(Object operator) {
        this.setOperator((Operator)operator);
    }

    @Override
    @Bindable
    public String getValue() {
        return this.value;
    }

    @Bindable
    public void setValue(String value) {
        String prevVal = this.value;
        this.value = value;
        this.firePropertyChange("value", prevVal, this.value);
        this.setParameterized(value != null && value.contains("{") && value.contains("}"));
    }

    @Bindable
    public String getComboTypeStr() {
        if (this.isTopMost()) {
            if (this.combinationType == CombinationType.AND_NOT) {
                return "NOT";
            }
            return "";
        }
        return this.combinationType.name();
    }

    @Bindable
    public void setComboTypeStr(Object name) {
        this.combinationType = this.isTopMost() ? (name.equals("NOT") ? CombinationType.AND_NOT : CombinationType.AND) : CombinationType.valueOf((String)name);
    }

    @Override
    @Bindable
    public CombinationType getCombinationType() {
        return this.combinationType;
    }

    @Bindable
    public void setCombinationType(CombinationType combinationType) {
        this.combinationType = combinationType;
    }

    public void setCombinationType(Object combinationType) {
        if (combinationType != null) {
            this.setCombinationType((CombinationType)combinationType);
        }
    }

    public void setTableName(String name) {
    }

    @Bindable
    public String getColumnName() {
        return this.column.getName();
    }

    @Bindable
    public void setColumnName(String name) {
    }

    @Bindable
    public Vector getComparisons() {
        Vector<Operator> v = new Vector<Operator>();
        v.addAll(Arrays.asList(Operator.values(this.getColumn().getType() == ColumnType.TEXT)));
        return v;
    }

    @Bindable
    public void setComparisons(String str) {
    }

    @Bindable
    public Vector getCombinations() {
        if (this.isTopMost()) {
            Vector<String> v = new Vector<String>();
            v.add("");
            v.add("NOT");
            return v;
        }
        Vector<String> v = new Vector<String>();
        for (CombinationType type : CombinationType.values()) {
            v.add(type.name());
        }
        return v;
    }

    @Bindable
    public void setCombinations(String str) {
    }

    @Bindable
    public String getCellType() {
        return "COMBOBOX";
    }

    @Bindable
    public String getCondition(String objName) {
        throw new RuntimeException("UI does not implement this method");
    }

    @Bindable
    public String getCondition(String objName, boolean enforceParameters) {
        throw new RuntimeException("UI does not implement this method");
    }

    @Override
    @Bindable
    public boolean isParameterized() {
        return this.parameterized;
    }

    @Bindable
    public void setParameterized(boolean parameterized) {
        boolean prevVal = this.isParameterized();
        this.firePropertyChange("parameterized", prevVal, parameterized);
        this.parameterized = parameterized;
        this.firePropertyChange("defaultDisabled", null, this.isDefaultDisabled());
        if (!parameterized) {
            this.setDefaultValue("");
        }
    }

    @Bindable
    public boolean isDefaultDisabled() {
        return !this.parameterized;
    }

    @Bindable
    public void setDefaultValue(String val) {
        String prevVal = this.defaultValue;
        this.defaultValue = val;
        this.firePropertyChange("defaultValue", prevVal, val);
    }

    @Override
    @Bindable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Bindable
    public void setSelectedAggType(AggType aggType) {
        this.selectedAggType = aggType;
    }

    @Override
    @Bindable
    public AggType getSelectedAggType() {
        return this.selectedAggType;
    }

    @Bindable
    public void setSelectedAggType(Object o) {
        this.setSelectedAggType((AggType)((Object)o));
    }

    @Bindable
    public List<AggType> getAggTypes() {
        return this.column.getAggTypes();
    }

    @Bindable
    public void setAggTypes(List<AggType> ignored) {
    }

    @Bindable
    public Vector getBindingAggTypes() {
        return this.column.getBindingAggTypes();
    }

    @Bindable
    public void setTopMost(boolean topMost) {
        this.topMost = topMost;
    }

    @Bindable
    public boolean isTopMost() {
        return this.topMost;
    }

    @Bindable
    public boolean isValueDisabled() {
        return this.valueDisabled;
    }

    @Bindable
    public void setValueDisabled(boolean disabled) {
        boolean prevVal = this.valueDisabled;
        this.valueDisabled = disabled;
        this.firePropertyChange("valueDisabled", prevVal, this.valueDisabled);
        if (disabled) {
            this.setValue(null);
        }
    }
}

