/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.service.util;

import org.pentaho.commons.metadata.mqleditor.ColumnType;
import org.pentaho.commons.metadata.mqleditor.MqlCondition;
import org.pentaho.commons.metadata.mqleditor.editor.service.util.OperatorFormatter;

public class ConditionFormatter {
    private OperatorFormatter opFormatter;

    public ConditionFormatter(OperatorFormatter of) {
        this.opFormatter = of;
    }

    public String getCondition(MqlCondition c, String objName) {
        return this.getCondition(c, objName, true);
    }

    public String getCondition(MqlCondition c, String objName, boolean enforceParameters) {
        String val = c.getValue();
        if (c.getColumn().getType() == ColumnType.DATE) {
            if (c.isParameterized() && enforceParameters) {
                val = "DATEVALUE([param:" + c.getValue().replaceAll("[\\{\\}]", "") + "]" + ")";
                return this.opFormatter.formatCondition(c.getOperator(), objName, val, false);
            }
            val = "DATEVALUE(\"" + val + "\")";
        }
        return this.opFormatter.formatCondition(c.getOperator(), objName, val, c.isParameterized() && enforceParameters);
    }
}

