/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.mapreduce.ExportJobBase;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBOutputFormat;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.mapreduce.AvroExportMapper;
import org.apache.sqoop.mapreduce.AvroInputFormat;
import org.apache.sqoop.mapreduce.ExportJobBase;
import org.apache.sqoop.mapreduce.SequenceFileExportMapper;
import org.apache.sqoop.mapreduce.TextExportMapper;

public class JdbcExportJob
extends ExportJobBase {
    private ExportJobBase.FileType fileType;
    public static final Log LOG = LogFactory.getLog((String)JdbcExportJob.class.getName());

    public JdbcExportJob(ExportJobContext context) {
        super(context);
    }

    public JdbcExportJob(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(ctxt, mapperClass, inputFormatClass, outputFormatClass);
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        this.fileType = this.getInputFileType();
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        if (this.fileType == ExportJobBase.FileType.AVRO_DATA_FILE) {
            LOG.debug((Object)"Configuring for Avro export");
            ConnManager connManager = this.context.getConnManager();
            Map<String, Integer> columnTypeInts = connManager.getColumnTypes(tableName, this.options.getSqlQuery());
            MapWritable columnTypes = new MapWritable();
            for (Map.Entry<String, Integer> e : columnTypeInts.entrySet()) {
                Text columnName = new Text(e.getKey());
                Text columnText = new Text(connManager.toJavaType(e.getValue()));
                columnTypes.put((Writable)columnName, (Writable)columnText);
            }
            DefaultStringifier.store((Configuration)job.getConfiguration(), (Object)columnTypes, (String)"sqoop.avro.column.types.map");
        }
    }

    @Override
    protected Class<? extends InputFormat> getInputFormatClass() throws ClassNotFoundException {
        if (this.fileType == ExportJobBase.FileType.AVRO_DATA_FILE) {
            return AvroInputFormat.class;
        }
        return super.getInputFormatClass();
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        switch (this.fileType) {
            case SEQUENCE_FILE: {
                return SequenceFileExportMapper.class;
            }
            case AVRO_DATA_FILE: {
                return AvroExportMapper.class;
            }
        }
        return TextExportMapper.class;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws IOException {
        ConnManager mgr = this.context.getConnManager();
        try {
            String username = this.options.getUsername();
            if (null == username || username.length() == 0) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword());
            }
            String[] colNames = this.options.getColumns();
            if (null == colNames) {
                colNames = mgr.getColumnNames(tableName);
            }
            DBOutputFormat.setOutput(job, tableName, colNames);
            job.setOutputFormatClass(this.getOutputFormatClass());
            job.getConfiguration().set("sqoop.mapreduce.export.table.class", tableClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load OutputFormat", cnfe);
        }
    }
}

