/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hive.HiveImport;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportAllTablesTool
extends ImportTool {
    public static final Log LOG = LogFactory.getLog((String)ImportAllTablesTool.class.getName());

    public ImportAllTablesTool() {
        super("import-all-tables", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        HiveImport hiveImport = null;
        if (!this.init(options)) {
            return 1;
        }
        try {
            String[] tables;
            if (options.doHiveImport()) {
                hiveImport = new HiveImport(options, this.manager, options.getConf(), false);
            }
            if (null == (tables = this.manager.listTables())) {
                System.err.println("Could not retrieve tables list from server");
                LOG.error((Object)"manager.listTables() returned null");
                int n = 1;
                return n;
            }
            for (String tableName : tables) {
                this.importTable(options, tableName, hiveImport);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Encountered IOException running import job: " + ioe.toString()));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(ioe);
            }
            int n = 1;
            return n;
        }
        catch (ImportException ie) {
            LOG.error((Object)("Error during import: " + ie.toString()));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(ie);
            }
            int n = 1;
            return n;
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }
}

