/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.util.AxisPolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.neethi.PolicyRegistryImpl;

public class PolicyInclude {
    public static final int ANON_POLICY = 100;
    public static final int AXIS_POLICY = 1;
    public static final int AXIS_MODULE_POLICY = 2;
    public static final int AXIS_MODULE_OPERATION_POLICY = 17;
    public static final int AXIS_SERVICE_POLICY = 3;
    public static final int AXIS_OPERATION_POLICY = 4;
    public static final int AXIS_MESSAGE_POLICY = 5;
    public static final int SERVICE_POLICY = 6;
    public static final int PORT_POLICY = 7;
    public static final int PORT_TYPE_POLICY = 8;
    public static final int BINDING_POLICY = 9;
    public static final int OPERATION_POLICY = 10;
    public static final int BINDING_OPERATION_POLICY = 11;
    public static final int INPUT_POLICY = 12;
    public static final int OUTPUT_POLICY = 13;
    public static final int BINDING_INPUT_POLICY = 14;
    public static final int BINDING_OUTPUT_POLICY = 15;
    public static final int MESSAGE_POLICY = 16;
    private Policy policy = null;
    private Policy effectivePolicy = null;
    private PolicyRegistry reg;
    private AxisDescription description;
    private Hashtable wrapperElements = new Hashtable();

    public PolicyInclude() {
        this.reg = new PolicyRegistryImpl();
    }

    public PolicyInclude(AxisDescription axisDescription) {
        if (axisDescription.getParent() != null) {
            PolicyInclude parentPolicyInclude = axisDescription.getParent().getPolicyInclude();
            this.reg = new PolicyRegistryImpl(parentPolicyInclude.getPolicyRegistry());
        } else {
            this.reg = new PolicyRegistryImpl();
        }
        this.setDescription(axisDescription);
    }

    public void setPolicyRegistry(PolicyRegistry reg) {
        this.reg = reg;
    }

    public PolicyRegistry getPolicyRegistry() {
        return this.reg;
    }

    public void setPolicy(Policy policy) {
        this.wrapperElements.clear();
        if (policy.getName() == null && policy.getId() == null) {
            policy.setId(UUIDGenerator.getUUID());
        }
        Wrapper wrapper = new Wrapper(100, policy);
        if (policy.getName() != null) {
            this.wrapperElements.put(policy.getName(), wrapper);
        } else {
            this.wrapperElements.put(policy.getId(), wrapper);
        }
        if (this.description != null) {
            this.description.getPolicySubject().clear();
            this.description.getPolicySubject().attachPolicy(policy);
        }
    }

    public void updatePolicy(Policy policy) {
        String key = policy.getName();
        if (key == null && (key = policy.getId()) == null) {
            throw new RuntimeException("policy doesn't have a name or an id ");
        }
        Wrapper wrapper = (Wrapper)this.wrapperElements.get(key);
        wrapper.value = policy;
        if (this.description != null) {
            this.description.getPolicySubject().updatePolicy(policy);
        }
    }

    public void setEffectivePolicy(Policy effectivePolicy) {
        this.effectivePolicy = effectivePolicy;
        if (this.description != null && effectivePolicy != null) {
            this.description.getPolicySubject().clear();
            this.description.getPolicySubject().attachPolicy(effectivePolicy);
        }
    }

    public void setDescription(AxisDescription description) {
        this.description = description;
    }

    public AxisDescription getDescription() {
        return this.description;
    }

    private PolicyInclude getParent() {
        if (this.description != null && this.description.getParent() != null) {
            return this.description.getParent().getPolicyInclude();
        }
        return null;
    }

    private void calculatePolicy() {
        Policy result = null;
        Iterator iterator = this.wrapperElements.values().iterator();
        while (iterator.hasNext()) {
            Policy p;
            Object policyElement = ((Wrapper)iterator.next()).getValue();
            if (policyElement instanceof PolicyReference) {
                AxisPolicyLocator locator = new AxisPolicyLocator(this.description);
                p = (Policy)((PolicyReference)policyElement).normalize((PolicyRegistry)locator, false);
            } else if (policyElement instanceof Policy) {
                p = (Policy)policyElement;
            } else {
                throw new RuntimeException();
            }
            result = result == null ? p : result.merge(p);
        }
        this.policy = result;
    }

    private void calculateEffectivePolicy() {
        Policy parentPolicy;
        Policy result = this.getParent() != null ? ((parentPolicy = this.getParent().getEffectivePolicy()) == null ? this.getPolicy() : (this.getPolicy() != null ? parentPolicy.merge(this.getPolicy()) : parentPolicy)) : this.getPolicy();
        this.setEffectivePolicy(result);
    }

    public Policy getPolicy() {
        if (this.description != null) {
            ArrayList policyList = new ArrayList(this.description.getPolicySubject().getAttachedPolicyComponents());
            return PolicyUtil.getMergedPolicy(policyList, this.description);
        }
        this.calculatePolicy();
        return this.policy;
    }

    public Policy getEffectivePolicy() {
        if (this.description != null) {
            if (this.description instanceof AxisMessage) {
                return ((AxisMessage)this.description).getEffectivePolicy();
            }
            if (this.description instanceof AxisBindingMessage) {
                return ((AxisBindingMessage)this.description).getEffectivePolicy();
            }
        }
        this.calculateEffectivePolicy();
        return this.effectivePolicy;
    }

    public ArrayList getPolicyElements() {
        if (this.description != null) {
            return new ArrayList(this.description.getPolicySubject().getAttachedPolicyComponents());
        }
        ArrayList<Object> policyElementsList = new ArrayList<Object>();
        Iterator policyElementIterator = this.wrapperElements.values().iterator();
        while (policyElementIterator.hasNext()) {
            policyElementsList.add(((Wrapper)policyElementIterator.next()).getValue());
        }
        return policyElementsList;
    }

    public ArrayList getPolicyElements(int type) {
        ArrayList<Object> policyElementList = new ArrayList<Object>();
        Iterator wrapperElementIterator = this.wrapperElements.values().iterator();
        while (wrapperElementIterator.hasNext()) {
            Wrapper wrapper = (Wrapper)wrapperElementIterator.next();
            if (wrapper.getType() != type) continue;
            policyElementList.add(wrapper.getValue());
        }
        return policyElementList;
    }

    public void registerPolicy(String key, Policy policy) {
        this.reg.register(key, policy);
    }

    public Policy getPolicy(String key) {
        PolicyComponent result;
        if (this.description != null && (result = this.description.getPolicySubject().getAttachedPolicyComponent(key)) != null && result instanceof Policy) {
            return (Policy)result;
        }
        return this.reg.lookup(key);
    }

    public void addPolicyElement(int type, Policy policy) {
        String key = policy.getName();
        if (key == null && (key = policy.getId()) == null) {
            policy.setId(UUIDGenerator.getUUID());
        }
        key = policy.getName() != null ? policy.getName() : policy.getId();
        Wrapper wrapper = new Wrapper(type, policy);
        this.wrapperElements.put(key, wrapper);
        this.reg.register(key, policy);
        if (this.description != null) {
            this.description.getPolicySubject().attachPolicy(policy);
        }
    }

    public void addPolicyRefElement(int type, PolicyReference policyReference) {
        Wrapper wrapper = new Wrapper(type, policyReference);
        this.wrapperElements.put(policyReference.getURI(), wrapper);
        if (this.description != null) {
            this.description.getPolicySubject().attachPolicyReference(policyReference);
        }
    }

    public void removePolicyElement(String policyURI) {
        this.wrapperElements.remove(policyURI);
        this.reg.remove(policyURI);
        if (this.description != null) {
            this.description.getPolicySubject().detachPolicyComponent(policyURI);
        }
    }

    public void removeAllPolicyElements() {
        this.wrapperElements.clear();
        if (this.description != null) {
            this.description.getPolicySubject().clear();
        }
    }

    public List getAttachedPolicies() {
        if (this.description != null) {
            return new ArrayList(this.description.getPolicySubject().getAttachedPolicyComponents());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.wrapperElements.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Wrapper)iterator.next()).value);
        }
        return arrayList;
    }

    class Wrapper {
        private int type;
        private Object value;

        Wrapper(int type, Object value) {
            this.setType(type);
            this.setValue(value);
        }

        void setType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }

        void setValue(Object value) {
            this.value = value;
        }

        Object getValue() {
            return this.value;
        }
    }
}

