/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc;

import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class Messages {
    private static final Log logger = LogFactory.getLog(Messages.class);
    private static ResourceBundleSupport bundle = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.ui.datasources.jdbc.messages", ObjectUtilities.getClassLoader(Messages.class));

    private Messages() {
    }

    public static String getString(String key, Object ... param1) {
        try {
            return bundle.formatMessage(key, param1);
        }
        catch (MissingResourceException e) {
            logger.warn((Object)("Missing localization: " + key), (Throwable)e);
            return '!' + key + '!';
        }
    }

    public static Icon getIcon(String key, boolean large) {
        return bundle.getIcon(key, large);
    }

    public static Icon getIcon(String key) {
        return bundle.getIcon(key);
    }

    public static Integer getMnemonic(String key) {
        return bundle.getMnemonic(key);
    }

    public static Integer getOptionalMnemonic(String key) {
        return bundle.getOptionalMnemonic(key);
    }

    public static KeyStroke getKeyStroke(String key) {
        return bundle.getKeyStroke(key);
    }

    public static KeyStroke getOptionalKeyStroke(String key) {
        return bundle.getOptionalKeyStroke(key);
    }

    public static KeyStroke getKeyStroke(String key, int mask) {
        return bundle.getKeyStroke(key, mask);
    }

    public static KeyStroke getOptionalKeyStroke(String key, int mask) {
        return bundle.getOptionalKeyStroke(key, mask);
    }
}

