/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.states.LengthLimitingTableModel;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;

public class JdbcPreviewWorker
implements PreviewWorker {
    private DataFactory dataFactory;
    private String query;
    private int queryTimeout;
    private int queryLimit;
    private ReportDataFactoryException exception;
    private TableModel tableModel;

    public JdbcPreviewWorker(DataFactory dataFactory, String query, int queryTimeout, int queryLimit) {
        this.query = query;
        this.queryTimeout = queryTimeout;
        this.queryLimit = queryLimit;
        this.dataFactory = dataFactory;
    }

    public ReportDataFactoryException getException() {
        return this.exception;
    }

    public TableModel getResultTableModel() {
        return this.tableModel;
    }

    public void close() {
        if (this.tableModel instanceof CloseableTableModel) {
            CloseableTableModel ct = (CloseableTableModel)this.tableModel;
            ct.close();
        }
        this.dataFactory.close();
    }

    public void cancelProcessing(CancelEvent event) {
        this.dataFactory.cancelRunningQuery();
    }

    public void run() {
        try {
            this.tableModel = this.dataFactory.queryData(this.query, (DataRow)new QueryDataRowWrapper((DataRow)new ParameterDataRow(), this.queryLimit, this.queryTimeout));
            if (this.queryLimit > 0) {
                this.tableModel = new LengthLimitingTableModel(this.tableModel, this.queryLimit);
            }
        }
        catch (ReportDataFactoryException e) {
            this.exception = e;
        }
    }
}

