/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.ui.datasources.jdbc.JdbcDataSourceModule;

public class JdbcSecurityDialog
extends CommonDialog {
    private JComboBox jdbcUserFieldBox;
    private JComboBox jdbcPasswordFieldBox;
    private ResourceBundleSupport bundleSupport;

    public JdbcSecurityDialog(DesignTimeContext context) throws HeadlessException {
        this.init(context);
    }

    public JdbcSecurityDialog(Frame owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    public JdbcSecurityDialog(Dialog owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext context) {
        this.bundleSupport = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.ui.datasources.jdbc.messages", ObjectUtilities.getClassLoader(JdbcDataSourceModule.class));
        this.setTitle(this.bundleSupport.getString("JdbcSecurityDialog.Title"));
        String[] reportFields = context.getDataSchemaModel().getColumnNames();
        this.jdbcPasswordFieldBox = new JComboBox<String>(reportFields);
        this.jdbcPasswordFieldBox.setEditable(true);
        this.jdbcUserFieldBox = new JComboBox<String>(reportFields);
        this.jdbcUserFieldBox.setEditable(true);
        super.init();
    }

    protected String getDialogId() {
        return "JdbcDataSourceEditor.Security";
    }

    protected Component createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)new JLabel(this.bundleSupport.getString("JdbcSecurityDialog.JDBCUser.FieldValue")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        contentPane.add((Component)this.jdbcUserFieldBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)new JLabel(this.bundleSupport.getString("JdbcSecurityDialog.JDBCPassword.FieldValue")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        contentPane.add((Component)this.jdbcPasswordFieldBox, gbc);
        return contentPane;
    }

    public String getJdbcUserField() {
        Object o = this.jdbcUserFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setJdbcUserField(String jdbcUserField) {
        this.jdbcUserFieldBox.setSelectedItem(jdbcUserField);
    }

    public String getJdbcPasswordField() {
        Object o = this.jdbcPasswordFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setJdbcPasswordField(String jdbcPasswordField) {
        this.jdbcPasswordFieldBox.setSelectedItem(jdbcPasswordField);
    }

    public boolean performEdit() {
        return super.performEdit();
    }
}

