/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantExpression
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    Object value;
    Result res = new Result();

    public ConstantExpression(OperatorKey k) {
        this(k, -1);
    }

    public ConstantExpression(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public String name() {
        if (this.value != null) {
            return "Constant(" + this.value.toString() + ") - " + this.mKey.toString();
        }
        return "Constant(DummyVal) - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitConstant(this);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        Tuple dummyTuple = TupleFactory.getInstance().newTuple(1);
        this.attachInput(dummyTuple);
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (DataBag)this.value;
        return this.res;
    }

    @Override
    public Result getNext(DataByteArray ba) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (DataByteArray)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Double)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Float)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Integer)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Long)this.value;
        return this.res;
    }

    @Override
    public Result getNext(String s) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (String)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Tuple)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Boolean b) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Boolean)this.value;
        return this.res;
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = (Map)this.value;
        return this.res;
    }

    @Override
    public ConstantExpression clone() throws CloneNotSupportedException {
        ConstantExpression clone = new ConstantExpression(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.value = this.value;
        clone.cloneHelper(this);
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }
}

