/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.DataType;
import org.apache.pig.data.ReadOnceBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.plan.OperatorKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPackageLite
extends POPackage {
    private static final long serialVersionUID = 1L;

    public POPackageLite(OperatorKey k) {
        super(k, -1, null);
    }

    public POPackageLite(OperatorKey k, int rp) {
        super(k, rp, null);
    }

    public POPackageLite(OperatorKey k, List<PhysicalOperator> inp) {
        super(k, -1, inp);
    }

    public POPackageLite(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void setNumInps(int numInps) {
        if (numInps != 1) {
            throw new RuntimeException("POPackageLite can only take 1 input");
        }
        this.numInputs = numInps;
    }

    @Override
    public boolean[] getInner() {
        throw new RuntimeException("POPackageLite does not support getInner operation");
    }

    @Override
    public void setInner(boolean[] inner) {
        throw new RuntimeException("POPackageLite does not support setInner operation");
    }

    @Override
    public POPackageLite clone() throws CloneNotSupportedException {
        POPackageLite clone = (POPackageLite)super.clone();
        clone.inner = null;
        clone.keyInfo = new HashMap();
        for (Map.Entry entry : this.keyInfo.entrySet()) {
            clone.keyInfo.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    @Override
    public boolean isDistinct() {
        throw new RuntimeException("POPackageLite does not support isDistinct operation");
    }

    @Override
    public void setDistinct(boolean distinct) {
        throw new RuntimeException("POPackageLite does not support setDistinct operation");
    }

    public boolean getKeyTuple() {
        return this.isKeyTuple;
    }

    public Tuple getKeyAsTuple() {
        return this.keyAsTuple;
    }

    public Iterator<NullableTuple> getTupIter() {
        return this.tupIter;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        ReadOnceBag db = null;
        db = new ReadOnceBag(this, this.tupIter, this.key);
        if (reporter != null) {
            reporter.progress();
        }
        Tuple res = mTupleFactory.newTuple(this.numInputs + 1);
        res.set(0, this.key);
        res.set(1, db);
        this.detachInput();
        Result r = new Result();
        r.result = res;
        r.returnStatus = 0;
        return r;
    }

    public Tuple getValueTuple(NullableTuple ntup, int index, Object key) throws ExecException {
        Object origKey = this.key;
        this.key = key;
        Tuple retTuple = super.getValueTuple(ntup, index);
        this.key = origKey;
        return retTuple;
    }

    @Override
    public String name() {
        return this.getAliasString() + "PackageLite" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + " - " + this.mKey.toString();
    }
}

