/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOCross
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private static Log log = LogFactory.getLog(LOCross.class);
    private List<LogicalOperator> mSchemaInputMapping = new ArrayList<LogicalOperator>();

    public LOCross(LogicalPlan plan, OperatorKey k) {
        super(plan, k);
    }

    public List<LogicalOperator> getInputs() {
        return this.mPlan.getPredecessors(this);
    }

    @Override
    public Schema getSchema() throws FrontendException {
        List<LOCross> inputs = this.mPlan.getPredecessors(this);
        if (!this.mIsSchemaComputed) {
            ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>();
            this.mSchemaInputMapping = new ArrayList<LogicalOperator>();
            HashMap<Schema.FieldSchema, String> flattenAlias = new HashMap<Schema.FieldSchema, String>();
            HashMap<String, Boolean> inverseFlattenAlias = new HashMap<String, Boolean>();
            HashMap<String, Integer> aliases = new HashMap<String, Integer>();
            for (LogicalOperator logicalOperator : inputs) {
                String opAlias = logicalOperator.getAlias();
                Schema s = logicalOperator.getSchema();
                if (null != s) {
                    for (Schema.FieldSchema fs : s.getFields()) {
                        Schema.FieldSchema newFs;
                        log.debug((Object)("fs: " + fs));
                        log.debug((Object)("fs.alias: " + fs.alias));
                        if (null != fs.alias) {
                            String disambiguatorAlias = opAlias + "::" + fs.alias;
                            newFs = new Schema.FieldSchema(disambiguatorAlias, fs.schema, fs.type);
                            fss.add(newFs);
                            this.mSchemaInputMapping.add(logicalOperator);
                            Integer count = (Integer)aliases.get(fs.alias);
                            if (null == count) {
                                aliases.put(fs.alias, 1);
                            } else {
                                count = count + 1;
                                aliases.put(fs.alias, count);
                            }
                            count = (Integer)aliases.get(disambiguatorAlias);
                            if (null == count) {
                                aliases.put(disambiguatorAlias, 1);
                            } else {
                                count = count + 1;
                                aliases.put(disambiguatorAlias, count);
                            }
                            flattenAlias.put(newFs, fs.alias);
                            inverseFlattenAlias.put(fs.alias, true);
                        } else {
                            newFs = new Schema.FieldSchema(null, 50);
                            fss.add(newFs);
                            this.mSchemaInputMapping.add(logicalOperator);
                        }
                        newFs.setParent(fs.canonicalName, logicalOperator);
                    }
                    continue;
                }
                this.mSchema = null;
                this.mIsSchemaComputed = true;
                return this.mSchema;
            }
            log.debug((Object)(" flattenAlias: " + flattenAlias));
            log.debug((Object)(" inverseFlattenAlias: " + inverseFlattenAlias));
            log.debug((Object)(" aliases: " + aliases));
            log.debug((Object)(" fss.size: " + fss.size()));
            boolean duplicates = false;
            HashSet hashSet = new HashSet();
            for (Map.Entry e : aliases.entrySet()) {
                Integer count = (Integer)e.getValue();
                if (count <= 1) continue;
                Boolean inFlatten = false;
                log.debug((Object)("inFlatten: " + inFlatten + " inverseFlattenAlias: " + inverseFlattenAlias));
                inFlatten = (Boolean)inverseFlattenAlias.get(e.getKey());
                log.debug((Object)("inFlatten: " + inFlatten + " inverseFlattenAlias: " + inverseFlattenAlias));
                if (null == inFlatten || inFlatten.booleanValue()) continue;
                duplicates = true;
                hashSet.add(e.getKey());
            }
            if (duplicates) {
                String errMessage = null;
                StringBuilder sb = new StringBuilder("Found duplicates in schema. ");
                if (hashSet.size() > 0) {
                    Iterator iter = hashSet.iterator();
                    sb.append(": ");
                    sb.append((String)iter.next());
                    while (iter.hasNext()) {
                        sb.append(", ");
                        sb.append((String)iter.next());
                    }
                }
                sb.append(". Please alias the columns with unique names.");
                errMessage = sb.toString();
                int errCode = 1007;
                throw new FrontendException(errMessage, errCode, 2, false, null);
            }
            this.mSchema = new Schema(fss);
            for (Schema.FieldSchema fs : this.mSchema.getFields()) {
                String alias = (String)flattenAlias.get(fs);
                Integer count = (Integer)aliases.get(alias);
                if (null == count) {
                    count = 1;
                }
                log.debug((Object)("alias: " + alias));
                if (null == alias || count != 1) continue;
                this.mSchema.addAlias(alias, fs);
            }
            this.mIsSchemaComputed = true;
        }
        return this.mSchema;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Cross " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (outputSchema == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        MultiMap<Integer, ProjectionMap.Column> mapFields = new MultiMap<Integer, ProjectionMap.Column>();
        ArrayList<Integer> addedFields = new ArrayList<Integer>();
        boolean[] unknownSchema = new boolean[predecessors.size()];
        boolean anyUnknownInputSchema = false;
        int outputColumnNum = 0;
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            LogicalOperator predecessor = (LogicalOperator)predecessors.get(inputNum);
            Schema inputSchema = null;
            try {
                inputSchema = predecessor.getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            if (inputSchema == null) {
                unknownSchema[inputNum] = true;
                ++outputColumnNum;
                addedFields.add(inputNum);
                anyUnknownInputSchema = true;
                continue;
            }
            unknownSchema[inputNum] = false;
            for (int inputColumn = 0; inputColumn < inputSchema.size(); ++inputColumn) {
                mapFields.put((Integer)outputColumnNum++, new ProjectionMap.Column(new Pair<Integer, Integer>(inputNum, inputColumn)));
            }
        }
        if (anyUnknownInputSchema) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (addedFields.size() == 0) {
            addedFields = null;
        }
        this.mProjectionMap = new ProjectionMap(mapFields, null, addedFields);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        List<LOCross> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            requiredFields.add(new RequiredFields(true));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema == null) {
            return null;
        }
        if (column > this.mSchema.size() - 1) {
            return null;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        for (int i = 0; i < predecessors.size(); ++i) {
            result.add(null);
        }
        int inputNum = -1;
        int inputColumn = 0;
        LogicalOperator op = null;
        for (int i = 0; i <= column; ++i) {
            if (this.mSchemaInputMapping.get(i) != op) {
                ++inputNum;
                inputColumn = 0;
                op = this.mSchemaInputMapping.get(i);
                continue;
            }
            ++inputColumn;
        }
        ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
        inputList.add(new Pair<Integer, Integer>(inputNum, inputColumn));
        RequiredFields requiredFields = new RequiredFields(inputList);
        result.set(inputNum, requiredFields);
        return result;
    }
}

