/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class LOMapLookup
extends ExpressionOperator {
    private static final long serialVersionUID = 2L;
    private String mMapKey;
    private byte mValueType;
    private Schema mValueSchema;
    private static Log log = LogFactory.getLog(LOMapLookup.class);

    public LOMapLookup(LogicalPlan plan, OperatorKey key, String mapKey, byte valueType, Schema valueSchema) throws ParseException {
        super(plan, key);
        if (!DataType.isAtomic(DataType.findType(mapKey))) {
            throw new ParseException("Map key " + mapKey + " is not atomic");
        }
        this.mMapKey = mapKey;
        this.mValueType = valueType;
        this.mValueSchema = valueSchema;
        this.mType = this.mValueType;
    }

    public ExpressionOperator getMap() {
        List<LOMapLookup> preds = this.getPlan().getPredecessors(this);
        if (preds == null) {
            return null;
        }
        return preds.get(0);
    }

    public String getLookUpKey() {
        return this.mMapKey;
    }

    public byte getValueType() {
        return this.mValueType;
    }

    public String name() {
        return "MapLookup " + this.mKey.scope + "-" + this.mKey.id;
    }

    public boolean supportsMultipleInputs() {
        return false;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        if (!this.mIsFieldSchemaComputed) {
            this.mFieldSchema = DataType.isSchemaType(this.mValueType) ? new Schema.FieldSchema(null, this.mValueSchema, this.mValueType) : new Schema.FieldSchema(null, this.mValueType);
            ExpressionOperator map = this.getMap();
            this.mFieldSchema.setParent(map.getFieldSchema().canonicalName, map);
            this.mIsFieldSchemaComputed = true;
        }
        return this.mFieldSchema;
    }

    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    protected Object clone() throws CloneNotSupportedException {
        LOMapLookup clone = (LOMapLookup)super.clone();
        if (this.mValueSchema != null) {
            clone.mValueSchema = this.mValueSchema.clone();
        }
        return clone;
    }
}

