/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFixerUpper
extends LOVisitor {
    private LogicalOperator mNewNode;
    private LogicalOperator mOldNode;
    private int mPredecessorIndex;
    private boolean mUseOldNode;
    private LogicalOperator mContainingNode;
    private Map<Integer, Integer> mProjectionMapping;

    public ProjectFixerUpper(LogicalPlan plan, LogicalOperator oldNode, int oldNodeIndex, LogicalOperator newNode, boolean useOldNode, LogicalOperator containingNode) throws VisitorException {
        this(plan, oldNode, newNode, null);
        if (containingNode == null) {
            int errCode = 1097;
            String msg = "Containing node cannot be null.";
            throw new VisitorException(msg, errCode, 2);
        }
        if (oldNodeIndex < 0) {
            int errCode = 1098;
            String msg = "Node index cannot be negative.";
            throw new VisitorException(msg, errCode, 2);
        }
        this.mContainingNode = containingNode;
        this.mPredecessorIndex = oldNodeIndex;
        this.mUseOldNode = useOldNode;
    }

    public ProjectFixerUpper(LogicalPlan plan, LogicalOperator oldNode, LogicalOperator newNode, Map<Integer, Integer> projectionMapping) throws VisitorException {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
        if (oldNode == null) {
            int errCode = 1099;
            String msg = "Node to be replaced cannot be null.";
            throw new VisitorException(msg, errCode, 2);
        }
        this.mNewNode = newNode;
        this.mOldNode = oldNode;
        this.mProjectionMapping = projectionMapping;
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
    }

    @Override
    protected void visit(LOFilter f) throws VisitorException {
    }

    @Override
    protected void visit(LOSplit s) throws VisitorException {
    }

    @Override
    protected void visit(LOSplitOutput s) throws VisitorException {
    }

    @Override
    protected void visit(LOForEach f) throws VisitorException {
    }

    @Override
    protected void visit(LOProject p) throws VisitorException {
        List<LOProject> preds = ((LogicalPlan)this.mPlan).getPredecessors(p);
        if (preds == null || preds.size() == 0) {
            if (p.getExpression().equals(this.mOldNode)) {
                if (this.mNewNode == null) {
                    int errCode = 1100;
                    String msg = "Replacement node cannot be null.";
                    throw new VisitorException(msg, errCode, 2);
                }
                p.setExpression(this.mNewNode);
                if (p.isStar()) {
                    return;
                }
                if (this.mContainingNode != null) {
                    int oldNodeColumn = p.getCol();
                    if (this.mUseOldNode) {
                        ProjectionMap oldNodeMap = this.mOldNode.getProjectionMap();
                        if (oldNodeMap == null) {
                            int errCode = 2156;
                            String msg = "Error while fixing projections. Projection map of node to be replaced is null.";
                            throw new VisitorException(msg, errCode, 4);
                        }
                        if (!oldNodeMap.changes()) {
                            return;
                        }
                        MultiMap<Integer, ProjectionMap.Column> oldNodeMappedFields = oldNodeMap.getMappedFields();
                        if (oldNodeMappedFields == null) {
                            int errCode = 2157;
                            String msg = "Error while fixing projections. No mapping available in old predecessor to replace column.";
                            throw new VisitorException(msg, errCode, 4);
                        }
                        List columns = (List)oldNodeMappedFields.get(oldNodeColumn);
                        if (columns == null) {
                            int errCode = 2158;
                            String msg = "Error during fixing projections. No mapping available in old predecessor for column to be replaced.";
                            throw new VisitorException(msg, errCode, 4);
                        }
                        boolean foundMapping = false;
                        for (ProjectionMap.Column column : columns) {
                            Pair<Integer, Integer> pair = column.getInputColumn();
                            if (!((Integer)pair.first).equals(this.mPredecessorIndex)) continue;
                            ArrayList<Integer> newColumns = new ArrayList<Integer>();
                            newColumns.add((Integer)pair.second);
                            p.setProjection(newColumns);
                            foundMapping = true;
                            break;
                        }
                        if (!foundMapping) {
                            int errCode = 2159;
                            String msg = "Error during fixing projections. Could not locate replacement column from the old predecessor.";
                            throw new VisitorException(msg, errCode, 4);
                        }
                        return;
                    }
                    ProjectionMap newNodeMap = this.mNewNode.getProjectionMap();
                    if (newNodeMap == null) {
                        int errCode = 2160;
                        String msg = "Error during fixing projections. Projection map of new predecessor is null.";
                        throw new VisitorException(msg, errCode, 4);
                    }
                    if (!newNodeMap.changes()) {
                        return;
                    }
                    MultiMap<Integer, ProjectionMap.Column> newNodeMappedFields = newNodeMap.getMappedFields();
                    if (newNodeMappedFields == null) {
                        int errCode = 2161;
                        String msg = "Error during fixing projections. No mapping available in new predecessor to replace column.";
                        throw new VisitorException(msg, errCode, 4);
                    }
                    boolean foundMapping = false;
                    for (Integer key : newNodeMappedFields.keySet()) {
                        List columns = (List)newNodeMappedFields.get(key);
                        if (columns == null) {
                            int errCode = 2162;
                            String msg = "Error during fixing projections. Could not locate mapping for column: " + key + " in new predecessor.";
                            throw new VisitorException(msg, errCode, 4);
                        }
                        for (ProjectionMap.Column column : columns) {
                            Pair<Integer, Integer> pair = column.getInputColumn();
                            if (!((Integer)pair.first).equals(this.mPredecessorIndex) || !((Integer)pair.second).equals(oldNodeColumn)) continue;
                            ArrayList<Integer> newColumns = new ArrayList<Integer>();
                            newColumns.add(key);
                            p.setProjection(newColumns);
                            foundMapping = true;
                            break;
                        }
                        if (!foundMapping) continue;
                        return;
                    }
                    if (!foundMapping) {
                        int errCode = 2163;
                        String msg = "Error during fixing projections. Could not locate replacement column for column: " + oldNodeColumn + " in the new predecessor.";
                        throw new VisitorException(msg, errCode, 4);
                    }
                }
            }
            if (this.mProjectionMapping != null && !p.isStar()) {
                List<Integer> oldProjection = p.getProjection();
                ArrayList<Integer> newProjection = new ArrayList<Integer>(oldProjection.size());
                for (Integer i : oldProjection) {
                    Integer n = this.mProjectionMapping.get(i);
                    assert (n != null);
                    newProjection.add(n);
                }
            }
        } else {
            p.getExpression().visit(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("old node: " + this.mOldNode);
        sb.append(" old node index: " + this.mPredecessorIndex);
        sb.append(" new node: " + this.mNewNode);
        sb.append(" containing node: " + this.mContainingNode);
        sb.append(" mProjectionMapping: " + this.mProjectionMapping);
        return sb.toString();
    }
}

