/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationalOperator
extends LogicalOperator {
    private static final long serialVersionUID = 2L;

    public RelationalOperator(LogicalPlan plan, OperatorKey k, int rp) {
        super(plan, k, rp);
    }

    public RelationalOperator(LogicalPlan plan, OperatorKey k) {
        super(plan, k);
    }

    @Override
    public ProjectionMap getProjectionMap() {
        return null;
    }

    @Override
    public void unsetProjectionMap() {
        this.mIsProjectionMapComputed = false;
        this.mProjectionMap = null;
    }

    @Override
    public ProjectionMap regenerateProjectionMap() {
        try {
            this.regenerateSchema();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unsetProjectionMap();
        return this.getProjectionMap();
    }

    public List<RequiredFields> getRequiredFields() {
        return null;
    }

    public abstract List<RequiredFields> getRelevantInputs(int var1, int var2) throws FrontendException;

    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        this.unsetSchema();
        this.getSchema();
        this.mIsProjectionMapComputed = false;
        this.getProjectionMap();
        return true;
    }

    public void pruneColumnInPlan(LogicalPlan plan, int column) throws FrontendException {
        TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
        try {
            projectFinder.visit();
        }
        catch (VisitorException ve) {
            int errCode = 2196;
            throw new FrontendException("Exception when traversing inner plan", errCode, 4, ve);
        }
        for (LOProject loProject : projectFinder.getProjectSet()) {
            if (loProject.isStar()) {
                int errCode = 2197;
                throw new FrontendException("Cannot drop column which require *", errCode, 4);
            }
            int col = loProject.getCol();
            if (column >= col) continue;
            loProject.getProjection().set(0, col - 1);
        }
    }

    public LogicalOperator insertPlainForEachAfter(List<Integer> columnsToProject) throws FrontendException {
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        String scope = this.getOperatorKey().scope;
        for (int pos : columnsToProject) {
            LogicalPlan projectPlan = new LogicalPlan();
            LOProject column = new LOProject(projectPlan, new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), (LogicalOperator)this, pos);
            flattenList.add(false);
            projectPlan.add(column);
            generatePlans.add(projectPlan);
        }
        LOForEach forEach = new LOForEach(this.mPlan, new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), generatePlans, flattenList);
        LogicalOperator succ = this.mPlan.getSuccessors(this).get(0);
        MultiMap<Integer, ProjectionMap.Column> mappedFields = new MultiMap<Integer, ProjectionMap.Column>();
        for (int i = 0; i <= this.getSchema().size(); ++i) {
            ArrayList<ProjectionMap.Column> columns = new ArrayList<ProjectionMap.Column>();
            columns.add(new ProjectionMap.Column(new Pair<Integer, Integer>(0, i)));
            mappedFields.put((Integer)i, columns);
        }
        this.mPlan.add(forEach);
        this.mPlan.doInsertBetween(this, forEach, succ, false);
        forEach.getProjectionMap().setMappedFields(mappedFields);
        succ.rewire(this, 0, forEach, false);
        return forEach;
    }
}

