/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.List;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveRedundantOperators
extends LOVisitor {
    public RemoveRedundantOperators(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
    }

    @Override
    protected void visit(LOProject project) throws VisitorException {
        LogicalPlan currentPlan = (LogicalPlan)this.mCurrentWalker.getPlan();
        if (project.isStar()) {
            List<LogicalOperator> prSuccessors = currentPlan.getSuccessors(project);
            List<LOProject> prPredecessors = currentPlan.getPredecessors(project);
            if (prSuccessors != null && prSuccessors.size() > 0 && prPredecessors != null && prPredecessors.size() == 1) {
                LogicalOperator pred = prPredecessors.get(0);
                boolean allExpressionOp = true;
                boolean allRelationalOp = true;
                if (pred instanceof ExpressionOperator) {
                    allRelationalOp = false;
                } else {
                    allExpressionOp = false;
                }
                for (LogicalOperator op : prSuccessors) {
                    if (op instanceof ExpressionOperator) {
                        allRelationalOp = false;
                    } else {
                        allExpressionOp = false;
                    }
                    if (allExpressionOp || allRelationalOp) continue;
                    break;
                }
                if (allExpressionOp || allRelationalOp) {
                    try {
                        currentPlan.removeAndReconnectMultiSucc(project);
                        this.patchInputReference(pred, project, prSuccessors);
                    }
                    catch (PlanException pe) {
                        String msg = "Error while removing redundant project in plan";
                        throw new VisitorException(msg, pe);
                    }
                }
            }
        }
    }

    private void patchInputReference(LogicalOperator pred, LogicalOperator current, List<LogicalOperator> succs) {
        for (LogicalOperator n : succs) {
            LOProject lop;
            if (!(n instanceof LOProject) || current != (lop = (LOProject)n).getExpression()) continue;
            lop.setExpression(pred);
        }
    }
}

