/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.optimizer.OptimizerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitSplitInserter
extends LogicalTransformer {
    public ImplicitSplitInserter(LogicalPlan plan) {
        super(plan);
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        try {
            LogicalOperator op = nodes.get(0);
            List<LogicalOperator> succs = ((LogicalPlan)this.mPlan).getSuccessors(op);
            if (succs == null || succs.size() < 2) {
                return false;
            }
            if (op instanceof LOSplit) {
                return false;
            }
            return !(op instanceof LOStore);
        }
        catch (Exception e) {
            int errCode = 2048;
            String msg = "Error while performing checks to introduce split operators.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        try {
            String scope = nodes.get((int)0).getOperatorKey().scope;
            NodeIdGenerator idGen = NodeIdGenerator.getGenerator();
            LOSplit splitOp = new LOSplit((LogicalPlan)this.mPlan, new OperatorKey(scope, idGen.getNextNodeId(scope)), new ArrayList<LogicalOperator>());
            splitOp.setAlias(nodes.get(0).getAlias());
            ((LogicalPlan)this.mPlan).add(splitOp);
            ArrayList<Operator> succs = new ArrayList<Operator>(((LogicalPlan)this.mPlan).getSuccessors((Operator)nodes.get(0)));
            int index = -1;
            for (LogicalOperator logicalOperator : succs) {
                ((LogicalPlan)this.mPlan).insertBetween((Operator)nodes.get(0), splitOp, logicalOperator);
            }
            for (int i = 1; i < succs.size(); ++i) {
                ((LogicalPlan)this.mPlan).disconnect((Operator)nodes.get(0), splitOp);
            }
            for (LogicalOperator logicalOperator : succs) {
                LogicalPlan condPlan = new LogicalPlan();
                LOConst cnst = new LOConst((LogicalPlan)this.mPlan, new OperatorKey(scope, idGen.getNextNodeId(scope)), true);
                cnst.setType((byte)5);
                condPlan.add(cnst);
                LOSplitOutput splitOutput = new LOSplitOutput((LogicalPlan)this.mPlan, new OperatorKey(scope, idGen.getNextNodeId(scope)), ++index, condPlan);
                splitOp.addOutput(splitOutput);
                ((LogicalPlan)this.mPlan).add(splitOutput);
                ((LogicalPlan)this.mPlan).insertBetween(splitOp, splitOutput, logicalOperator);
                splitOutput.setAlias(splitOp.getAlias());
            }
        }
        catch (Exception e) {
            int errCode = 2047;
            String msg = "Internal error. Unable to introduce split operators.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }
}

