/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.CastFinder;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LONative;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.UDFFinder;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushUpFilter
extends LogicalTransformer {
    private boolean mSwap = false;
    private boolean mPushBefore = false;
    private int mPushBeforeInput = -1;

    public PushUpFilter(LogicalPlan plan) {
        super(plan);
    }

    public boolean getSwap() {
        return this.mSwap;
    }

    public boolean getPushBefore() {
        return this.mPushBefore;
    }

    public int getPushBeforeInput() {
        return this.mPushBeforeInput;
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            ArrayList<LOFilter> predecessors;
            LOFilter filter = (LOFilter)this.getOperator(nodes);
            ArrayList<LOFilter> arrayList = predecessors = ((LogicalPlan)this.mPlan).getPredecessors(filter) == null ? null : new ArrayList<LOFilter>(((LogicalPlan)this.mPlan).getPredecessors(filter));
            if (predecessors == null) {
                return false;
            }
            if (predecessors.size() == 0 || predecessors.size() > 1) {
                return false;
            }
            LogicalOperator predecessor = (LogicalOperator)predecessors.get(0);
            if (predecessor instanceof LOLoad || predecessor instanceof LOStore || predecessor instanceof LOStream || predecessor instanceof LOLimit || predecessor instanceof LONative) {
                return false;
            }
            if (predecessor instanceof LOFilter) {
                return false;
            }
            if (predecessor instanceof LOSplitOutput) {
                return false;
            }
            if (predecessor instanceof LOSplit) {
                return false;
            }
            UDFFinder udfFinder = new UDFFinder(filter.getComparisonPlan());
            udfFinder.visit();
            if (udfFinder.foundAnyUDF()) {
                return false;
            }
            CastFinder castFinder = new CastFinder(filter.getComparisonPlan());
            castFinder.visit();
            if (castFinder.foundAnyCast()) {
                return false;
            }
            List<RequiredFields> filterRequiredFields = filter.getRequiredFields();
            if (filterRequiredFields == null) {
                return false;
            }
            RequiredFields requiredField = filterRequiredFields.get(0);
            if (requiredField.needNoFields()) {
                return false;
            }
            if (predecessor instanceof LOCross || predecessor instanceof LOUnion || predecessor instanceof LOCogroup || predecessor instanceof LOJoin) {
                List<LogicalOperator> grandParents = ((LogicalPlan)this.mPlan).getPredecessors(predecessor);
                if (grandParents == null || grandParents.size() == 0) {
                    return false;
                }
                if (grandParents.size() == 1) {
                    if (predecessor instanceof LOCogroup) {
                        this.mSwap = true;
                        return true;
                    }
                    return false;
                }
                if (requiredField.needAllFields()) {
                    return false;
                }
                Pair<Boolean, Set<Integer>> mappingResult = this.isRequiredFieldMapped(requiredField, predecessor.getProjectionMap());
                boolean mapped = (Boolean)mappingResult.first;
                Set grandParentIndexes = (Set)mappingResult.second;
                if (!mapped) {
                    return false;
                }
                if (grandParentIndexes == null || grandParentIndexes.size() == 0 || grandParentIndexes.size() > 1) {
                    return false;
                }
                if (predecessor instanceof LOCogroup && this.isAnyOuter((LOCogroup)predecessor)) {
                    return false;
                }
                this.mPushBeforeInput = (Integer)grandParentIndexes.iterator().next();
                if (predecessor instanceof LOJoin) {
                    boolean otherBranchContainOuter = false;
                    boolean sawInner = false;
                    for (int i = 0; i <= ((LogicalPlan)this.mPlan).getSuccessors(predecessor).size(); ++i) {
                        if (i != this.mPushBeforeInput && ((LOJoin)predecessor).getInnerFlags()[i]) {
                            otherBranchContainOuter = true;
                        }
                        if (((LOJoin)predecessor).getInnerFlags()[i]) continue;
                        sawInner = true;
                    }
                    if (!otherBranchContainOuter && !((LOJoin)predecessor).getInnerFlags()[this.mPushBeforeInput]) {
                        this.mPushBeforeInput = -1;
                        return false;
                    }
                    if (otherBranchContainOuter && sawInner) {
                        this.mPushBeforeInput = -1;
                        return false;
                    }
                }
                this.mPushBefore = true;
                return true;
            }
            if (predecessor instanceof LOForEach) {
                LOForEach loForEach = (LOForEach)predecessor;
                List<Boolean> mFlatten = loForEach.getFlatten();
                boolean hasFlatten = false;
                for (Boolean b : mFlatten) {
                    if (!b.equals(true)) continue;
                    hasFlatten = true;
                }
                if (hasFlatten) {
                    return false;
                }
                Pair<Boolean, Set<Integer>> mappingResult = this.isRequiredFieldMapped(requiredField, predecessor.getProjectionMap());
                boolean mapped = (Boolean)mappingResult.first;
                for (Pair<Integer, Integer> pair : requiredField.getFields()) {
                    if (this.isFieldSimple(loForEach.getForEachPlans().get((Integer)pair.second))) continue;
                    mapped = false;
                    break;
                }
                if (!mapped) {
                    return false;
                }
            }
            this.mSwap = true;
            return true;
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2149;
            String msg = "Internal error while trying to check if filters can be pushed up.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    private LogicalOperator getOperator(List<LogicalOperator> nodes) throws FrontendException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        LogicalOperator lo = nodes.get(0);
        if (lo == null || !(lo instanceof LOFilter)) {
            int errCode = 2005;
            String msg = "Expected " + LOFilter.class.getSimpleName() + ", got " + (lo == null ? lo : lo.getClass().getSimpleName());
            throw new OptimizerException(msg, errCode, 2);
        }
        return lo;
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            LOFilter filter = (LOFilter)this.getOperator(nodes);
            LogicalOperator predecessor = ((LogicalPlan)this.mPlan).getPredecessors(filter).get(0);
            if (this.mSwap) {
                ((LogicalPlan)this.mPlan).swap(predecessor, filter);
            } else if (this.mPushBefore) {
                if (this.mPushBeforeInput == -1) {
                    int errCode = 2150;
                    String msg = "Internal error. The push before input is not set.";
                    throw new OptimizerException(msg, errCode, 4);
                }
                ((LogicalPlan)this.mPlan).pushBefore(predecessor, filter, this.mPushBeforeInput);
            }
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2151;
            String msg = "Internal error while pushing filters up.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    @Override
    public void reset() {
        this.mPushBefore = false;
        this.mPushBeforeInput = -1;
        this.mSwap = false;
    }

    private boolean isAnyOuter(LOCogroup cogroup) {
        boolean[] innerList;
        for (boolean inner : innerList = cogroup.getInner()) {
            if (inner) continue;
            return true;
        }
        return false;
    }

    private Pair<Boolean, Set<Integer>> isRequiredFieldMapped(RequiredFields requiredField, ProjectionMap predProjectionMap) {
        if (requiredField == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        if (predProjectionMap == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        if (!predProjectionMap.changes()) {
            return new Pair<Boolean, Object>(true, null);
        }
        MultiMap<Integer, ProjectionMap.Column> mappedFields = predProjectionMap.getMappedFields();
        if (mappedFields == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        HashSet predInputs = new HashSet();
        for (Pair<Integer, Integer> pair : requiredField.getFields()) {
            predInputs.add(pair.second);
        }
        boolean mapped = false;
        HashSet grandParentIndexes = new HashSet();
        for (Integer input : predInputs) {
            List inputList = (List)mappedFields.get(input);
            if (inputList == null) {
                return new Pair<Boolean, Object>(false, null);
            }
            for (ProjectionMap.Column column : inputList) {
                if (!column.cast()) {
                    mapped = true;
                }
                Pair<Integer, Integer> pair = column.getInputColumn();
                grandParentIndexes.add(pair.first);
            }
        }
        if (!mapped) {
            return new Pair<Boolean, Object>(false, null);
        }
        return new Pair<Boolean, Set<Integer>>(true, grandParentIndexes);
    }

    boolean isFieldSimple(LogicalPlan lp) throws OptimizerException {
        TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(lp);
        try {
            projectFinder.visit();
        }
        catch (VisitorException ve) {
            throw new OptimizerException();
        }
        if (projectFinder.getProjectSet() != null && projectFinder.getProjectSet().size() == 1) {
            LOProject project = projectFinder.getProjectSet().iterator().next();
            if (lp.getPredecessors(project) == null) {
                LogicalOperator pred = project;
                while (lp.getSuccessors(pred) != null) {
                    if (lp.getSuccessors(pred).size() != 1) {
                        return false;
                    }
                    if (!(lp.getSuccessors(pred).get(0) instanceof LOCast)) {
                        return false;
                    }
                    pred = lp.getSuccessors(pred).get(0);
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

