/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.validators;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.PlanWalker;

public class InputOutputFileVisitor
extends LOVisitor {
    private PigContext pigCtx;
    private CompilationMessageCollector msgCollector;

    public InputOutputFileVisitor(LogicalPlan plan, CompilationMessageCollector messageCollector, PigContext pigContext) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
        this.pigCtx = pigContext;
        this.msgCollector = messageCollector;
    }

    protected void visit(LOStore store) throws PlanValidationException {
        Job dummyJob;
        StoreFuncInterface sf = store.getStoreFunc();
        String outLoc = store.getOutputFile().getFileName();
        int errCode = 2116;
        String validationErrStr = "Output Location Validation Failed for: " + outLoc;
        try {
            if (store.getSchema() != null) {
                sf.checkSchema(new ResourceSchema(store.getSchema(), store.getSortInfo()));
            }
            dummyJob = new Job(ConfigurationUtil.toConfiguration(this.pigCtx.getProperties()));
            sf.setStoreLocation(outLoc, dummyJob);
        }
        catch (IOException ioe) {
            if (ioe instanceof PigException) {
                errCode = ((PigException)ioe).getErrorCode();
            }
            String exceptionMsg = ioe.getMessage();
            validationErrStr = validationErrStr + (exceptionMsg == null ? "" : " More info to follow:\n" + exceptionMsg);
            this.msgCollector.collect(validationErrStr, CompilationMessageCollector.MessageType.Error);
            throw new PlanValidationException(validationErrStr, errCode, this.pigCtx.getErrorSource(), ioe);
        }
        validationErrStr = validationErrStr + " More info to follow:\n";
        try {
            sf.getOutputFormat().checkOutputSpecs((JobContext)dummyJob);
        }
        catch (IOException ioe) {
            byte errSrc = this.pigCtx.getErrorSource();
            switch (errSrc) {
                case 4: {
                    errCode = 2002;
                    break;
                }
                case 16: {
                    errCode = 6000;
                    break;
                }
                case 8: {
                    errCode = 4000;
                }
            }
            validationErrStr = validationErrStr + ioe.getMessage();
            this.msgCollector.collect(validationErrStr, CompilationMessageCollector.MessageType.Error);
            throw new PlanValidationException(validationErrStr, errCode, errSrc, ioe);
        }
        catch (InterruptedException ie) {
            validationErrStr = validationErrStr + ie.getMessage();
            this.msgCollector.collect(validationErrStr, CompilationMessageCollector.MessageType.Error);
            throw new PlanValidationException(validationErrStr, errCode, this.pigCtx.getErrorSource(), ie);
        }
    }
}

