/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.validators;

import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LONative;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.PlanWalker;

public class SchemaAliasVisitor
extends LOVisitor {
    public SchemaAliasVisitor(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
    }

    protected void validate(LogicalOperator lo) throws PlanValidationException {
        try {
            Schema schema = lo.getSchema();
            if (schema != null) {
                for (int i = 0; i < schema.size(); ++i) {
                    for (int j = i + 1; j < schema.size(); ++j) {
                        if (schema.getField(i) == null || schema.getField(j) == null || schema.getField((int)i).alias == null || schema.getField((int)j).alias == null || !schema.getField((int)i).alias.equals(schema.getField((int)j).alias)) continue;
                        int errCode = 1108;
                        String msg = "Duplicate schema alias: " + schema.getField((int)i).alias;
                        if (lo.getAlias() != null) {
                            msg = msg + " in \"" + lo.getAlias() + "\"";
                        }
                        throw new PlanValidationException(msg, errCode, 2);
                    }
                }
            }
        }
        catch (PlanValidationException e) {
            throw e;
        }
        catch (FrontendException e) {
            int errCode = 2201;
            String msg = "Could not validate schema alias";
            throw new PlanValidationException(msg, errCode, 2);
        }
    }

    protected void visit(LOLoad load) throws PlanValidationException {
        this.validate(load);
    }

    protected void visit(LOCogroup cogroup) throws PlanValidationException {
        this.validate(cogroup);
    }

    protected void visit(LOCross cross) throws PlanValidationException {
        this.validate(cross);
    }

    protected void visit(LODistinct distinct) throws PlanValidationException {
        this.validate(distinct);
    }

    protected void visit(LOFilter filter) throws PlanValidationException {
        this.validate(filter);
    }

    protected void visit(LOForEach foreach) throws PlanValidationException {
        this.validate(foreach);
    }

    protected void visit(LOJoin join) throws PlanValidationException {
        this.validate(join);
    }

    protected void visit(LOLimit limit) throws PlanValidationException {
        this.validate(limit);
    }

    protected void visit(LOSort sort) throws PlanValidationException {
        this.validate(sort);
    }

    protected void visit(LOSplit split) throws PlanValidationException {
        this.validate(split);
    }

    protected void visit(LOSplitOutput splitoutput) throws PlanValidationException {
        this.validate(splitoutput);
    }

    protected void visit(LOStore store) throws PlanValidationException {
        this.validate(store);
    }

    protected void visit(LOStream stream) throws PlanValidationException {
        this.validate(stream);
    }

    protected void visit(LOUnion union) throws PlanValidationException {
        this.validate(union);
    }

    protected void visit(LONative nativeMR) throws PlanValidationException {
        this.validate(nativeMR);
    }
}

