/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanValidator<O extends Operator, P extends OperatorPlan<O>> {
    public abstract void validate(P var1, CompilationMessageCollector var2) throws PlanValidationException;

    protected void validate(PlanVisitor<O, P> visitor, CompilationMessageCollector messageCollector) throws PlanValidationException {
        try {
            visitor.visit();
        }
        catch (VisitorException ve) {
            messageCollector.collect("Unexpected exception in " + this.getClass().getSimpleName(), CompilationMessageCollector.MessageType.Error);
            String errMsg = "An unexpected exception caused the validation to stop";
            int errCode = 2257;
            throw new PlanValidationException(errMsg, errCode, ve);
        }
    }

    protected void validateTolerateException(PlanVisitor<O, P> visitor, CompilationMessageCollector messageCollector) throws PlanValidationException {
        try {
            visitor.visit();
        }
        catch (VisitorException ve) {
            messageCollector.collect("Unexpected exception in " + this.getClass().getSimpleName(), CompilationMessageCollector.MessageType.Error);
        }
    }

    protected void validateSkipCollectException(PlanVisitor<O, P> visitor, CompilationMessageCollector messageCollector) throws PlanValidationException {
        try {
            visitor.visit();
        }
        catch (VisitorException ve) {
            throw new PlanValidationException("An unexpected exception caused the validation to stop", ve);
        }
    }
}

