/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.RuleOperator;
import org.apache.pig.impl.plan.optimizer.RulePlan;
import org.apache.pig.impl.plan.optimizer.RulePlanVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonNodeFinder
extends RulePlanVisitor {
    private List<RuleOperator> mCommonNodes = null;

    public CommonNodeFinder(RulePlan plan) {
        super(plan, (PlanWalker<RuleOperator, RulePlan>)new DependencyOrderWalker<RuleOperator, RulePlan>(plan));
    }

    public int getCount() {
        return this.mCommonNodes == null ? 0 : this.mCommonNodes.size();
    }

    public List<RuleOperator> getCommonNodes() {
        return this.mCommonNodes;
    }

    private void reset() {
        this.mCommonNodes = new ArrayList<RuleOperator>();
    }

    @Override
    public void visit() throws VisitorException {
        this.reset();
        super.visit();
    }

    @Override
    protected void visit(RuleOperator ruleOp) throws VisitorException {
        if (ruleOp.getNodeType().equals((Object)RuleOperator.NodeType.ANY_NODE)) {
            return;
        }
        List<RuleOperator> predecessors = ((RulePlan)this.mPlan).getPredecessors(ruleOp);
        List<RuleOperator> successors = ((RulePlan)this.mPlan).getSuccessors(ruleOp);
        if (predecessors != null) {
            if (predecessors.size() > 1) {
                ruleOp.setNodeType(RuleOperator.NodeType.COMMON_NODE);
                this.mCommonNodes.add(ruleOp);
                return;
            }
            RuleOperator ruleOperatorPredecessor = predecessors.get(0);
            if (ruleOperatorPredecessor.getNodeType().equals((Object)RuleOperator.NodeType.COMMON_NODE)) {
                ruleOp.setNodeType(RuleOperator.NodeType.COMMON_NODE);
                this.mCommonNodes.add(ruleOp);
                return;
            }
        }
        if (successors != null && successors.size() > 1) {
            ruleOp.setNodeType(RuleOperator.NodeType.COMMON_NODE);
            this.mCommonNodes.add(ruleOp);
            return;
        }
    }
}

