/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.impl.util.ObjectSerializer;

public class UDFContext {
    private Configuration jconf = null;
    private HashMap<Integer, Properties> udfConfs = new HashMap();
    private Properties clientSysProps;
    private static final String CLIENT_SYS_PROPS = "pig.client.sys.props";
    private static final String UDF_CONTEXT = "pig.udf.context";
    private static UDFContext self = null;

    private UDFContext() {
    }

    public static UDFContext getUDFContext() {
        if (self == null) {
            self = new UDFContext();
        }
        return self;
    }

    public void setClientSystemProps() {
        this.clientSysProps = System.getProperties();
    }

    public Properties getClientSystemProps() {
        return this.clientSysProps;
    }

    public void addJobConf(Configuration conf) {
        this.jconf = conf;
    }

    public Configuration getJobConf() {
        if (this.jconf != null) {
            return new Configuration(this.jconf);
        }
        return null;
    }

    public Properties getUDFProperties(Class c, String[] args) {
        Integer k = this.generateKey(c, args);
        Properties p = this.udfConfs.get(k);
        if (p == null) {
            p = new Properties();
            this.udfConfs.put(k, p);
        }
        return p;
    }

    public Properties getUDFProperties(Class c) {
        Integer k = this.generateKey(c);
        Properties p = this.udfConfs.get(k);
        if (p == null) {
            p = new Properties();
            this.udfConfs.put(k, p);
        }
        return p;
    }

    public void serialize(Configuration conf) throws IOException {
        conf.set(UDF_CONTEXT, ObjectSerializer.serialize(this.udfConfs));
        conf.set(CLIENT_SYS_PROPS, ObjectSerializer.serialize(this.clientSysProps));
    }

    public void deserialize() throws IOException {
        this.udfConfs = (HashMap)ObjectSerializer.deserialize(this.jconf.get(UDF_CONTEXT));
        this.clientSysProps = (Properties)ObjectSerializer.deserialize(this.jconf.get(CLIENT_SYS_PROPS));
    }

    private int generateKey(Class c) {
        return c.getName().hashCode();
    }

    private int generateKey(Class c, String[] args) {
        int hc = c.getName().hashCode();
        for (int i = 0; i < args.length; ++i) {
            hc <<= 1;
            hc ^= args[i].hashCode();
        }
        return hc;
    }

    public void reset() {
        this.udfConfs.clear();
    }

    public boolean isUDFConfEmpty() {
        return this.udfConfs.isEmpty();
    }
}

