/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.LogicalExpPlanMigrationVistor;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeachInnerPlanVisitor
extends LogicalExpPlanMigrationVistor {
    private LogicalPlan newInnerPlan;
    private org.apache.pig.impl.logicalLayer.LOForEach oldForeach;
    private LogicalRelationalOperator gen;
    private int inputNo;
    private Map<LogicalOperator, LogicalRelationalOperator> innerOpsMap;
    private Map<LogicalOperator, LogicalRelationalOperator> outerOpsMap;

    public ForeachInnerPlanVisitor(LOForEach foreach, org.apache.pig.impl.logicalLayer.LOForEach oldForeach, org.apache.pig.impl.logicalLayer.LogicalPlan innerPlan, org.apache.pig.impl.logicalLayer.LogicalPlan oldLogicalPlan, Map<LogicalOperator, LogicalRelationalOperator> outerOpsMap) throws FrontendException {
        super(innerPlan, oldForeach, foreach, oldLogicalPlan, outerOpsMap);
        this.newInnerPlan = foreach.getInnerPlan();
        this.gen = (LogicalRelationalOperator)this.newInnerPlan.getSinks().get(0);
        this.inputNo = 0;
        List<Operator> suc = this.newInnerPlan.getPredecessors(this.gen);
        if (suc != null) {
            this.inputNo = suc.size();
        }
        this.oldForeach = oldForeach;
        this.outerOpsMap = outerOpsMap;
        this.innerOpsMap = new HashMap<LogicalOperator, LogicalRelationalOperator>();
    }

    private void translateInnerPlanConnection(LogicalOperator oldOp, Operator newOp) throws FrontendException {
        List<LogicalOperator> preds = ((org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan).getPredecessors(oldOp);
        if (preds != null) {
            for (LogicalOperator pred : preds) {
                Operator newPred = this.innerOpsMap.get(pred);
                if (newPred.getPlan().getSuccessors(newPred) != null) {
                    Operator newSucc = newOp.getPlan().getSuccessors(newPred).get(0);
                    newOp.getPlan().insertBetween(newPred, newOp, newSucc);
                    continue;
                }
                newOp.getPlan().connect(newPred, newOp);
            }
        }
    }

    private LogicalExpressionPlan translateInnerExpressionPlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp, LogicalOperator oldOp, LogicalRelationalOperator op, org.apache.pig.impl.logicalLayer.LogicalPlan outerPlan) throws VisitorException {
        DependencyOrderWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan> childWalker = new DependencyOrderWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>(lp);
        LogicalExpPlanMigrationVistor childPlanVisitor = new LogicalExpPlanMigrationVistor(lp, oldOp, op, outerPlan, this.outerOpsMap);
        ((PlanWalker)childWalker).walk(childPlanVisitor);
        return childPlanVisitor.exprPlan;
    }

    @Override
    public void visit(LOProject project) throws VisitorException {
        LogicalOperator op = project.getExpression();
        if (op == this.outerPlan.getPredecessors(this.oldForeach).get(0)) {
            LOInnerLoad innerLoad = new LOInnerLoad(this.newInnerPlan, (LOForEach)this.attachedRelationalOp, project.isStar() ? -1 : project.getCol());
            this.newInnerPlan.add(innerLoad);
            this.innerOpsMap.put(project, innerLoad);
            this.newInnerPlan.connect(innerLoad, this.gen);
            ProjectExpression pe = new ProjectExpression(this.exprPlan, this.inputNo++, -1, this.gen);
            this.exprPlan.add(pe);
            this.exprOpsMap.put(project, pe);
            try {
                this.translateInnerPlanConnection(project, pe);
            }
            catch (FrontendException e) {
                throw new VisitorException(e);
            }
        } else if (op instanceof ExpressionOperator) {
            LogicalExpression expOper = (LogicalExpression)this.exprOpsMap.get(op);
            if (expOper != null) {
                DereferenceExpression dereferenceExp = new DereferenceExpression((OperatorPlan)this.exprPlan, project.getProjection());
                this.exprOpsMap.put(project, dereferenceExp);
                this.exprPlan.add(dereferenceExp);
                this.exprPlan.connect(dereferenceExp, expOper);
            }
        } else if (op instanceof RelationalOperator && project.isSendEmptyBagOnEOP()) {
            LogicalExpression exp;
            List<LogicalOperator> preds;
            LogicalOperator currentOp = op;
            while (currentOp instanceof RelationalOperator && (preds = ((org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan).getPredecessors(currentOp)) != null) {
                currentOp = preds.get(0);
            }
            if (currentOp instanceof ExpressionOperator && (exp = (LogicalExpression)this.exprOpsMap.get(currentOp)) != null) {
                this.exprOpsMap.put(project, exp);
            }
        }
    }

    @Override
    public void visit(org.apache.pig.impl.logicalLayer.LOSort sort) throws VisitorException {
        List<org.apache.pig.impl.logicalLayer.LogicalPlan> sortPlans = sort.getSortColPlans();
        ArrayList<LogicalExpressionPlan> newSortPlans = new ArrayList<LogicalExpressionPlan>();
        LOSort newSort = new LOSort(this.newInnerPlan, newSortPlans, sort.getAscendingCols(), sort.getUserFunc());
        newSort.setAlias(sort.getAlias());
        newSort.setRequestedParallelism(sort.getRequestedParallelism());
        newSort.setLimit(sort.getLimit());
        this.newInnerPlan.add(newSort);
        this.innerOpsMap.put(sort, newSort);
        try {
            this.translateInnerPlanConnection(sort, newSort);
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
        for (org.apache.pig.impl.logicalLayer.LogicalPlan sortPlan : sortPlans) {
            LogicalExpressionPlan newSortPlan = this.translateInnerExpressionPlan(sortPlan, sort, newSort, (org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan);
            newSortPlans.add(newSortPlan);
        }
    }

    @Override
    public void visit(org.apache.pig.impl.logicalLayer.LOLimit limit) throws VisitorException {
        LOLimit newLimit = new LOLimit(this.newInnerPlan, limit.getLimit());
        newLimit.setAlias(limit.getAlias());
        newLimit.setRequestedParallelism(limit.getRequestedParallelism());
        this.newInnerPlan.add(newLimit);
        this.innerOpsMap.put(limit, newLimit);
        try {
            this.translateInnerPlanConnection(limit, newLimit);
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }

    @Override
    public void visit(org.apache.pig.impl.logicalLayer.LODistinct distinct) throws VisitorException {
        LODistinct newDistinct = new LODistinct(this.newInnerPlan);
        newDistinct.setAlias(distinct.getAlias());
        newDistinct.setRequestedParallelism(distinct.getRequestedParallelism());
        this.newInnerPlan.add(newDistinct);
        this.innerOpsMap.put(distinct, newDistinct);
        try {
            this.translateInnerPlanConnection(distinct, newDistinct);
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }

    @Override
    public void visit(org.apache.pig.impl.logicalLayer.LOFilter filter) throws VisitorException {
        LOFilter newFilter = new LOFilter(this.newInnerPlan);
        newFilter.setAlias(filter.getAlias());
        newFilter.setRequestedParallelism(filter.getRequestedParallelism());
        LogicalExpressionPlan newFilterPlan = this.translateInnerExpressionPlan(filter.getComparisonPlan(), filter, newFilter, (org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan);
        newFilter.setFilterPlan(newFilterPlan);
        this.newInnerPlan.add(newFilter);
        this.innerOpsMap.put(filter, newFilter);
        try {
            this.translateInnerPlanConnection(filter, newFilter);
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }

    @Override
    public void visit(org.apache.pig.impl.logicalLayer.LOForEach foreach) throws VisitorException {
        LOForEach newForEach = new LOForEach(this.newInnerPlan);
        newForEach.setAlias(foreach.getAlias());
        newForEach.setRequestedParallelism(foreach.getRequestedParallelism());
        LogicalPlan newForEachInnerPlan = new LogicalPlan();
        newForEach.setInnerPlan(newForEachInnerPlan);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        boolean[] flattens = new boolean[foreach.getForEachPlans().size()];
        LOGenerate generate = new LOGenerate(newForEachInnerPlan, expPlans, flattens);
        newForEachInnerPlan.add(generate);
        for (int i = 0; i < foreach.getForEachPlans().size(); ++i) {
            org.apache.pig.impl.logicalLayer.LogicalPlan innerPlan = foreach.getForEachPlans().get(i);
            LOProject project = (LOProject)innerPlan.iterator().next();
            LOInnerLoad innerLoad = new LOInnerLoad(newForEachInnerPlan, newForEach, project.isStar() ? -1 : project.getCol());
            newForEachInnerPlan.add(innerLoad);
            newForEachInnerPlan.connect(innerLoad, generate);
            LogicalExpressionPlan expPlan = new LogicalExpressionPlan();
            expPlans.add(expPlan);
            ProjectExpression pe = new ProjectExpression(expPlan, i, -1, generate);
            expPlan.add(pe);
        }
        this.newInnerPlan.add(newForEach);
        this.innerOpsMap.put(foreach, newForEach);
        try {
            this.translateInnerPlanConnection(foreach, newForEach);
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }
}

