/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.ForeachInnerPlanVisitor;
import org.apache.pig.newplan.logical.LogicalExpPlanMigrationVistor;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LogicalPlanMigrationVistor
extends LOVisitor {
    private LogicalPlan logicalPlan = new LogicalPlan();
    private Map<LogicalOperator, LogicalRelationalOperator> opsMap = new HashMap<LogicalOperator, LogicalRelationalOperator>();

    public LogicalPlanMigrationVistor(org.apache.pig.impl.logicalLayer.LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>)new DependencyOrderWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>(plan));
    }

    private void translateConnection(LogicalOperator oldOp, Operator newOp) {
        List<LogicalOperator> softPreds;
        List<LogicalOperator> preds = ((org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan).getPredecessors(oldOp);
        if (preds != null) {
            for (LogicalOperator pred : preds) {
                Operator newPred = this.opsMap.get(pred);
                newOp.getPlan().connect(newPred, newOp);
            }
        }
        if ((softPreds = ((org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan).getSoftLinkPredecessors(oldOp)) != null) {
            for (LogicalOperator softPred : softPreds) {
                Operator newSoftPred = this.opsMap.get(softPred);
                newOp.getPlan().createSoftLink(newSoftPred, newOp);
            }
        }
    }

    private LogicalExpressionPlan translateExpressionPlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp, LogicalOperator oldOp, LogicalRelationalOperator op) throws VisitorException {
        DependencyOrderWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan> childWalker = new DependencyOrderWalker<LogicalOperator, org.apache.pig.impl.logicalLayer.LogicalPlan>(lp);
        LogicalExpPlanMigrationVistor childPlanVisitor = new LogicalExpPlanMigrationVistor(lp, oldOp, op, (org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan, this.opsMap);
        ((PlanWalker)childWalker).walk(childPlanVisitor);
        return childPlanVisitor.exprPlan;
    }

    public LogicalPlan getNewLogicalPlan() {
        return this.logicalPlan;
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOCogroup cg) throws VisitorException {
        LOCogroup.GROUPTYPE grouptype = cg.getGroupType() == LOCogroup.GROUPTYPE.COLLECTED ? LOCogroup.GROUPTYPE.COLLECTED : (cg.getGroupType() == LOCogroup.GROUPTYPE.MERGE ? LOCogroup.GROUPTYPE.MERGE : LOCogroup.GROUPTYPE.REGULAR);
        ArrayList inputs = (ArrayList)cg.getInputs();
        MultiMap<Integer, LogicalExpressionPlan> newExpressionPlans = new MultiMap<Integer, LogicalExpressionPlan>();
        LOCogroup newCogroup = new LOCogroup(this.logicalPlan, newExpressionPlans, grouptype, cg.getInner(), cg.getRequestedParallelism());
        for (int i = 0; i < inputs.size(); ++i) {
            ArrayList plans = (ArrayList)cg.getGroupByPlans().get((LogicalOperator)inputs.get(i));
            for (org.apache.pig.impl.logicalLayer.LogicalPlan plan : plans) {
                LogicalExpressionPlan expPlan = this.translateExpressionPlan(plan, cg, newCogroup);
                newExpressionPlans.put((Integer)i, expPlan);
            }
        }
        newCogroup.setAlias(cg.getAlias());
        newCogroup.setRequestedParallelism(cg.getRequestedParallelism());
        newCogroup.setCustomPartitioner(cg.getCustomPartitioner());
        this.logicalPlan.add(newCogroup);
        this.opsMap.put(cg, newCogroup);
        this.translateConnection(cg, newCogroup);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOJoin loj) throws VisitorException {
        List<LogicalOperator> inputs = loj.getInputs();
        MultiMap<Integer, LogicalExpressionPlan> joinPlans = new MultiMap<Integer, LogicalExpressionPlan>();
        LOJoin.JOINTYPE type = loj.getJoinType();
        LOJoin.JOINTYPE newType = LOJoin.JOINTYPE.HASH;
        switch (type) {
            case REPLICATED: {
                newType = LOJoin.JOINTYPE.REPLICATED;
                break;
            }
            case SKEWED: {
                newType = LOJoin.JOINTYPE.SKEWED;
                break;
            }
            case MERGE: {
                newType = LOJoin.JOINTYPE.MERGE;
            }
        }
        boolean[] isInner = loj.getInnerFlags();
        LOJoin join = new LOJoin(this.logicalPlan, joinPlans, newType, isInner);
        for (int i = 0; i < inputs.size(); ++i) {
            List plans = (List)loj.getJoinPlans().get(inputs.get(i));
            for (org.apache.pig.impl.logicalLayer.LogicalPlan lp : plans) {
                joinPlans.put((Integer)i, this.translateExpressionPlan(lp, loj, join));
            }
        }
        join.setAlias(loj.getAlias());
        join.setRequestedParallelism(loj.getRequestedParallelism());
        join.setCustomPartitioner(join.getCustomPartitioner());
        this.logicalPlan.add(join);
        this.opsMap.put(loj, join);
        this.translateConnection(loj, join);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOCross cross) throws VisitorException {
        LOCross newCross = new LOCross(this.logicalPlan);
        newCross.setAlias(cross.getAlias());
        newCross.setRequestedParallelism(cross.getRequestedParallelism());
        newCross.setCustomPartitioner(cross.getCustomPartitioner());
        this.logicalPlan.add(newCross);
        this.opsMap.put(cross, newCross);
        this.translateConnection(cross, newCross);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOForEach forEach) throws VisitorException {
        LOForEach newForeach = new LOForEach(this.logicalPlan);
        LogicalPlan innerPlan = new LogicalPlan();
        newForeach.setInnerPlan(innerPlan);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        List<Boolean> fl = forEach.getFlatten();
        boolean[] flat = new boolean[fl.size()];
        for (int i = 0; i < fl.size(); ++i) {
            flat[i] = fl.get(i);
        }
        LOGenerate gen = new LOGenerate(innerPlan, expPlans, flat);
        if (forEach.getUserDefinedSchema() != null) {
            ArrayList<LogicalSchema> userDefinedSchema = new ArrayList<LogicalSchema>();
            for (Schema schema : forEach.getUserDefinedSchema()) {
                userDefinedSchema.add(Util.translateSchema(schema));
            }
            gen.setUserDefinedSchema(userDefinedSchema);
        }
        innerPlan.add(gen);
        ArrayList<org.apache.pig.impl.logicalLayer.LogicalPlan> ll = forEach.getForEachPlans();
        try {
            for (int i = 0; i < ll.size(); ++i) {
                org.apache.pig.impl.logicalLayer.LogicalPlan lp = (org.apache.pig.impl.logicalLayer.LogicalPlan)ll.get(i);
                ForeachInnerPlanVisitor v = new ForeachInnerPlanVisitor(newForeach, forEach, lp, (org.apache.pig.impl.logicalLayer.LogicalPlan)this.mPlan, this.opsMap);
                v.visit();
                expPlans.add(v.exprPlan);
            }
        }
        catch (FrontendException e) {
            throw new VisitorException("Cannot create ForeachInnerPlanVisitor", e);
        }
        newForeach.setAlias(forEach.getAlias());
        newForeach.setRequestedParallelism(forEach.getRequestedParallelism());
        this.logicalPlan.add(newForeach);
        this.opsMap.put(forEach, newForeach);
        this.translateConnection(forEach, newForeach);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOSort sort) throws VisitorException {
        List<org.apache.pig.impl.logicalLayer.LogicalPlan> sortPlans = sort.getSortColPlans();
        ArrayList<LogicalExpressionPlan> newSortPlans = new ArrayList<LogicalExpressionPlan>();
        LOSort newSort = new LOSort(this.logicalPlan, newSortPlans, sort.getAscendingCols(), sort.getUserFunc());
        for (org.apache.pig.impl.logicalLayer.LogicalPlan sortPlan : sortPlans) {
            LogicalExpressionPlan newSortPlan = this.translateExpressionPlan(sortPlan, sort, newSort);
            newSortPlans.add(newSortPlan);
        }
        newSort.setAlias(sort.getAlias());
        newSort.setRequestedParallelism(sort.getRequestedParallelism());
        newSort.setLimit(sort.getLimit());
        this.logicalPlan.add(newSort);
        this.opsMap.put(sort, newSort);
        this.translateConnection(sort, newSort);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOLimit limit) throws VisitorException {
        LOLimit newLimit = new LOLimit(this.logicalPlan, limit.getLimit());
        newLimit.setAlias(limit.getAlias());
        newLimit.setRequestedParallelism(limit.getRequestedParallelism());
        this.logicalPlan.add(newLimit);
        this.opsMap.put(limit, newLimit);
        this.translateConnection(limit, newLimit);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOStream stream) throws VisitorException {
        LogicalSchema s;
        try {
            s = Util.translateSchema(stream.getSchema());
        }
        catch (Exception e) {
            throw new VisitorException("Failed to translate schema.", e);
        }
        LOStream newStream = new LOStream(this.logicalPlan, stream.getExecutableManager(), stream.getStreamingCommand(), s);
        newStream.setAlias(stream.getAlias());
        newStream.setRequestedParallelism(stream.getRequestedParallelism());
        this.logicalPlan.add(newStream);
        this.opsMap.put(stream, newStream);
        this.translateConnection(stream, newStream);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOFilter filter) throws VisitorException {
        LOFilter newFilter = new LOFilter(this.logicalPlan);
        org.apache.pig.impl.logicalLayer.LogicalPlan filterPlan = filter.getComparisonPlan();
        LogicalExpressionPlan newFilterPlan = this.translateExpressionPlan(filterPlan, filter, newFilter);
        newFilter.setFilterPlan(newFilterPlan);
        newFilter.setAlias(filter.getAlias());
        newFilter.setRequestedParallelism(filter.getRequestedParallelism());
        this.logicalPlan.add(newFilter);
        this.opsMap.put(filter, newFilter);
        this.translateConnection(filter, newFilter);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOSplit split) throws VisitorException {
        LOSplit newSplit = new LOSplit(this.logicalPlan);
        newSplit.setAlias(split.getAlias());
        newSplit.setRequestedParallelism(split.getRequestedParallelism());
        this.logicalPlan.add(newSplit);
        this.opsMap.put(split, newSplit);
        this.translateConnection(split, newSplit);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOGenerate g) throws VisitorException {
        throw new VisitorException("LOGenerate is not supported.");
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOLoad load) throws VisitorException {
        FileSpec fs = load.getInputFile();
        LogicalSchema s = null;
        try {
            s = Util.translateSchema(load.getSchema());
        }
        catch (Exception e) {
            throw new VisitorException("Failed to translate schema.", e);
        }
        LOLoad ld = new LOLoad(fs, s, this.logicalPlan, load.getConfiguration());
        ld.setAlias(load.getAlias());
        ld.setRequestedParallelism(load.getRequestedParallelism());
        this.logicalPlan.add(ld);
        this.opsMap.put(load, ld);
        this.translateConnection(load, ld);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOStore store) throws VisitorException {
        LOStore newStore = new LOStore(this.logicalPlan, store.getOutputFile());
        newStore.setAlias(store.getAlias());
        newStore.setRequestedParallelism(store.getRequestedParallelism());
        newStore.setSignature(store.getSignature());
        newStore.setInputSpec(store.getInputSpec());
        newStore.setTmpStore(store.isTmpStore());
        this.logicalPlan.add(newStore);
        this.opsMap.put(store, newStore);
        this.translateConnection(store, newStore);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOUnion union) throws VisitorException {
        LOUnion newUnion = new LOUnion(this.logicalPlan);
        newUnion.setAlias(union.getAlias());
        newUnion.setRequestedParallelism(union.getRequestedParallelism());
        this.logicalPlan.add(newUnion);
        this.opsMap.put(union, newUnion);
        this.translateConnection(union, newUnion);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LOSplitOutput splitOutput) throws VisitorException {
        LOSplitOutput newSplitOutput = new LOSplitOutput(this.logicalPlan);
        org.apache.pig.impl.logicalLayer.LogicalPlan filterPlan = splitOutput.getConditionPlan();
        LogicalExpressionPlan newFilterPlan = this.translateExpressionPlan(filterPlan, splitOutput, newSplitOutput);
        newSplitOutput.setFilterPlan(newFilterPlan);
        newSplitOutput.setAlias(splitOutput.getAlias());
        newSplitOutput.setRequestedParallelism(splitOutput.getRequestedParallelism());
        this.logicalPlan.add(newSplitOutput);
        this.opsMap.put(splitOutput, newSplitOutput);
        this.translateConnection(splitOutput, newSplitOutput);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LODistinct distinct) throws VisitorException {
        LODistinct newDistinct = new LODistinct(this.logicalPlan);
        newDistinct.setAlias(distinct.getAlias());
        newDistinct.setRequestedParallelism(distinct.getRequestedParallelism());
        newDistinct.setCustomPartitioner(distinct.getCustomPartitioner());
        this.logicalPlan.add(newDistinct);
        this.opsMap.put(distinct, newDistinct);
        this.translateConnection(distinct, newDistinct);
    }

    public void visit(org.apache.pig.impl.logicalLayer.LONative nativeMR) throws VisitorException {
        LONative newNativeMR = new LONative(this.logicalPlan, nativeMR.getNativeMRJar(), nativeMR.getParams());
        newNativeMR.setAlias(nativeMR.getAlias());
        newNativeMR.setRequestedParallelism(nativeMR.getRequestedParallelism());
        newNativeMR.setCustomPartitioner(nativeMR.getCustomPartitioner());
        this.logicalPlan.add(newNativeMR);
        this.opsMap.put(nativeMR, newNativeMR);
        this.translateConnection(nativeMR, newNativeMR);
    }
}

