/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOInnerLoad
extends LogicalRelationalOperator {
    private ProjectExpression prj;
    private LOForEach foreach;
    private boolean sourceIsBag = false;

    public LOInnerLoad(OperatorPlan plan, LOForEach foreach, int colNum) {
        super("LOInnerLoad", plan);
        LogicalExpressionPlan exp = new LogicalExpressionPlan();
        this.prj = new ProjectExpression(exp, 0, colNum, foreach);
        this.foreach = foreach;
    }

    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.prj.findReferent().getSchema() != null) {
            if (this.prj.getFieldSchema() != null) {
                if (this.prj.getFieldSchema().type == 120 && this.prj.getFieldSchema().schema != null && this.prj.getFieldSchema().schema.isTwoLevelAccessRequired()) {
                    this.schema = new LogicalSchema();
                    LogicalSchema.LogicalFieldSchema tupleSchema = this.prj.getFieldSchema().schema.getField(0);
                    for (int i = 0; i < tupleSchema.schema.size(); ++i) {
                        this.schema.addField(tupleSchema.schema.getField(i));
                    }
                    this.sourceIsBag = true;
                    this.alias = this.prj.getFieldSchema().alias;
                } else if (this.prj.getFieldSchema().type == 120) {
                    this.sourceIsBag = true;
                    this.alias = this.prj.getFieldSchema().alias;
                    if (this.prj.getFieldSchema().schema != null) {
                        this.schema = new LogicalSchema();
                        for (int i = 0; i < this.prj.getFieldSchema().schema.size(); ++i) {
                            this.schema.addField(this.prj.getFieldSchema().schema.getField(i));
                        }
                    }
                } else {
                    this.schema = new LogicalSchema();
                    this.schema.addField(this.prj.getFieldSchema());
                }
            }
        } else if (!this.prj.isProjectStar()) {
            this.schema = new LogicalSchema();
            this.schema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 50));
        }
        return this.schema;
    }

    public ProjectExpression getProjection() {
        return this.prj;
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (!(other instanceof LOInnerLoad)) {
            return false;
        }
        return this.getColNum() == ((LOInnerLoad)other).getColNum();
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public int getColNum() {
        return this.prj.getColNum();
    }

    public LOForEach getLOForEach() {
        return this.foreach;
    }

    public boolean sourceIsBag() {
        return this.sourceIsBag;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.alias != null) {
            msg.append(this.alias + ": ");
        }
        msg.append("(Name: " + this.name);
        msg.append("[");
        if (this.getProjection().getColNum() == -1) {
            msg.append("*");
        } else {
            msg.append(this.getProjection().getColNum());
        }
        msg.append("]");
        msg.append(" Schema: ");
        if (this.schema != null) {
            msg.append(this.schema);
        } else {
            msg.append("null");
        }
        msg.append(")");
        if (this.annotations != null) {
            for (Map.Entry entry : this.annotations.entrySet()) {
                msg.append(entry);
            }
        }
        return msg.toString();
    }
}

