/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.PreOrderDepthFirstWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugmentBaseDataVisitor
extends LOVisitor {
    Map<LOLoad, DataBag> baseData = null;
    Map<LOLoad, DataBag> newBaseData = new HashMap<LOLoad, DataBag>();
    Map<LogicalOperator, DataBag> derivedData = null;
    Map<LogicalOperator, DataBag> outputConstraintsMap = new HashMap<LogicalOperator, DataBag>();
    Log log = LogFactory.getLog(this.getClass());

    public AugmentBaseDataVisitor(LogicalPlan plan, Map<LOLoad, DataBag> baseData, Map<LogicalOperator, DataBag> derivedData) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new PreOrderDepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
        this.baseData = baseData;
        this.derivedData = derivedData;
    }

    public Map<LOLoad, DataBag> getNewBaseData() {
        for (Map.Entry<LOLoad, DataBag> e : this.baseData.entrySet()) {
            DataBag bag = this.newBaseData.get(e.getKey());
            if (bag == null) {
                bag = BagFactory.getInstance().newDefaultBag();
                this.newBaseData.put(e.getKey(), bag);
            }
            bag.addAll(e.getValue());
        }
        return this.newBaseData;
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        DataBag outputConstraints = this.outputConstraintsMap.get(cg);
        this.outputConstraintsMap.remove(cg);
        boolean ableToHandle = true;
        LinkedList groupSpecs = new LinkedList();
        int numCols = -1;
        int minGroupSize = cg.getInputs().size() == 1 ? 1 : 2;
        for (LogicalOperator op : cg.getInputs()) {
            List groupByPlans = (List)cg.getGroupByPlans().get(op);
            ArrayList<Integer> groupCols = new ArrayList<Integer>();
            for (LogicalPlan plan : groupByPlans) {
                LogicalOperator leaf = (LogicalOperator)plan.getLeaves().get(0);
                if (leaf instanceof LOProject) {
                    groupCols.add(((LOProject)leaf).getCol());
                    continue;
                }
                ableToHandle = false;
                break;
            }
            if (numCols == -1) {
                numCols = groupCols.size();
            }
            if (groupCols.size() != groupByPlans.size() || groupCols.size() != numCols) break;
            groupSpecs.add(groupCols);
        }
        try {
            if (ableToHandle) {
                int numInputs = cg.getInputs().size();
                if (outputConstraints != null) {
                    for (Tuple outputConstraint : outputConstraints) {
                        Object groupLabel = outputConstraint.get(0);
                        for (int input = 0; input < numInputs; ++input) {
                            int numInputFields = cg.getInputs().get(input).getSchema().size();
                            List groupCols = (List)groupSpecs.get(input);
                            DataBag output = this.outputConstraintsMap.get(cg.getInputs().get(input));
                            if (output == null) {
                                output = BagFactory.getInstance().newDefaultBag();
                                this.outputConstraintsMap.put(cg.getInputs().get(input), output);
                            }
                            for (int i = 0; i < minGroupSize; ++i) {
                                Tuple inputConstraint = this.GetGroupByInput(groupLabel, groupCols, numInputFields);
                                if (inputConstraint == null) continue;
                                output.add(inputConstraint);
                            }
                        }
                    }
                }
                DataBag outputData = this.derivedData.get(cg);
                for (Tuple groupTup : outputData) {
                    Object groupLabel = groupTup.get(0);
                    for (int input = 0; input < numInputs; ++input) {
                        int numInputFields = cg.getInputs().get(input).getSchema().size();
                        List groupCols = (List)groupSpecs.get(input);
                        DataBag output = this.outputConstraintsMap.get(cg.getInputs().get(input));
                        if (output == null) {
                            output = BagFactory.getInstance().newDefaultBag();
                            this.outputConstraintsMap.put(cg.getInputs().get(input), output);
                        }
                        int numTupsToAdd = minGroupSize - (int)((DataBag)groupTup.get(input + 1)).size();
                        for (int i = 0; i < numTupsToAdd; ++i) {
                            Tuple inputConstraint = this.GetGroupByInput(groupLabel, groupCols, numInputFields);
                            if (inputConstraint == null) continue;
                            output.add(inputConstraint);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error visiting Cogroup during Augmentation phase of Example Generator! " + e.getMessage()));
            throw new VisitorException("Error visiting Cogroup during Augmentation phase of Example Generator! " + e.getMessage());
        }
    }

    @Override
    protected void visit(LOCross cs) throws VisitorException {
    }

    @Override
    protected void visit(LODistinct dt) throws VisitorException {
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        DataBag outputConstraints = this.outputConstraintsMap.get(filter);
        this.outputConstraintsMap.remove(filter);
        LogicalPlan filterCond = filter.getComparisonPlan();
        DataBag inputConstraints = this.outputConstraintsMap.get(filter.getInput());
        if (inputConstraints == null) {
            inputConstraints = BagFactory.getInstance().newDefaultBag();
            this.outputConstraintsMap.put(filter.getInput(), inputConstraints);
        }
        DataBag outputData = this.derivedData.get(filter);
        DataBag inputData = this.derivedData.get(filter.getInput());
        try {
            ExampleTuple inputConstraint;
            if (outputConstraints != null && outputConstraints.size() > 0L) {
                for (Tuple outputConstraint : outputConstraints) {
                    ExampleTuple inputConstraint2 = this.GenerateMatchingTuple(outputConstraint, filterCond, false);
                    if (inputConstraint2 == null) continue;
                    inputConstraints.add(inputConstraint2);
                }
            } else if (outputData.size() == 0L && (inputConstraint = this.GenerateMatchingTuple(filter.getSchema(), filterCond, false)) != null) {
                inputConstraints.add(inputConstraint);
            }
            if (outputData.size() == inputData.size() && (inputConstraint = this.GenerateMatchingTuple(filter.getSchema(), filterCond, true)) != null) {
                inputConstraints.add(inputConstraint);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage()));
            throw new VisitorException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage());
        }
    }

    @Override
    protected void visit(LOForEach forEach) throws VisitorException {
        DataBag outputConstraints = this.outputConstraintsMap.get(forEach);
        this.outputConstraintsMap.remove(forEach);
        ArrayList<LogicalPlan> plans = forEach.getForEachPlans();
        boolean ableToHandle = true;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        boolean cast = false;
        if (outputConstraints == null || outputConstraints.size() == 0L) {
            return;
        }
        for (LogicalPlan plan : plans) {
            LogicalOperator op = (LogicalOperator)plan.getLeaves().get(0);
            if (op instanceof LOCast) {
                cast = true;
                op = ((LOCast)op).getExpression();
            }
            if (!(op instanceof LOProject)) {
                ableToHandle = false;
                break;
            }
            cols.add(((LOProject)op).getCol());
        }
        if (ableToHandle) {
            DataBag output = BagFactory.getInstance().newDefaultBag();
            for (Tuple outputConstraint : outputConstraints) {
                try {
                    Tuple inputConstraint = this.BackPropConstraint(outputConstraint, cols, ((LogicalOperator)forEach.getPlan().getPredecessors(forEach).get(0)).getSchema(), cast);
                    output.add(inputConstraint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new VisitorException("Operator error during Augmenting Phase in Example Generator " + e.getMessage());
                }
            }
            this.outputConstraintsMap.put(forEach.getPlan().getPredecessors(forEach).get(0), output);
        }
    }

    @Override
    protected void visit(LOLoad load) throws VisitorException {
        Schema schema;
        DataBag inputData = this.baseData.get(load);
        DataBag newInputData = this.newBaseData.get(load);
        if (newInputData == null) {
            newInputData = BagFactory.getInstance().newDefaultBag();
            this.newBaseData.put(load, newInputData);
        }
        try {
            schema = load.getSchema();
            if (schema == null) {
                throw new RuntimeException("Example Generator requires a schema. Please provide a schema while loading data");
            }
        }
        catch (FrontendException e) {
            this.log.error((Object)("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage()));
            throw new VisitorException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage());
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(load);
        this.outputConstraintsMap.remove(load);
        if (inputData == null || inputData.size() == 0L) {
            this.log.error((Object)"No input data found!");
            throw new RuntimeException("No input data found!");
        }
        if (outputConstraints == null || outputConstraints.size() == 0L) {
            outputConstraints = BagFactory.getInstance().newDefaultBag();
            outputConstraints.add(TupleFactory.getInstance().newTuple(schema.getFields().size()));
        }
        Tuple exampleTuple = inputData.iterator().next();
        for (Tuple outputConstraint : outputConstraints) {
            if (outputConstraint.size() != schema.getFields().size()) {
                throw new RuntimeException("Internal error: incorrect number of fields in constraint tuple.");
            }
            Tuple inputT = TupleFactory.getInstance().newTuple(outputConstraint.size());
            ExampleTuple inputTuple = new ExampleTuple(inputT);
            try {
                for (int i = 0; i < inputTuple.size(); ++i) {
                    Object d = outputConstraint.get(i);
                    if (d == null) {
                        d = exampleTuple.get(i);
                    }
                    inputTuple.set(i, d);
                }
            }
            catch (ExecException e) {
                this.log.error((Object)("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage()));
                throw new VisitorException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage());
            }
            if (!inputTuple.equals(exampleTuple)) {
                inputTuple.synthetic = true;
            }
            newInputData.add(inputTuple);
        }
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
        DataBag outputConstraints = this.outputConstraintsMap.get(s);
        this.outputConstraintsMap.remove(s);
        if (outputConstraints == null) {
            this.outputConstraintsMap.put(s.getInput(), BagFactory.getInstance().newDefaultBag());
        } else {
            this.outputConstraintsMap.put(s.getInput(), outputConstraints);
        }
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
    }

    @Override
    protected void visit(LOStore store) throws VisitorException {
        DataBag outputConstraints = this.outputConstraintsMap.get(store);
        if (outputConstraints == null) {
            this.outputConstraintsMap.put(store.getPlan().getPredecessors(store).get(0), BagFactory.getInstance().newDefaultBag());
        } else {
            this.outputConstraintsMap.remove(store);
            this.outputConstraintsMap.put(store.getPlan().getPredecessors(store).get(0), outputConstraints);
        }
    }

    @Override
    protected void visit(LOUnion u) throws VisitorException {
        DataBag outputConstraints = this.outputConstraintsMap.get(u);
        this.outputConstraintsMap.remove(u);
        if (outputConstraints == null || outputConstraints.size() == 0L) {
            for (LogicalOperator op : u.getInputs()) {
                DataBag constraints = BagFactory.getInstance().newDefaultBag();
                this.outputConstraintsMap.put(op, constraints);
            }
            return;
        }
        int count = 0;
        List<LogicalOperator> inputs = u.getInputs();
        int noInputs = inputs.size();
        for (LogicalOperator op : inputs) {
            DataBag constraint = BagFactory.getInstance().newDefaultBag();
            this.outputConstraintsMap.put(op, constraint);
        }
        Iterator<Tuple> it = outputConstraints.iterator();
        while (it.hasNext()) {
            DataBag constraint = this.outputConstraintsMap.get(inputs.get(count));
            constraint.add(it.next());
            count = (count + 1) % noInputs;
        }
    }

    Tuple GetGroupByInput(Object groupLabel, List<Integer> groupCols, int numFields) throws ExecException {
        Tuple t = TupleFactory.getInstance().newTuple(numFields);
        if (groupCols.size() == 1) {
            t.set(groupCols.get(0), groupLabel);
        } else {
            if (!(groupLabel instanceof Tuple)) {
                throw new RuntimeException("Unrecognized group label!");
            }
            Tuple group = (Tuple)groupLabel;
            for (int i = 0; i < groupCols.size(); ++i) {
                t.set(groupCols.get(i), group.get(i));
            }
        }
        return t;
    }

    Tuple BackPropConstraint(Tuple outputConstraint, List<Integer> cols, Schema inputSchema, boolean cast) throws ExecException {
        Tuple inputConst = TupleFactory.getInstance().newTuple(inputSchema.getFields().size());
        ExampleTuple inputConstraint = new ExampleTuple(inputConst);
        for (int outCol = 0; outCol < outputConstraint.size(); ++outCol) {
            int inCol = cols.get(outCol);
            Object outVal = outputConstraint.get(outCol);
            Object inVal = inputConstraint.get(inCol);
            if (inVal == null && outVal != null) {
                inputConstraint.set(inCol, cast ? new DataByteArray(outVal.toString().getBytes()) : outVal);
                continue;
            }
            if (outVal == null) continue;
            return null;
        }
        return inputConstraint;
    }

    ExampleTuple GenerateMatchingTuple(Schema schema, LogicalPlan plan, boolean invert) throws ExecException {
        return this.GenerateMatchingTuple(TupleFactory.getInstance().newTuple(schema.getFields().size()), plan, invert);
    }

    ExampleTuple GenerateMatchingTuple(Tuple constraint, LogicalPlan predicate, boolean invert) throws ExecException {
        Tuple t = TupleFactory.getInstance().newTuple(constraint.size());
        ExampleTuple tOut = new ExampleTuple(t);
        for (int i = 0; i < t.size(); ++i) {
            tOut.set(i, constraint.get(i));
        }
        this.GenerateMatchingTupleHelper((Tuple)tOut, (ExpressionOperator)predicate.getLeaves().get(0), invert);
        tOut.synthetic = true;
        return tOut;
    }

    void GenerateMatchingTupleHelper(Tuple t, ExpressionOperator pred, boolean invert) throws ExecException {
        if (pred instanceof BinaryExpressionOperator) {
            this.GenerateMatchingTupleHelper(t, (BinaryExpressionOperator)pred, invert);
        } else if (pred instanceof LONot) {
            this.GenerateMatchingTupleHelper(t, (LONot)pred, invert);
        } else {
            throw new ExecException("Unknown operator in filter predicate");
        }
    }

    void GenerateMatchingTupleHelper(Tuple t, BinaryExpressionOperator pred, boolean invert) throws ExecException {
        Object d;
        if (pred instanceof LOAnd) {
            this.GenerateMatchingTupleHelper(t, (LOAnd)pred, invert);
            return;
        }
        if (pred instanceof LOOr) {
            this.GenerateMatchingTupleHelper(t, (LOOr)pred, invert);
            return;
        }
        boolean leftIsConst = false;
        boolean rightIsConst = false;
        Object leftConst = null;
        Object rightConst = null;
        byte leftDataType = 0;
        byte rightDataType = 0;
        int leftCol = -1;
        int rightCol = -1;
        if (pred instanceof LOAdd || pred instanceof LOSubtract || pred instanceof LOMultiply || pred instanceof LODivide || pred instanceof LOMod || pred instanceof LORegexp) {
            return;
        }
        if (pred.getLhsOperand() instanceof LOConst) {
            leftIsConst = true;
            leftConst = ((LOConst)pred.getLhsOperand()).getValue();
        } else {
            ExpressionOperator lhs = pred.getLhsOperand();
            if (lhs instanceof LOCast) {
                lhs = ((LOCast)lhs).getExpression();
            }
            if (!(lhs instanceof LOProject) || ((LOProject)lhs).getProjection().size() != 1) {
                return;
            }
            leftCol = ((LOProject)lhs).getCol();
            leftDataType = ((LOProject)lhs).getType();
            d = t.get(leftCol);
            if (d != null) {
                leftIsConst = true;
                leftConst = d;
            }
        }
        if (pred.getRhsOperand() instanceof LOConst) {
            rightIsConst = true;
            rightConst = ((LOConst)pred.getRhsOperand()).getValue();
        } else {
            ExpressionOperator rhs = pred.getRhsOperand();
            if (rhs instanceof LOCast) {
                rhs = ((LOCast)rhs).getExpression();
            }
            if (!(rhs instanceof LOProject) || ((LOProject)rhs).getProjection().size() != 1) {
                return;
            }
            rightCol = ((LOProject)rhs).getCol();
            rightDataType = ((LOProject)rhs).getType();
            d = t.get(rightCol);
            if (d != null) {
                rightIsConst = true;
                rightConst = d;
            }
        }
        if (leftIsConst && rightIsConst) {
            return;
        }
        if (!invert) {
            if (pred instanceof LOEqual) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, leftConst.toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, rightConst.toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "0"));
                    t.set(rightCol, this.generateData(rightDataType, "0"));
                }
            } else if (pred instanceof LONotEqual) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, this.GetUnequalValue(leftConst).toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, this.GetUnequalValue(rightConst).toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "0"));
                    t.set(rightCol, this.generateData(rightDataType, "1"));
                }
            } else if (pred instanceof LOGreaterThan || pred instanceof LOGreaterThanEqual) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, this.GetSmallerValue(leftConst).toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, this.GetLargerValue(rightConst).toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "1"));
                    t.set(rightCol, this.generateData(rightDataType, "0"));
                }
            } else if (pred instanceof LOLesserThan || pred instanceof LOLesserThanEqual) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, this.GetLargerValue(leftConst).toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, this.GetSmallerValue(rightConst).toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "0"));
                    t.set(rightCol, this.generateData(rightDataType, "1"));
                }
            }
        } else if (pred instanceof LOEqual) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, this.GetUnequalValue(leftConst).toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, this.GetUnequalValue(rightConst).toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "0"));
                t.set(rightCol, this.generateData(rightDataType, "1"));
            }
        } else if (pred instanceof LONotEqual) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, leftConst.toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, rightConst.toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "0"));
                t.set(rightCol, this.generateData(rightDataType, "0"));
            }
        } else if (pred instanceof LOGreaterThan || pred instanceof LOGreaterThanEqual) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, this.GetLargerValue(leftConst).toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, this.GetSmallerValue(rightConst).toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "0"));
                t.set(rightCol, this.generateData(rightDataType, "1"));
            }
        } else if (pred instanceof LOLesserThan || pred instanceof LOLesserThanEqual) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, this.GetSmallerValue(leftConst).toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, this.GetLargerValue(rightConst).toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "1"));
                t.set(rightCol, this.generateData(rightDataType, "0"));
            }
        }
    }

    void GenerateMatchingTupleHelper(Tuple t, LOAnd op, boolean invert) throws ExecException {
        ExpressionOperator input = op.getLhsOperand();
        this.GenerateMatchingTupleHelper(t, input, invert);
        input = op.getRhsOperand();
        this.GenerateMatchingTupleHelper(t, input, invert);
    }

    void GenerateMatchingTupleHelper(Tuple t, LOOr op, boolean invert) throws ExecException {
        ExpressionOperator input = op.getLhsOperand();
        this.GenerateMatchingTupleHelper(t, input, invert);
        input = op.getRhsOperand();
        this.GenerateMatchingTupleHelper(t, input, invert);
    }

    void GenerateMatchingTupleHelper(Tuple t, LONot op, boolean invert) throws ExecException {
        ExpressionOperator input = op.getOperand();
        this.GenerateMatchingTupleHelper(t, input, !invert);
    }

    Object GetUnequalValue(Object v) {
        byte type = DataType.findType(v);
        if (type == 120 || type == 110 || type == 100) {
            return null;
        }
        Object zero = this.generateData(type, "0");
        if (v.equals(zero)) {
            return this.generateData(type, "1");
        }
        return zero;
    }

    Object GetSmallerValue(Object v) {
        byte type = DataType.findType(v);
        if (type == 120 || type == 110 || type == 100) {
            return null;
        }
        switch (type) {
            case 55: {
                String str = (String)v;
                if (str.length() > 0) {
                    return str.substring(0, str.length() - 1);
                }
                return null;
            }
            case 50: {
                DataByteArray data = (DataByteArray)v;
                if (data.size() > 0) {
                    return new DataByteArray(data.get(), 0, data.size() - 1);
                }
                return null;
            }
            case 10: {
                return (Integer)v - 1;
            }
            case 15: {
                return (Long)v - 1L;
            }
            case 20: {
                return Float.valueOf(((Float)v).floatValue() - 1.0f);
            }
            case 25: {
                return (Double)v - 1.0;
            }
        }
        return null;
    }

    Object GetLargerValue(Object v) {
        byte type = DataType.findType(v);
        if (type == 120 || type == 110 || type == 100) {
            return null;
        }
        switch (type) {
            case 55: {
                return (String)v + "0";
            }
            case 50: {
                String str = ((DataByteArray)v).toString();
                str = str + "0";
                return new DataByteArray(str);
            }
            case 10: {
                return (Integer)v + 1;
            }
            case 15: {
                return (Long)v + 1L;
            }
            case 20: {
                return Float.valueOf(((Float)v).floatValue() + 1.0f);
            }
            case 25: {
                return (Double)v + 1.0;
            }
        }
        return null;
    }

    Object generateData(byte type, String data) {
        switch (type) {
            case 5: {
                return Boolean.valueOf(data);
            }
            case 50: {
                return new DataByteArray(data.getBytes());
            }
            case 25: {
                return Double.valueOf(data);
            }
            case 20: {
                return Float.valueOf(data);
            }
            case 10: {
                return Integer.valueOf(data);
            }
            case 15: {
                return Long.valueOf(data);
            }
            case 55: {
                return data;
            }
        }
        return null;
    }
}

