/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogToPhyTranslationVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogicalToPhysicalTranslatorException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrangeForIllustrate;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.physicalOperators.POCogroup;
import org.apache.pig.pen.physicalOperators.POCounter;
import org.apache.pig.pen.physicalOperators.POCross;
import org.apache.pig.pen.physicalOperators.POSplit;
import org.apache.pig.pen.physicalOperators.POSplitOutput;
import org.apache.pig.pen.physicalOperators.POStreamLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalLogToPhyTranslationVisitor
extends LogToPhyTranslationVisitor {
    private Log log = LogFactory.getLog(this.getClass());

    public LocalLogToPhyTranslationVisitor(LogicalPlan plan) {
        super(plan);
    }

    public Map<LogicalOperator, PhysicalOperator> getLogToPhyMap() {
        return this.logToPhyMap;
    }

    @Override
    public void visit(LOCogroup cg) throws VisitorException {
        String scope = cg.getOperatorKey().scope;
        List<LogicalOperator> inputs = cg.getInputs();
        POCogroup poc = new POCogroup(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cg.getRequestedParallelism());
        poc.setInner(cg.getInner());
        this.currentPlan.add(poc);
        int count = 0;
        Byte type = null;
        for (LogicalOperator lo : inputs) {
            List plans = (List)cg.getGroupByPlans().get(lo);
            POLocalRearrangeForIllustrate physOp = new POLocalRearrangeForIllustrate(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cg.getRequestedParallelism());
            ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
            this.currentPlans.push(this.currentPlan);
            for (LogicalPlan lp : plans) {
                this.currentPlan = new PhysicalPlan();
                PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(lp);
                this.pushWalker(childWalker);
                this.mCurrentWalker.walk(this);
                exprPlans.add(this.currentPlan);
                this.popWalker();
            }
            this.currentPlan = (PhysicalPlan)this.currentPlans.pop();
            try {
                physOp.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                throw new VisitorException(pe);
            }
            try {
                physOp.setIndex(count++);
            }
            catch (ExecException e1) {
                throw new VisitorException(e1);
            }
            if (plans.size() > 1) {
                type = 110;
                physOp.setKeyType(type);
            } else {
                type = ((PhysicalOperator)((PhysicalPlan)exprPlans.get(0)).getLeaves().get(0)).getResultType();
                physOp.setKeyType(type);
            }
            physOp.setResultType((byte)110);
            this.currentPlan.add(physOp);
            try {
                this.currentPlan.connect((PhysicalOperator)this.logToPhyMap.get(lo), physOp);
                this.currentPlan.connect(physOp, poc);
            }
            catch (PlanException e) {
                this.log.error((Object)("Invalid physical operators in the physical plan" + e.getMessage()));
                throw new VisitorException(e);
            }
        }
        this.logToPhyMap.put(cg, poc);
    }

    @Override
    public void visit(LOJoin join) throws VisitorException {
        String scope = join.getOperatorKey().scope;
        List<LogicalOperator> inputs = join.getInputs();
        boolean[] innerFlags = join.getInnerFlags();
        POCogroup poc = new POCogroup(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), join.getRequestedParallelism());
        poc.setInner(innerFlags);
        this.currentPlan.add(poc);
        int count = 0;
        Byte type = null;
        for (LogicalOperator lo : inputs) {
            List plans = (List)join.getJoinPlans().get(lo);
            POLocalRearrangeForIllustrate physOp = new POLocalRearrangeForIllustrate(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), join.getRequestedParallelism());
            ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
            this.currentPlans.push(this.currentPlan);
            for (LogicalPlan lp : plans) {
                this.currentPlan = new PhysicalPlan();
                PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(lp);
                this.pushWalker(childWalker);
                this.mCurrentWalker.walk(this);
                exprPlans.add(this.currentPlan);
                this.popWalker();
            }
            this.currentPlan = (PhysicalPlan)this.currentPlans.pop();
            try {
                physOp.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                throw new VisitorException(pe);
            }
            try {
                physOp.setIndex(count++);
            }
            catch (ExecException e1) {
                throw new VisitorException(e1);
            }
            if (plans.size() > 1) {
                type = 110;
                physOp.setKeyType(type);
            } else {
                type = ((PhysicalOperator)((PhysicalPlan)exprPlans.get(0)).getLeaves().get(0)).getResultType();
                physOp.setKeyType(type);
            }
            physOp.setResultType((byte)110);
            this.currentPlan.add(physOp);
            try {
                this.currentPlan.connect((PhysicalOperator)this.logToPhyMap.get(lo), physOp);
                this.currentPlan.connect(physOp, poc);
            }
            catch (PlanException e) {
                this.log.error((Object)("Invalid physical operators in the physical plan" + e.getMessage()));
                throw new VisitorException(e);
            }
        }
        ArrayList<Boolean> flattened = new ArrayList<Boolean>();
        ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
        for (int i = 0; i < join.getInputs().size(); ++i) {
            PhysicalPlan ep = new PhysicalPlan();
            POProject prj = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
            prj.setResultType((byte)120);
            prj.setColumn(i + 1);
            prj.setOverloaded(false);
            prj.setStar(false);
            ep.add(prj);
            eps.add(ep);
            if (!innerFlags[i]) {
                LogicalOperator joinInput = inputs.get(i);
                try {
                    LocalLogToPhyTranslationVisitor.updateWithEmptyBagCheck(ep, joinInput);
                }
                catch (PlanException e) {
                    throw new VisitorException(e);
                }
            }
            flattened.add(true);
        }
        POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), -1, eps, flattened);
        fe.setResultType((byte)120);
        this.currentPlan.add(fe);
        this.logToPhyMap.put(join, fe);
        try {
            this.currentPlan.connect(poc, fe);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    public void visit(LOSplit split) throws VisitorException {
        String scope = split.getOperatorKey().scope;
        POSplit physOp = new POSplit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), split.getRequestedParallelism());
        this.logToPhyMap.put(split, physOp);
        this.currentPlan.add(physOp);
        PhysicalOperator from = (PhysicalOperator)this.logToPhyMap.get(split.getPlan().getPredecessors(split).get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            this.log.error((Object)("Invalid physical operator in the plan" + e.getMessage()));
            throw new VisitorException(e);
        }
    }

    @Override
    public void visit(LOSplitOutput split) throws VisitorException {
        String scope = split.getOperatorKey().scope;
        POSplitOutput physOp = new POSplitOutput(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), split.getRequestedParallelism());
        this.logToPhyMap.put(split, physOp);
        this.currentPlan.add(physOp);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(split.getConditionPlan());
        this.pushWalker(childWalker);
        this.mCurrentWalker.walk(this);
        this.popWalker();
        physOp.setPlan(this.currentPlan);
        this.currentPlan = (PhysicalPlan)this.currentPlans.pop();
        this.currentPlan.add(physOp);
        PhysicalOperator from = (PhysicalOperator)this.logToPhyMap.get(split.getPlan().getPredecessors(split).get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            this.log.error((Object)("Invalid physical operator in the plan" + e.getMessage()));
            throw new VisitorException(e);
        }
    }

    @Override
    public void visit(LOStream stream) throws VisitorException {
        String scope = stream.getOperatorKey().scope;
        POStreamLocal poStream = new POStreamLocal(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), stream.getExecutableManager(), stream.getStreamingCommand(), this.pc.getProperties());
        this.currentPlan.add(poStream);
        this.logToPhyMap.put(stream, poStream);
        List<LOStream> op = stream.getPlan().getPredecessors(stream);
        PhysicalOperator from = (PhysicalOperator)this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poStream);
        }
        catch (PlanException e) {
            this.log.error((Object)("Invalid physical operators in the physical plan" + e.getMessage()));
            throw new VisitorException(e);
        }
    }

    @Override
    public void visit(LOCross cross) throws VisitorException {
        String scope = cross.getOperatorKey().scope;
        POCross pocross = new POCross(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        this.logToPhyMap.put(cross, pocross);
        this.currentPlan.add(pocross);
        for (LogicalOperator in : cross.getInputs()) {
            PhysicalOperator from = (PhysicalOperator)this.logToPhyMap.get(in);
            try {
                this.currentPlan.connect(from, pocross);
            }
            catch (PlanException e) {
                this.log.error((Object)("Invalid physical operators in the physical plan" + e.getMessage()));
                throw new VisitorException(e);
            }
        }
    }

    @Override
    public void visit(LOStore loStore) throws VisitorException {
        String scope = loStore.getOperatorKey().scope;
        POStore store = new POStore(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        store.setSFile(loStore.getOutputFile());
        store.setInputSpec(loStore.getInputSpec());
        try {
            store.setSchema(new Schema(loStore.getSchema()));
        }
        catch (FrontendException e1) {
            int errorCode = 1060;
            String message = "Cannot resolve Store output schema";
            throw new VisitorException(message, errorCode, 4, e1);
        }
        this.currentPlan.add(store);
        PhysicalOperator from = (PhysicalOperator)this.logToPhyMap.get(loStore.getPlan().getPredecessors(loStore).get(0));
        POCounter counter = new POCounter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        this.currentPlan.add(counter);
        try {
            this.currentPlan.connect(from, counter);
            this.currentPlan.connect(counter, store);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        this.logToPhyMap.put(loStore, store);
    }
}

