/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LONative;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.optimizer.ImplicitSplitInserter;
import org.apache.pig.impl.logicalLayer.optimizer.TypeCastInserter;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.optimizer.PlanOptimizer;
import org.apache.pig.impl.plan.optimizer.Rule;
import org.apache.pig.impl.plan.optimizer.RuleOperator;
import org.apache.pig.impl.plan.optimizer.RulePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalLogicalOptimizer
extends PlanOptimizer<LogicalOperator, LogicalPlan> {
    private static final String SCOPE = "RULE";
    private static NodeIdGenerator nodeIdGen = NodeIdGenerator.getGenerator();

    public FunctionalLogicalOptimizer(LogicalPlan plan) {
        super(plan);
        RulePlan rulePlan = new RulePlan();
        RuleOperator anyLogicalOperator = new RuleOperator(LogicalOperator.class, RuleOperator.NodeType.ANY_NODE, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(anyLogicalOperator);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new ImplicitSplitInserter(plan), "ImplicitSplitInserter"));
        rulePlan = new RulePlan();
        RuleOperator loLoad = new RuleOperator(LOLoad.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loLoad);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new TypeCastInserter(plan, LOLoad.class.getName()), "LoadTypeCastInserter"));
        rulePlan = new RulePlan();
        RuleOperator loStream = new RuleOperator(LOStream.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loStream);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new TypeCastInserter(plan, LOStream.class.getName()), "StreamTypeCastInserter"));
        rulePlan = new RulePlan();
        RuleOperator loNative = new RuleOperator(LONative.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loNative);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new TypeCastInserter(plan, LONative.class.getName()), "NativeTypeCastInserter"));
        rulePlan = new RulePlan();
        RuleOperator loFilter = new RuleOperator(LOFilter.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add(loFilter);
        this.mRules.add(new Rule<LogicalOperator, LogicalPlan>(rulePlan, new TypeCastInserter(plan, LOFilter.class.getName()), "PushUpFilter"));
    }
}

