/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.grunt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jline.Completor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigServer;
import org.apache.pig.tools.grunt.PigCompletor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigCompletorAliases
implements Completor {
    private final Log log = LogFactory.getLog(this.getClass());
    Set<String> keywords = new TreeSet<String>();
    PigServer pig;

    public PigCompletorAliases(PigServer server) {
        this.pig = server;
        try {
            InputStream keywordStream = this.getClass().getResourceAsStream("/org/apache/pig/tools/grunt/autocomplete_aliases");
            PigCompletor.loadCandidateKeywords(keywordStream, this.keywords);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error occurs when reading internal autocomplete_aliases file, skipped");
        }
    }

    public int complete(String buffer, int cursor, List candidates) {
        List<String> matches;
        if (cursor == 0) {
            return -1;
        }
        String[] tokens = buffer.split("\\s+");
        if (tokens.length == 0) {
            return -1;
        }
        if (this.keywords.contains(tokens[tokens.length - 1])) {
            for (String c : this.pig.getAliasKeySet()) {
                candidates.add(c);
            }
            return cursor;
        }
        if (tokens.length == 1) {
            return -1;
        }
        if (!this.keywords.contains(tokens[tokens.length - 2])) {
            return -1;
        }
        if (this.keywords.isEmpty()) {
            return cursor;
        }
        int p = cursor;
        --p;
        while (p > 0) {
            char c = buffer.charAt(p);
            if (Character.isWhitespace(c)) {
                ++p;
                break;
            }
            --p;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = p; i < cursor; ++i) {
            sb.append(buffer.charAt(i));
        }
        if (!sb.toString().equals("") && (matches = this.searchCandidate(sb.toString())) != null) {
            candidates.addAll(matches);
            return p;
        }
        return -1;
    }

    private List<String> searchCandidate(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (String can : this.pig.getAliasKeySet()) {
            if (!can.startsWith(s) || can.equals(s)) continue;
            list.add(can);
        }
        return list;
    }
}

