/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Access;
import mondrian.olap.Annotation;
import mondrian.olap.CacheControl;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.NamedSet;
import mondrian.olap.Parameter;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.GlobalFunTable;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.NoCacheMemberReader;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapNativeRegistry;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapSchemaPool;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SchemaKey;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.aggmatcher.AggTableManager;
import mondrian.spi.CellFormatter;
import mondrian.spi.DataSourceChangeListener;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.spi.MemberFormatter;
import mondrian.spi.PropertyFormatter;
import mondrian.spi.UserDefinedFunction;
import mondrian.spi.impl.Scripts;
import mondrian.util.ByteString;
import mondrian.util.ClassResolver;
import org.apache.commons.vfs.FileSystemException;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchema
implements Schema {
    static final Logger LOGGER = Logger.getLogger(RolapSchema.class);
    private static final Set<Access> schemaAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.ALL_DIMENSIONS, Access.CUSTOM});
    private static final Set<Access> cubeAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> dimensionAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> hierarchyAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> memberAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL});
    private String name;
    private RolapConnection internalConnection;
    private final Map<String, RolapCube> mapNameToCube = new HashMap<String, RolapCube>();
    private final Map<String, MemberReader> mapSharedHierarchyToReader = new HashMap<String, MemberReader>();
    private final Map<String, RolapHierarchy> mapSharedHierarchyNameToHierarchy = new HashMap<String, RolapHierarchy>();
    private Role defaultRole;
    private ByteString md5Bytes;
    private AggTableManager aggTableManager;
    final SchemaKey key;
    private final Map<String, Role> mapNameToRole = new HashMap<String, Role>();
    private final Map<String, NamedSet> mapNameToSet = new HashMap<String, NamedSet>();
    private FunTable funTable;
    private MondrianDef.Schema xmlSchema;
    final List<RolapSchemaParameter> parameterList = new ArrayList<RolapSchemaParameter>();
    private Date schemaLoadDate;
    private DataSourceChangeListener dataSourceChangeListener;
    private final List<Exception> warningList = new ArrayList<Exception>();
    private Map<String, Annotation> annotationMap;
    private final String id;
    private RolapStarRegistry rolapStarRegistry = new RolapStarRegistry();
    final RolapNativeRegistry nativeRegistry = new RolapNativeRegistry();

    private RolapSchema(SchemaKey key, Util.PropertyList connectInfo, DataSource dataSource, ByteString md5Bytes, boolean useContentChecksum) {
        this.id = Util.generateUuidString();
        this.key = key;
        this.md5Bytes = md5Bytes;
        if (useContentChecksum && md5Bytes == null) {
            throw new AssertionError();
        }
        this.defaultRole = Util.createRootRole(this);
        MondrianServer internalServer = MondrianServer.forId(null);
        this.internalConnection = new RolapConnection(internalServer, connectInfo, this, dataSource);
        internalServer.removeConnection(this.internalConnection);
        internalServer.removeStatement(this.internalConnection.getInternalStatement());
        this.aggTableManager = new AggTableManager(this);
        this.dataSourceChangeListener = this.createDataSourceChangeListener(connectInfo);
    }

    RolapSchema(SchemaKey key, ByteString md5Bytes, String catalogUrl, String catalogStr, Util.PropertyList connectInfo, DataSource dataSource) {
        this(key, connectInfo, dataSource, md5Bytes, md5Bytes != null);
        this.load(catalogUrl, catalogStr);
        assert (this.md5Bytes != null);
    }

    static CellFormatter getCellFormatter(String className, Scripts.ScriptDefinition script) throws Exception {
        if (className == null && script == null) {
            throw Util.newError("Must specify either className attribute or Script element");
        }
        if (className != null && script != null) {
            throw Util.newError("Must not specify both className attribute and Script element");
        }
        if (className != null) {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            return (CellFormatter)ctor.newInstance(new Object[0]);
        }
        return Scripts.cellFormatter(script);
    }

    static MemberFormatter getMemberFormatter(String className, Scripts.ScriptDefinition script) throws Exception {
        if (className == null && script == null) {
            throw Util.newError("Must specify either className attribute or Script element");
        }
        if (className != null && script != null) {
            throw Util.newError("Must not specify both className attribute and Script element");
        }
        if (className != null) {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            return (MemberFormatter)ctor.newInstance(new Object[0]);
        }
        return Scripts.memberFormatter(script);
    }

    static PropertyFormatter createPropertyFormatter(String className, Scripts.ScriptDefinition script) throws Exception {
        if (className == null && script == null) {
            throw Util.newError("Must specify either className attribute or Script element");
        }
        if (className != null && script != null) {
            throw Util.newError("Must not specify both className attribute and Script element");
        }
        if (className != null) {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            return (PropertyFormatter)ctor.newInstance(new Object[0]);
        }
        return Scripts.propertyFormatter(script);
    }

    protected void flushSegments() {
        RolapConnection internalConnection = this.getInternalConnection();
        if (internalConnection != null) {
            CacheControl cc = internalConnection.getCacheControl(null);
            for (RolapCube cube : this.getCubeList()) {
                cc.flush(cc.createMeasuresRegion(cube));
            }
        }
    }

    protected void flushJdbcSchema() {
        if (this.aggTableManager != null) {
            this.aggTableManager.finalCleanUp();
            this.aggTableManager = null;
        }
    }

    protected void finalCleanUp() {
        this.flushSegments();
        this.flushJdbcSchema();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.flushJdbcSchema();
        }
        catch (Throwable t) {
            LOGGER.info((Object)MondrianResource.instance().FinalizerErrorRolapSchema.baseMessage, t);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RolapSchema)) {
            return false;
        }
        RolapSchema other = (RolapSchema)o;
        return other.key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String catalogUrl, String catalogStr) {
        try {
            DOMWrapper def;
            Parser xmlParser = XOMUtil.createDefaultParser();
            if (catalogStr == null) {
                InputStream in = null;
                try {
                    in = Util.readVirtualFile(catalogUrl);
                    def = xmlParser.parse(in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                if (this.getLogger().isDebugEnabled() || this.md5Bytes == null) {
                    try {
                        catalogStr = Util.readVirtualFileAsString(catalogUrl);
                    }
                    catch (IOException ex) {
                        this.getLogger().debug((Object)("RolapSchema.load: ex=" + ex));
                        catalogStr = "?";
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapSchema.load: content: \n" + catalogStr));
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapSchema.load: catalogStr: \n" + catalogStr));
                }
                def = xmlParser.parse(catalogStr);
            }
            if (this.md5Bytes == null) {
                assert (catalogStr != null);
                this.md5Bytes = new ByteString(Util.digestMd5(catalogStr));
            }
            this.checkSchemaVersion(def);
            this.xmlSchema = new MondrianDef.Schema(def);
            if (this.getLogger().isDebugEnabled()) {
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter(sw);
                pw.println("RolapSchema.load: dump xmlschema");
                this.xmlSchema.display(pw, 2);
                pw.flush();
                this.getLogger().debug((Object)sw.toString());
            }
            this.load(this.xmlSchema);
        }
        catch (XOMException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        catch (FileSystemException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        catch (IOException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        this.aggTableManager.initialize();
        this.setSchemaLoadDate();
    }

    private void checkSchemaVersion(DOMWrapper schemaDom) {
        String[] versionParts;
        String schemaVersion = schemaDom.getAttribute("metamodelVersion");
        if (schemaVersion == null) {
            schemaVersion = this.hasMondrian4Elements(schemaDom) ? "4.x" : "3.x";
        }
        String schemaMajor = (versionParts = schemaVersion.split("\\.")).length > 0 ? versionParts[0] : "";
        MondrianServer.MondrianVersion mondrianVersion = MondrianServer.forId(null).getVersion();
        String serverMajor = mondrianVersion.getMajorVersion() + "";
        if (serverMajor.compareTo(schemaMajor) < 0) {
            String errorMsg = "Schema version '" + schemaVersion + "' is later than schema version " + "'3.x' supported by this version of Mondrian";
            throw Util.newError(errorMsg);
        }
    }

    private boolean hasMondrian4Elements(DOMWrapper schemaDom) {
        for (DOMWrapper child : schemaDom.getChildren()) {
            if ("PhysicalSchema".equals(child.getTagName())) {
                return true;
            }
            if (!"Cube".equals(child.getTagName())) continue;
            for (DOMWrapper grandchild : child.getChildren()) {
                if (!"MeasureGroups".equals(grandchild.getTagName())) continue;
                return true;
            }
        }
        return false;
    }

    private void setSchemaLoadDate() {
        this.schemaLoadDate = new Date();
    }

    @Override
    public Date getSchemaLoadDate() {
        return this.schemaLoadDate;
    }

    @Override
    public List<Exception> getWarnings() {
        return Collections.unmodifiableList(this.warningList);
    }

    public Role getDefaultRole() {
        return this.defaultRole;
    }

    public MondrianDef.Schema getXMLSchema() {
        return this.xmlSchema;
    }

    @Override
    public String getName() {
        Util.assertPostcondition(this.name != null, "return != null");
        Util.assertPostcondition(this.name.length() > 0, "return.length() > 0");
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    public Dialect getDialect() {
        DataSource dataSource = this.getInternalConnection().getDataSource();
        return DialectManager.createDialect(dataSource, null);
    }

    private void load(MondrianDef.Schema xmlSchema) {
        RolapCube cube;
        this.name = xmlSchema.name;
        if (this.name == null || this.name.equals("")) {
            throw Util.newError("<Schema> name must be set");
        }
        this.annotationMap = RolapHierarchy.createAnnotationMap(xmlSchema.annotations);
        HashMap<String, UdfResolver.UdfFactory> mapNameToUdf = new HashMap<String, UdfResolver.UdfFactory>();
        for (MondrianDef.UserDefinedFunction udf : xmlSchema.userDefinedFunctions) {
            Scripts.ScriptDefinition scriptDef = RolapSchema.toScriptDef(udf.script);
            this.defineFunction(mapNameToUdf, udf.name, udf.className, scriptDef);
        }
        RolapSchemaFunctionTable funTable = new RolapSchemaFunctionTable(mapNameToUdf.values());
        funTable.init();
        this.funTable = funTable;
        for (MondrianDef.Dimension xmlDimension : xmlSchema.dimensions) {
            if (xmlDimension.foreignKey == null) continue;
            throw MondrianResource.instance().PublicDimensionMustNotHaveForeignKey.ex(xmlDimension.name);
        }
        HashSet<String> parameterNames = new HashSet<String>();
        for (MondrianDef.Parameter parameter : xmlSchema.parameters) {
            String name = parameter.name;
            if (!parameterNames.add(name)) {
                throw MondrianResource.instance().DuplicateSchemaParameter.ex(name);
            }
            Type type = parameter.type.equals("String") ? new StringType() : (parameter.type.equals("Numeric") ? new NumericType() : new MemberType(null, null, null, null));
            String description = parameter.description;
            boolean modifiable = parameter.modifiable;
            String defaultValue = parameter.defaultValue;
            RolapSchemaParameter param = new RolapSchemaParameter(this, name, defaultValue, description, type, modifiable);
            Util.discard((Object)param);
        }
        for (ElementDef elementDef : xmlSchema.cubes) {
            if (!elementDef.isEnabled()) continue;
            cube = new RolapCube(this, xmlSchema, (MondrianDef.Cube)elementDef, true);
            Util.discard((Object)cube);
        }
        for (ElementDef elementDef : xmlSchema.virtualCubes) {
            if (!elementDef.isEnabled()) continue;
            cube = new RolapCube(this, xmlSchema, (MondrianDef.VirtualCube)elementDef, true);
            Util.discard((Object)cube);
        }
        for (ElementDef elementDef : xmlSchema.namedSets) {
            this.mapNameToSet.put(elementDef.name, this.createNamedSet((MondrianDef.NamedSet)elementDef));
        }
        for (ElementDef elementDef : xmlSchema.roles) {
            Role role = this.createRole((MondrianDef.Role)elementDef);
            this.mapNameToRole.put(elementDef.name, role);
        }
        if (xmlSchema.defaultRole != null) {
            Role role = this.lookupRole(xmlSchema.defaultRole);
            if (role == null) {
                this.error("Role '" + xmlSchema.defaultRole + "' not found", this.locate(xmlSchema, "defaultRole"));
            } else {
                this.defaultRole = role;
            }
        }
    }

    static Scripts.ScriptDefinition toScriptDef(MondrianDef.Script script) {
        if (script == null) {
            return null;
        }
        Scripts.ScriptLanguage language = Scripts.ScriptLanguage.lookup(script.language);
        if (language == null) {
            throw Util.newError("Invalid script language '" + script.language + "'");
        }
        return new Scripts.ScriptDefinition(script.cdata, language);
    }

    XmlLocation locate(ElementDef node, String attributeName) {
        return null;
    }

    void error(String message, XmlLocation xmlLocation) {
        RuntimeException ex = new RuntimeException(message);
        if (this.internalConnection == null || !"true".equals(this.internalConnection.getProperty(RolapConnectionProperties.Ignore.name()))) {
            throw ex;
        }
        this.warningList.add(ex);
    }

    private NamedSet createNamedSet(MondrianDef.NamedSet xmlNamedSet) {
        Exp exp;
        String formulaString = xmlNamedSet.getFormula();
        try {
            exp = this.getInternalConnection().parseExpression(formulaString);
        }
        catch (Exception e) {
            throw MondrianResource.instance().NamedSetHasBadFormula.ex(xmlNamedSet.name, e);
        }
        Formula formula = new Formula(new Id(new Id.NameSegment(xmlNamedSet.name, Id.Quoting.UNQUOTED)), exp);
        return formula.getNamedSet();
    }

    private Role createRole(MondrianDef.Role xmlRole) {
        boolean ignoreInvalidMembers = MondrianProperties.instance().IgnoreInvalidMembers.get();
        if (xmlRole.union != null) {
            if (xmlRole.schemaGrants != null && xmlRole.schemaGrants.length > 0) {
                throw MondrianResource.instance().RoleUnionGrants.ex();
            }
            ArrayList<Role> roleList = new ArrayList<Role>();
            for (MondrianDef.RoleUsage roleUsage : xmlRole.union.roleUsages) {
                Role role = this.mapNameToRole.get(roleUsage.roleName);
                if (role == null) {
                    throw MondrianResource.instance().UnknownRole.ex(roleUsage.roleName);
                }
                roleList.add(role);
            }
            return RoleImpl.union(roleList);
        }
        RoleImpl role = new RoleImpl();
        for (MondrianDef.SchemaGrant schemaGrant : xmlRole.schemaGrants) {
            role.grant(this, this.getAccess(schemaGrant.access, schemaAllowed));
            for (MondrianDef.CubeGrant cubeGrant : schemaGrant.cubeGrants) {
                RolapCube cube = this.lookupCube(cubeGrant.cube);
                if (cube == null) {
                    throw Util.newError("Unknown cube '" + cubeGrant.cube + "'");
                }
                role.grant(cube, this.getAccess(cubeGrant.access, cubeAllowed));
                SchemaReader schemaReader = cube.getSchemaReader(null);
                for (MondrianDef.DimensionGrant dimensionGrant : cubeGrant.dimensionGrants) {
                    Dimension dimension = (Dimension)schemaReader.lookupCompound(cube, Util.parseIdentifier(dimensionGrant.dimension), true, 2);
                    role.grant(dimension, this.getAccess(dimensionGrant.access, dimensionAllowed));
                }
                for (ElementDef elementDef : cubeGrant.hierarchyGrants) {
                    Role.RollupPolicy rollupPolicy;
                    Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, Util.parseIdentifier(elementDef.hierarchy), true, 3);
                    Access hierarchyAccess = this.getAccess(elementDef.access, hierarchyAllowed);
                    Level topLevel = null;
                    if (elementDef.topLevel != null) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify 'topLevel' if access='custom'");
                        }
                        topLevel = (Level)schemaReader.lookupCompound(cube, Util.parseIdentifier(elementDef.topLevel), true, 4);
                    }
                    Level bottomLevel = null;
                    if (elementDef.bottomLevel != null) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify 'bottomLevel' if access='custom'");
                        }
                        bottomLevel = (Level)schemaReader.lookupCompound(cube, Util.parseIdentifier(elementDef.bottomLevel), true, 4);
                    }
                    if (elementDef.rollupPolicy != null) {
                        try {
                            rollupPolicy = Role.RollupPolicy.valueOf(elementDef.rollupPolicy.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            throw Util.newError("Illegal rollupPolicy value '" + elementDef.rollupPolicy + "'");
                        }
                    } else {
                        rollupPolicy = Role.RollupPolicy.FULL;
                    }
                    role.grant(hierarchy, hierarchyAccess, topLevel, bottomLevel, rollupPolicy);
                    for (MondrianDef.MemberGrant memberGrant : elementDef.memberGrants) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify <MemberGrant> if <Hierarchy> has access='custom'");
                        }
                        Member member = schemaReader.withLocus().getMemberByUniqueName(Util.parseIdentifier(memberGrant.member), !ignoreInvalidMembers);
                        if (member == null) {
                            assert (ignoreInvalidMembers);
                            continue;
                        }
                        if (member.getHierarchy() != hierarchy) {
                            throw Util.newError("Member '" + member + "' is not in hierarchy '" + hierarchy + "'");
                        }
                        role.grant(member, this.getAccess(memberGrant.access, memberAllowed));
                    }
                }
            }
        }
        role.makeImmutable();
        return role;
    }

    private Access getAccess(String accessString, Set<Access> allowed) {
        Access access = Access.valueOf(accessString.toUpperCase());
        if (allowed.contains((Object)access)) {
            return access;
        }
        throw Util.newError("Bad value access='" + accessString + "'");
    }

    @Override
    public Dimension createDimension(Cube cube, String xml) {
        MondrianDef.CubeDimension xmlDimension;
        block4: {
            try {
                Parser xmlParser = XOMUtil.createDefaultParser();
                DOMWrapper def = xmlParser.parse(xml);
                String tagName = def.getTagName();
                if (tagName.equals("Dimension")) {
                    xmlDimension = new MondrianDef.Dimension(def);
                    break block4;
                }
                if (tagName.equals("DimensionUsage")) {
                    xmlDimension = new MondrianDef.DimensionUsage(def);
                    break block4;
                }
                throw new XOMException("Got <" + tagName + "> when expecting <Dimension> or <DimensionUsage>");
            }
            catch (XOMException e) {
                throw Util.newError(e, "Error while adding dimension to cube '" + cube + "' from XML [" + xml + "]");
            }
        }
        return ((RolapCube)cube).createDimension(xmlDimension, this.xmlSchema);
    }

    @Override
    public Cube createCube(String xml) {
        RolapCube cube;
        block4: {
            try {
                Parser xmlParser = XOMUtil.createDefaultParser();
                DOMWrapper def = xmlParser.parse(xml);
                String tagName = def.getTagName();
                if (tagName.equals("Cube")) {
                    MondrianDef.Schema xmlSchema = new MondrianDef.Schema();
                    MondrianDef.Cube xmlDimension = new MondrianDef.Cube(def);
                    cube = new RolapCube(this, xmlSchema, xmlDimension, false);
                    break block4;
                }
                if (tagName.equals("VirtualCube")) {
                    MondrianDef.Schema xmlSchema = this.getXMLSchema();
                    MondrianDef.VirtualCube xmlDimension = new MondrianDef.VirtualCube(def);
                    cube = new RolapCube(this, xmlSchema, xmlDimension, false);
                    break block4;
                }
                throw new XOMException("Got <" + tagName + "> when expecting <Cube>");
            }
            catch (XOMException e) {
                throw Util.newError(e, "Error while creating cube from XML [" + xml + "]");
            }
        }
        return cube;
    }

    public static List<RolapSchema> getRolapSchemas() {
        return RolapSchemaPool.instance().getRolapSchemas();
    }

    public static boolean cacheContains(RolapSchema rolapSchema) {
        return RolapSchemaPool.instance().contains(rolapSchema);
    }

    @Override
    public Cube lookupCube(String cube, boolean failIfNotFound) {
        RolapCube mdxCube = this.lookupCube(cube);
        if (mdxCube == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCubeNotFound.ex(cube);
        }
        return mdxCube;
    }

    protected RolapCube lookupCube(String cubeName) {
        return this.mapNameToCube.get(Util.normalizeName(cubeName));
    }

    protected MondrianDef.CalculatedMember lookupXmlCalculatedMember(String calcMemberName, String cubeName) {
        for (MondrianDef.Cube cube : this.xmlSchema.cubes) {
            if (!Util.equalName(cube.name, cubeName)) continue;
            for (MondrianDef.CalculatedMember xmlCalcMember : cube.calculatedMembers) {
                if (!Util.equalName(this.calcMemberFqName(xmlCalcMember), calcMemberName)) continue;
                return xmlCalcMember;
            }
        }
        return null;
    }

    private String calcMemberFqName(MondrianDef.CalculatedMember xmlCalcMember) {
        if (xmlCalcMember.dimension != null) {
            return Util.makeFqName(Util.quoteMdxIdentifier(xmlCalcMember.dimension), xmlCalcMember.name);
        }
        return Util.makeFqName(xmlCalcMember.hierarchy, xmlCalcMember.name);
    }

    public List<RolapCube> getCubesWithStar(RolapStar star) {
        ArrayList<RolapCube> list = new ArrayList<RolapCube>();
        for (RolapCube cube : this.mapNameToCube.values()) {
            if (star != cube.getStar()) continue;
            list.add(cube);
        }
        return list;
    }

    protected void addCube(RolapCube cube) {
        this.mapNameToCube.put(Util.normalizeName(cube.getName()), cube);
    }

    @Override
    public boolean removeCube(String cubeName) {
        RolapCube cube = this.mapNameToCube.remove(Util.normalizeName(cubeName));
        return cube != null;
    }

    @Override
    public Cube[] getCubes() {
        Collection<RolapCube> cubes = this.mapNameToCube.values();
        return cubes.toArray(new RolapCube[cubes.size()]);
    }

    public List<RolapCube> getCubeList() {
        return new ArrayList<RolapCube>(this.mapNameToCube.values());
    }

    @Override
    public Hierarchy[] getSharedHierarchies() {
        Collection<RolapHierarchy> hierarchies = this.mapSharedHierarchyNameToHierarchy.values();
        return hierarchies.toArray(new RolapHierarchy[hierarchies.size()]);
    }

    RolapHierarchy getSharedHierarchy(String name) {
        return this.mapSharedHierarchyNameToHierarchy.get(name);
    }

    public NamedSet getNamedSet(String name) {
        return this.mapNameToSet.get(name);
    }

    public NamedSet getNamedSet(IdentifierSegment segment) {
        for (Map.Entry<String, NamedSet> entry : this.mapNameToSet.entrySet()) {
            if (!Util.matches(segment, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Role lookupRole(String role) {
        return this.mapNameToRole.get(role);
    }

    public Set<String> roleNames() {
        return this.mapNameToRole.keySet();
    }

    @Override
    public FunTable getFunTable() {
        return this.funTable;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    private void defineFunction(Map<String, UdfResolver.UdfFactory> mapNameToUdf, final String name, String className, final Scripts.ScriptDefinition script) {
        UdfResolver.UdfFactory udfFactory;
        if (className == null && script == null) {
            throw Util.newError("Must specify either className attribute or Script element");
        }
        if (className != null && script != null) {
            throw Util.newError("Must not specify both className attribute and Script element");
        }
        if (className != null) {
            try {
                Class klass = ClassResolver.INSTANCE.forName(className, true);
                udfFactory = new UdfResolver.ClassUdfFactory(klass, name);
            }
            catch (ClassNotFoundException e) {
                throw MondrianResource.instance().UdfClassNotFound.ex(name, className);
            }
        } else {
            udfFactory = new UdfResolver.UdfFactory(){

                public UserDefinedFunction create() {
                    return Scripts.userDefinedFunction(script, name);
                }
            };
        }
        this.validateFunction(udfFactory);
        UdfResolver.UdfFactory existingUdf = mapNameToUdf.get(name);
        if (existingUdf != null) {
            throw MondrianResource.instance().UdfDuplicateName.ex(name);
        }
        mapNameToUdf.put(name, udfFactory);
    }

    private void validateFunction(UdfResolver.UdfFactory udfFactory) {
        UserDefinedFunction udf = udfFactory.create();
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        String description = udf.getDescription();
        Util.discard((Object)description);
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        String[] reservedWords = udf.getReservedWords();
        Util.discard((Object)reservedWords);
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }

    synchronized MemberReader createMemberReader(String sharedName, RolapHierarchy hierarchy, String memberReaderClass) {
        MemberReader reader;
        if (sharedName != null) {
            reader = this.mapSharedHierarchyToReader.get(sharedName);
            if (reader == null) {
                reader = this.createMemberReader(hierarchy, memberReaderClass);
                if (!this.mapSharedHierarchyNameToHierarchy.containsKey(sharedName)) {
                    this.mapSharedHierarchyNameToHierarchy.put(sharedName, hierarchy);
                }
            }
        } else {
            reader = this.createMemberReader(hierarchy, memberReaderClass);
        }
        return reader;
    }

    private MemberReader createMemberReader(RolapHierarchy hierarchy, String memberReaderClass) {
        if (memberReaderClass != null) {
            ReflectiveOperationException e2;
            try {
                Object properties = null;
                Class clazz = ClassResolver.INSTANCE.forName(memberReaderClass, true);
                Constructor constructor = clazz.getConstructor(RolapHierarchy.class, Properties.class);
                Object o = constructor.newInstance(hierarchy, properties);
                if (o instanceof MemberReader) {
                    return (MemberReader)o;
                }
                if (o instanceof MemberSource) {
                    return new CacheMemberReader((MemberSource)o);
                }
                throw Util.newInternal("member reader class " + clazz + " does not implement " + MemberSource.class);
            }
            catch (ClassNotFoundException e) {
                e2 = e;
            }
            catch (NoSuchMethodException e) {
                e2 = e;
            }
            catch (InstantiationException e) {
                e2 = e;
            }
            catch (IllegalAccessException e) {
                e2 = e;
            }
            catch (InvocationTargetException e) {
                e2 = e;
            }
            throw Util.newInternal(e2, "while instantiating member reader '" + memberReaderClass);
        }
        SqlMemberSource source = new SqlMemberSource(hierarchy);
        if (hierarchy.getDimension().isHighCardinality()) {
            LOGGER.debug((Object)("High cardinality for " + hierarchy.getDimension()));
            return new NoCacheMemberReader(source);
        }
        LOGGER.debug((Object)("Normal cardinality for " + hierarchy.getDimension()));
        if (MondrianProperties.instance().DisableCaching.get()) {
            return new NoCacheMemberReader(source);
        }
        return new SmartMemberReader(source);
    }

    @Override
    public SchemaReader getSchemaReader() {
        return new RolapSchemaReader(this.defaultRole, this).withLocus();
    }

    private DataSourceChangeListener createDataSourceChangeListener(Util.PropertyList connectInfo) {
        DataSourceChangeListener changeListener = null;
        String dataSourceChangeListenerStr = connectInfo.get(RolapConnectionProperties.DataSourceChangeListener.name());
        if (!Util.isEmpty(dataSourceChangeListenerStr)) {
            try {
                changeListener = (DataSourceChangeListener)ClassResolver.INSTANCE.instantiateSafe(dataSourceChangeListenerStr, new Object[0]);
            }
            catch (Exception e) {
                throw Util.newError(e, "loading DataSourceChangeListener " + dataSourceChangeListenerStr);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("RolapSchema.createDataSourceChangeListener: create datasource change listener \"" + dataSourceChangeListenerStr));
            }
        }
        return changeListener;
    }

    public ByteString getChecksum() {
        return this.md5Bytes;
    }

    public RolapConnection getInternalConnection() {
        return this.internalConnection;
    }

    private RolapStar makeRolapStar(MondrianDef.Relation fact) {
        DataSource dataSource = this.getInternalConnection().getDataSource();
        return new RolapStar(this, dataSource, fact);
    }

    public RolapStarRegistry getRolapStarRegistry() {
        return this.rolapStarRegistry;
    }

    public RolapStar getStar(String factTableName) {
        return this.getRolapStarRegistry().getStar(factTableName);
    }

    public Collection<RolapStar> getStars() {
        return this.getRolapStarRegistry().getStars();
    }

    RolapNativeRegistry getNativeRegistry() {
        return this.nativeRegistry;
    }

    public DataSourceChangeListener getDataSourceChangeListener() {
        return this.dataSourceChangeListener;
    }

    public void setDataSourceChangeListener(DataSourceChangeListener dataSourceChangeListener) {
        this.dataSourceChangeListener = dataSourceChangeListener;
    }

    private static interface XmlLocation {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RolapSchemaFunctionTable
    extends FunTableImpl {
        private final List<UdfResolver.UdfFactory> udfFactoryList;

        RolapSchemaFunctionTable(Collection<UdfResolver.UdfFactory> udfs) {
            this.udfFactoryList = new ArrayList<UdfResolver.UdfFactory>(udfs);
        }

        @Override
        public void defineFunctions(FunTable.Builder builder) {
            GlobalFunTable globalFunTable = GlobalFunTable.instance();
            for (String reservedWord : globalFunTable.getReservedWords()) {
                builder.defineReserved(reservedWord);
            }
            for (Resolver resolver : globalFunTable.getResolvers()) {
                builder.define(resolver);
            }
            for (UdfResolver.UdfFactory udfFactory : this.udfFactoryList) {
                builder.define(new UdfResolver(udfFactory));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RolapStarRegistry {
        private final Map<String, RolapStar> stars = new HashMap<String, RolapStar>();

        RolapStarRegistry() {
        }

        synchronized RolapStar getOrCreateStar(MondrianDef.Relation fact) {
            String factTableName = fact.getAlias();
            RolapStar star = this.stars.get(factTableName);
            if (star == null) {
                star = RolapSchema.this.makeRolapStar(fact);
                this.stars.put(factTableName, star);
            }
            return star;
        }

        synchronized RolapStar getStar(String factTableName) {
            return this.stars.get(factTableName);
        }

        synchronized Collection<RolapStar> getStars() {
            return this.stars.values();
        }
    }
}

