/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteString
implements Comparable<ByteString>,
Serializable {
    private final byte[] bytes;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ByteString(byte[] bytes) {
        this.bytes = (byte[])bytes.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        return obj instanceof ByteString && Arrays.equals(this.bytes, ((ByteString)obj).bytes);
    }

    @Override
    public int compareTo(ByteString that) {
        byte[] v1 = this.bytes;
        byte[] v2 = that.bytes;
        int n = Math.min(v1.length, v2.length);
        for (int i = 0; i < n; ++i) {
            byte c1 = v1[i];
            byte c2 = v2[i];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return v1.length - v2.length;
    }

    public String toString() {
        char[] chars = new char[this.bytes.length * 2];
        int j = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            byte b = this.bytes[i];
            chars[j++] = digits[(b & 0xF0) >> 4];
            chars[j++] = digits[b & 0xF];
        }
        return new String(chars);
    }

    public Object clone() {
        return this;
    }

    public int length() {
        return this.bytes.length;
    }

    public byte byteAt(int i) {
        return this.bytes[i];
    }
}

