/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VMSTests
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: VMSTests.java,v 1.3 2007/03/02 07:10:18 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$VMSTests;

    protected String getLogName() {
        return "TestVMS.log";
    }

    public void testDir() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir();
            this.print(list);
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 552) break block2;
                VMSTests.fail((String)("dir(" + randomName + ") should throw 550/552 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testDirFull() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir("", true);
            this.print(list);
            this.log.debug("******* dirDetails *******");
            FTPFile[] files = this.ftp.dirDetails("");
            this.print(files);
            this.log.debug("******* end dirDetails *******");
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName, true);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 552) break block2;
                VMSTests.fail((String)("dir(" + randomName + ") should throw 550/552 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testChangeDir() throws Exception {
        this.log.debug("testChangeDir");
        this.connect();
        this.ftp.chdir(this.testdir);
        String dir = this.getRemoteDirName();
        this.ftp.chdir(dir);
        this.ftp.cdup();
        this.ftp.quit();
    }

    public void testTransfer() throws Exception {
        this.log.debug("testTransfer");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.ASCII);
        String filename = this.generateRandomFilename();
        String remoteFile = this.getRemoteFileName();
        if (remoteFile == null) {
            remoteFile = this.remoteTextFile;
        }
        this.ftp.get(this.localDataDir + filename, remoteFile);
        this.ftp.setType(FTPTransferType.BINARY);
        this.ftp.get(this.localDataDir + filename, remoteFile);
        File local = new File(this.localDataDir + filename);
        local.delete();
        this.ftp.quit();
    }

    private String getRemoteFileName() throws IOException, FTPException, ParseException {
        FTPFile[] files = this.ftp.dirDetails("");
        String remoteFile = null;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().toUpperCase().endsWith(".TXT")) continue;
            remoteFile = files[i].getName();
            break;
        }
        return remoteFile;
    }

    private String getRemoteDirName() throws IOException, FTPException, ParseException {
        FTPFile[] files = this.ftp.dirDetails("");
        String dir = null;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDir()) continue;
            dir = files[i].getName();
            break;
        }
        return dir;
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$VMSTests == null ? (class$com$enterprisedt$net$ftp$test$VMSTests = VMSTests.class$("com.enterprisedt.net.ftp.test.VMSTests")) : class$com$enterprisedt$net$ftp$test$VMSTests);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VMSTests.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

