/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.FontException;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.AbstractFontFileRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeCollection;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontRecord;

public class TrueTypeFontRegistry
extends AbstractFontFileRegistry {
    private static FontCache secondLevelCache;
    private static final Log logger;
    private static final FontPathFilter FONTPATHFILTER;

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    @Override
    public FontCache getSecondLevelCache() {
        return TrueTypeFontRegistry.internalGetSecondLevelCache();
    }

    @Override
    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addFont(File file, String encoding) throws IOException {
        try {
            if (StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                int i = 0;
                while ((long)i < ttc.getNumFonts()) {
                    TrueTypeFont font = null;
                    try {
                        font = ttc.getFont(i);
                        this.registerTrueTypeFont(font);
                    }
                    finally {
                        if (font != null) {
                            font.dispose();
                        }
                    }
                    ++i;
                }
            } else {
                TrueTypeFont font = null;
                try {
                    font = new TrueTypeFont(file);
                    this.registerTrueTypeFont(font);
                }
                finally {
                    if (font != null) {
                        font.dispose();
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to register font file " + file), (Throwable)e);
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Unable to register font file " + file + " - " + e.getMessage()));
            }
            return false;
        }
    }

    private void registerTrueTypeFont(TrueTypeFont font) throws IOException {
        NameTable table = (NameTable)font.getTable(1851878757L);
        if (table == null) {
            throw new IOException("The font '" + font.getFilename() + "' does not have a 'name' table. It is not valid.");
        }
        if (font.getTable(1330851634L) == null) {
            throw new IOException("The font '" + font.getFilename() + "' does not have a 'os/2' table. It is not valid.");
        }
        if (font.getTable(1751474532L) == null) {
            throw new IOException("The font '" + font.getFilename() + "' does not have a 'head' table. It is not valid.");
        }
        if (font.getTable(1751672161L) == null) {
            throw new IOException("The font '" + font.getFilename() + "' does not have a 'hhea' table. It is not valid.");
        }
        String familyName = table.getPrimaryName(1);
        DefaultFontFamily fontFamily = this.createFamily(familyName);
        try {
            TrueTypeFontRecord record = new TrueTypeFontRecord(font, fontFamily);
            fontFamily.addFontRecord(record);
        }
        catch (FontException e) {
            logger.info((Object)("The font '" + font.getFilename() + "' is invalid."), (Throwable)e);
            return;
        }
        this.registerPrimaryName(familyName, fontFamily);
        this.registerAlternativeName(familyName, fontFamily);
        for (String name : table.getAllNames(1)) {
            fontFamily.addName(name);
            this.registerAlternativeName(name, fontFamily);
        }
        for (String name : table.getAllNames(4)) {
            this.registerFullName(name, fontFamily);
        }
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        return new TrueTypeFontMetricsFactory();
    }

    @Override
    protected String getCacheFileName() {
        return "ttf-fontcache.ser";
    }

    static {
        logger = LogFactory.getLog(TrueTypeFontRegistry.class);
        FONTPATHFILTER = new FontPathFilter();
    }

    private static class FontPathFilter
    implements FileFilter,
    Serializable {
        protected FontPathFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttf")) {
                return true;
            }
            if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttc")) {
                return true;
            }
            return StringUtils.endsWithIgnoreCase((String)name, (String)".otf");
        }
    }
}

