/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.drilldown;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.VFS;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationHelper;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshEvent;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshListener;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.editor.drilldown.model.Parameter;
import org.pentaho.reporting.designer.core.editor.drilldown.model.ParameterDocument;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.PentahoPathModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.LoginTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishException;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.libraries.designtime.swing.background.GenericCancelHandler;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PentahoParameterRefreshHandler
implements DrillDownParameterRefreshListener {
    private static final Log logger = LogFactory.getLog(PentahoParameterRefreshHandler.class);
    private PentahoPathModel pathModel;
    private DrillDownParameterTable parameterTable;
    private ReportDesignerContext reportDesignerContext;
    private Component component;

    public static HttpClient createHttpClient(AuthenticationData loginData) {
        HttpClient client = new HttpClient();
        client.getParams().setCookiePolicy("compatibility");
        client.getParams().setSoTimeout(WorkspaceSettings.getInstance().getConnectionTimeout() * 1000);
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(AuthScope.ANY, AuthenticationHelper.getCredentials((String)loginData.getUsername(), (String)loginData.getPassword()));
        return client;
    }

    public PentahoParameterRefreshHandler(PentahoPathModel pentahoPathWrapper, ReportDesignerContext reportDesignerContext, Component component) {
        if (pentahoPathWrapper == null) {
            throw new NullPointerException();
        }
        if (reportDesignerContext == null) {
            throw new NullPointerException();
        }
        if (component == null) {
            throw new NullPointerException();
        }
        this.reportDesignerContext = reportDesignerContext;
        this.component = component;
        this.pathModel = pentahoPathWrapper;
    }

    public PentahoPathModel getPathModel() {
        return this.pathModel;
    }

    public DrillDownParameterTable getParameterTable() {
        return this.parameterTable;
    }

    public void setParameterTable(DrillDownParameterTable parameterTable) {
        this.parameterTable = parameterTable;
    }

    private static String getParameterServicePath(AuthenticationData loginData, PentahoPathModel pathModel) {
        try {
            FileObject fileSystemRoot = PublishUtil.createVFSConnection(VFS.getManager(), loginData);
            FileSystem fileSystem = fileSystemRoot.getFileSystem();
            String localPath = pathModel.getLocalPath();
            FileObject object = fileSystemRoot.resolveFile(localPath);
            FileContent content = object.getContent();
            String majorVersionText = (String)fileSystem.getAttribute("version-major");
            if (!StringUtils.isEmpty((String)majorVersionText)) {
                String paramService = (String)content.getAttribute("param-service-url");
                if (StringUtils.isEmpty((String)paramService)) {
                    return null;
                }
                if (paramService.startsWith("http://") || paramService.startsWith("https://")) {
                    return paramService;
                }
                try {
                    URL target = new URL(loginData.getUrl());
                    String host = target.getPort() != -1 ? target.getHost() + ":" + target.getPort() : target.getHost();
                    return target.getProtocol() + "://" + host + paramService;
                }
                catch (MalformedURLException e) {
                    UncaughtExceptionsModel.getInstance().addException((Throwable)e);
                    return null;
                }
            }
            String extension = IOUtils.getInstance().getFileExtension(localPath);
            if (".prpt".equals(extension)) {
                logger.debug((Object)"Ancient pentaho system detected: parameter service does not deliver valid parameter values");
                String name = pathModel.getName();
                String path = pathModel.getPath();
                String solution = pathModel.getSolution();
                FastMessageFormat messageFormat = new FastMessageFormat("/content/reporting/?renderMode=XML&amp;solution={0}&amp;path={1}&amp;name={2}");
                messageFormat.setNullString("");
                return loginData.getUrl() + messageFormat.format((Object)new Object[]{solution, path, name});
            }
            logger.debug((Object)"Ancient pentaho system detected: We will not have access to a working parameter service");
            return null;
        }
        catch (FileSystemException e) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e);
            return null;
        }
    }

    public void requestParameterRefresh(DrillDownParameterRefreshEvent event) {
        String localPath = this.pathModel.getLocalPath();
        if (StringUtils.isEmpty((String)localPath)) {
            return;
        }
        try {
            RequestParamsFromServerTask requestParamsFromServerTask = new RequestParamsFromServerTask(this.pathModel);
            LoginTask loginTask = new LoginTask(this.reportDesignerContext, this.component, new UpdateRequestParamsTask(requestParamsFromServerTask, this.component, event), this.pathModel.getLoginData());
            SwingUtilities.invokeLater(loginTask);
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e);
            logger.warn((Object)"Failed to access parameter system", (Throwable)e);
        }
    }

    private static class RequestParamsFromServerTask
    implements AuthenticatedServerTask {
        private AuthenticationData loginData;
        private Exception error;
        private Parameter[] parameters;
        private PentahoPathModel pathModel;

        private RequestParamsFromServerTask(PentahoPathModel pathModel) {
            this.pathModel = pathModel;
        }

        @Override
        public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
            this.loginData = loginData;
        }

        public Exception getError() {
            return this.error;
        }

        public Parameter[] getParameters() {
            return this.parameters;
        }

        @Override
        public void run() {
            this.pathModel.setLoginData(this.loginData);
            String paramServiceText = PentahoParameterRefreshHandler.getParameterServicePath(this.loginData, this.pathModel);
            if (paramServiceText == null) {
                return;
            }
            try {
                HttpClient httpClient = PentahoParameterRefreshHandler.createHttpClient(this.loginData);
                GetMethod method = new GetMethod(paramServiceText);
                method.setFollowRedirects(false);
                int result = httpClient.executeMethod((HttpMethod)method);
                if (result != 200) {
                    if (result == 302 || result == 403 || result == 401) {
                        throw new PublishException(5);
                    }
                    throw new PublishException(2, result);
                }
                byte[] responseBody = method.getResponseBody();
                ResourceManager manager = new ResourceManager();
                Resource resource = manager.createDirectly((Object)responseBody, ParameterDocument.class);
                ParameterDocument o = (ParameterDocument)resource.getResource();
                this.parameters = o.getParameter();
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }

    private class UpdateRequestParamsTask
    implements AuthenticatedServerTask {
        private RequestParamsFromServerTask requestParamsFromServerTask;
        private Component uiContext;
        private AuthenticationData loginData;
        private DrillDownParameter[] existingParameters;

        private UpdateRequestParamsTask(RequestParamsFromServerTask requestParamsFromServerTask, Component uiContext, DrillDownParameterRefreshEvent event) {
            this.requestParamsFromServerTask = requestParamsFromServerTask;
            this.uiContext = uiContext;
            this.existingParameters = event.getParameter();
        }

        @Override
        public void setLoginData(AuthenticationData loginData, boolean storeUpdate) {
            this.loginData = loginData;
            this.requestParamsFromServerTask.setLoginData(loginData, storeUpdate);
        }

        @Override
        public void run() {
            Parameter parameter;
            int i;
            if (this.loginData == null) {
                return;
            }
            ReportDocumentContext reportRenderContext = PentahoParameterRefreshHandler.this.reportDesignerContext.getActiveContext();
            Object o = reportRenderContext.getProperties().get("pentaho-login-url");
            if (o == null) {
                reportRenderContext.getProperties().put("pentaho-login-url", this.loginData.getUrl());
            }
            Thread loginThread = new Thread(this.requestParamsFromServerTask);
            loginThread.setName("Request-parameter-from-server");
            loginThread.setDaemon(true);
            loginThread.setPriority(1);
            GenericCancelHandler cancelHandler = new GenericCancelHandler(loginThread);
            BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)loginThread, (CancelListener)cancelHandler, (Component)this.uiContext, (String)"Requesting Parameter Information ..");
            if (cancelHandler.isCancelled()) {
                return;
            }
            Exception error = this.requestParamsFromServerTask.getError();
            if (error != null) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)error);
                logger.warn((Object)"Failed to read parameter from server", (Throwable)error);
                return;
            }
            if (this.requestParamsFromServerTask.getParameters() == null) {
                logger.warn((Object)"Failed to read parameter from server: File does not exist.");
                return;
            }
            Parameter[] parameters = this.requestParamsFromServerTask.getParameters();
            HashMap<String, DrillDownParameter> parameterFromServer = new HashMap<String, DrillDownParameter>();
            ArrayList<Object> drillDownParameters = new ArrayList<Object>();
            for (i = 0; i < parameters.length; ++i) {
                parameter = parameters[i];
                DrillDownParameter drillDownParameter = new DrillDownParameter(parameter.getName());
                if ("system".equals(parameter.getAttribute("parameter-group")) || "subscription".equals(parameter.getAttribute("parameter-group")) || "output-target".equals(parameter.getName())) {
                    drillDownParameter.setType(DrillDownParameter.Type.SYSTEM);
                } else {
                    drillDownParameter.setType(DrillDownParameter.Type.PREDEFINED);
                }
                if ("false".equals(parameter.getAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "preferred"))) {
                    drillDownParameter.setPreferred(false);
                } else {
                    drillDownParameter.setPreferred(true);
                }
                drillDownParameters.add(drillDownParameter);
                parameterFromServer.put(parameter.getName(), drillDownParameter);
            }
            for (i = 0; i < this.existingParameters.length; ++i) {
                parameter = this.existingParameters[i];
                if (!parameterFromServer.containsKey(parameter.getName())) continue;
                DrillDownParameter existingOne = (DrillDownParameter)parameterFromServer.get(parameter.getName());
                existingOne.setFormulaFragment(parameter.getFormulaFragment());
                this.existingParameters[i] = null;
            }
            for (i = 0; i < this.existingParameters.length; ++i) {
                parameter = this.existingParameters[i];
                if (parameter == null) continue;
                parameter.setType(DrillDownParameter.Type.MANUAL);
                parameter.setPosition(drillDownParameters.size());
                drillDownParameters.add(parameter);
            }
            DrillDownParameter[] computedSet = drillDownParameters.toArray(new DrillDownParameter[drillDownParameters.size()]);
            if (PentahoParameterRefreshHandler.this.parameterTable != null) {
                PentahoParameterRefreshHandler.this.parameterTable.setDrillDownParameter(computedSet);
            }
        }
    }
}

