/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.drilldown;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.RepositoryLoginDialog;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;
import org.pentaho.ui.xul.XulEventSource;

public class PentahoPathModel
implements XulEventSource {
    private PropertyChangeSupport propertyChangeSupport;
    private String localPath;
    private AuthenticationData loginData;
    private HashMap<String, ExtensionMapping> extensionMap;
    private boolean useRemoteServer;
    private boolean hideParameterUi;
    private ReportDesignerContext reportDesignerContext;
    public static final String USE_REMOTE_SERVER_PROPERTY = "useRemoteServer";
    public static final String HIDE_PARAMETER_UI_PROPERTY = "hideParameterUi";
    public static final String SERVER_PATH_PROPERTY = "serverPath";
    public static final String LOGIN_DATA_PROPERTY = "loginData";
    public static final String LOCAL_PATH_PROPERTY = "localPath";

    public PentahoPathModel(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.extensionMap = new HashMap();
    }

    public void registerExtension(String extension, boolean local, boolean noParameter, String profileName) {
        ExtensionMapping mapping = this.extensionMap.get(extension);
        if (mapping == null) {
            mapping = new ExtensionMapping(extension);
            this.extensionMap.put(extension, mapping);
        }
        mapping.set(local, noParameter, profileName);
    }

    public AuthenticationData getLoginData() {
        return this.loginData;
    }

    public void setLoginData(AuthenticationData loginData) {
        String oldServerPath = this.getServerPath();
        AuthenticationData oldLoginData = this.loginData;
        this.loginData = loginData;
        this.propertyChangeSupport.firePropertyChange(LOGIN_DATA_PROPERTY, oldLoginData, loginData);
        this.propertyChangeSupport.firePropertyChange(SERVER_PATH_PROPERTY, oldServerPath, this.getServerPath());
    }

    public String getServerPath() {
        if (this.loginData == null) {
            return null;
        }
        return this.loginData.getUrl();
    }

    public void setServerPath(String serverPath) {
        String oldServerPath = this.getServerPath();
        if (ObjectUtilities.equal((Object)oldServerPath, (Object)serverPath)) {
            return;
        }
        if (serverPath == null) {
            this.setLoginData(null);
            this.propertyChangeSupport.firePropertyChange(SERVER_PATH_PROPERTY, oldServerPath, null);
            return;
        }
        AuthenticationData loginData = RepositoryLoginDialog.getStoredLoginData(serverPath, this.reportDesignerContext);
        if (loginData == null) {
            loginData = new AuthenticationData(serverPath);
        }
        this.setLoginData(loginData);
        this.propertyChangeSupport.firePropertyChange(SERVER_PATH_PROPERTY, oldServerPath, serverPath);
    }

    public boolean isUseRemoteServer() {
        return this.useRemoteServer;
    }

    public void setUseRemoteServer(boolean useRemoteServer) {
        boolean oldUseRemoteServer = this.useRemoteServer;
        this.useRemoteServer = useRemoteServer;
        this.propertyChangeSupport.firePropertyChange(USE_REMOTE_SERVER_PROPERTY, oldUseRemoteServer, useRemoteServer);
    }

    public boolean isHideParameterUi() {
        return this.hideParameterUi;
    }

    public void setHideParameterUi(boolean hideParameterUi) {
        boolean oldHide = this.hideParameterUi;
        this.hideParameterUi = hideParameterUi;
        this.propertyChangeSupport.firePropertyChange(HIDE_PARAMETER_UI_PROPERTY, oldHide, hideParameterUi);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        String oldValue = this.localPath;
        this.localPath = localPath;
        this.propertyChangeSupport.firePropertyChange(LOCAL_PATH_PROPERTY, oldValue, localPath);
    }

    public void setLocalPathFromParameter(DrillDownParameter[] params) {
        String solution = null;
        String path = null;
        String name = null;
        String localPath = null;
        for (int i = 0; i < params.length; ++i) {
            DrillDownParameter drillDownParameter = params[i];
            if ("solution".equals(drillDownParameter.getName())) {
                solution = FormulaUtil.extractStaticTextFromFormulaFragment((String)drillDownParameter.getFormulaFragment());
                continue;
            }
            if ("path".equals(drillDownParameter.getName())) {
                path = FormulaUtil.extractStaticTextFromFormulaFragment((String)drillDownParameter.getFormulaFragment());
                continue;
            }
            if ("name".equals(drillDownParameter.getName())) {
                name = FormulaUtil.extractStaticTextFromFormulaFragment((String)drillDownParameter.getFormulaFragment());
                continue;
            }
            if (!"::pentaho-path".equals(drillDownParameter.getName())) continue;
            localPath = FormulaUtil.extractStaticTextFromFormulaFragment((String)drillDownParameter.getFormulaFragment());
        }
        if (!StringUtils.isEmpty(localPath)) {
            this.setLocalPath(localPath);
        } else {
            StringBuilder b = new StringBuilder();
            if (!StringUtils.isEmpty(solution)) {
                b.append(solution);
            }
            if (!StringUtils.isEmpty(path)) {
                b.append("/");
                b.append(path);
            }
            if (!StringUtils.isEmpty(name)) {
                b.append("/");
                b.append(name);
            }
            if (b.length() == 0) {
                this.setLocalPath(null);
            } else {
                this.setLocalPath(b.toString());
            }
        }
    }

    public String getPath() {
        if (this.localPath == null) {
            return null;
        }
        String normalizedPath = this.localPath.replace('\\', '/');
        String[] path = StringUtils.split((String)normalizedPath, (String)"/");
        StringBuilder b = new StringBuilder();
        for (int i = 1; i < path.length - 1; ++i) {
            if (i > 1) {
                b.append('/');
            }
            String pathElement = path[i];
            b.append(pathElement);
        }
        return b.toString();
    }

    public String getName() {
        if (this.localPath == null) {
            return null;
        }
        String normalizedPath = this.localPath.replace('\\', '/');
        String[] path = StringUtils.split((String)normalizedPath, (String)"/");
        if (path.length > 1) {
            return path[path.length - 1];
        }
        return null;
    }

    public String getSolution() {
        if (this.localPath == null) {
            return null;
        }
        String normalizedPath = this.localPath.replace('\\', '/');
        String[] path = StringUtils.split((String)normalizedPath, (String)"/");
        if (path.length > 0) {
            return path[0];
        }
        return null;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getDrillDownProfile() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        String extension = IOUtils.getInstance().getFileExtension(name);
        ExtensionMapping mapping = this.extensionMap.get(extension);
        if (mapping == null && (mapping = this.extensionMap.get(null)) == null) {
            return null;
        }
        return mapping.get(!this.isUseRemoteServer(), this.hideParameterUi);
    }

    public String[] getExtensions() {
        return this.extensionMap.keySet().toArray(new String[this.extensionMap.size()]);
    }

    private static class ExtensionMapping {
        private String extension;
        private String localMode;
        private String remoteMode;
        private String localNoParamMode;
        private String remoteNoParamMode;

        private ExtensionMapping(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }

        public void set(boolean local, boolean noParameter, String name) {
            if (local) {
                if (noParameter) {
                    this.localNoParamMode = name;
                } else {
                    this.localMode = name;
                }
            } else if (noParameter) {
                this.remoteNoParamMode = name;
            } else {
                this.remoteMode = name;
            }
        }

        public String get(boolean local, boolean noParameter) {
            if (noParameter) {
                if (local) {
                    if (this.localNoParamMode != null) {
                        return this.localNoParamMode;
                    }
                } else if (this.remoteNoParamMode != null) {
                    return this.remoteNoParamMode;
                }
            }
            if (local) {
                if (this.localMode != null) {
                    return this.localMode;
                }
            } else if (this.remoteMode != null) {
                return this.remoteMode;
            }
            return this.localMode;
        }
    }
}

