/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.GlobalAuthenticationStore;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishSettings;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class RepositoryLoginDialog
extends CommonDialog {
    private JComboBox urlCombo;
    private JSpinner timeoutField;
    private JTextField userField;
    private JPasswordField userPasswordField;
    private JCheckBox rememberSettings;
    private ReportDesignerContext context;
    private DefaultComboBoxModel urlModel;
    private boolean loginForPublish;

    public RepositoryLoginDialog(Dialog owner, boolean loginForPublish) throws HeadlessException {
        super(owner);
        this.init(loginForPublish);
    }

    public RepositoryLoginDialog(Frame parent, boolean loginForPublish) {
        super(parent);
        this.init(loginForPublish);
    }

    public RepositoryLoginDialog(boolean loginForPublish) {
        this.init(loginForPublish);
    }

    public static AuthenticationData getDefaultData(ReportDesignerContext designerContext) {
        AuthenticationData loginData;
        GlobalAuthenticationStore authStore = designerContext.getGlobalAuthenticationStore();
        String rurl = authStore.getMostRecentEntry();
        if (rurl != null && (loginData = RepositoryLoginDialog.getStoredLoginData(rurl, designerContext)) != null) {
            return loginData;
        }
        String user = ReportDesignerBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.designer.extensions.pentaho.repository.ServerUser");
        String pass = ReportDesignerBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.designer.extensions.pentaho.repository.ServerPassword");
        String url = ReportDesignerBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.designer.extensions.pentaho.repository.PublishLocation");
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        return new AuthenticationData(url, user, pass, WorkspaceSettings.getInstance().getConnectionTimeout());
    }

    public static AuthenticationData getStoredLoginData(String baseUrl, ReportDesignerContext context) {
        ReportDocumentContext reportRenderContext = context.getActiveContext();
        Object authStore = reportRenderContext == null ? context.getGlobalAuthenticationStore() : reportRenderContext.getAuthenticationStore();
        AuthenticationData data = authStore.getCredentials(baseUrl);
        if (data == null) {
            return null;
        }
        return data;
    }

    public AuthenticationData performLogin(ReportDesignerContext context, AuthenticationData config) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
        if (config == null) {
            config = RepositoryLoginDialog.getDefaultData(context);
        }
        this.urlModel.removeAllElements();
        ReportDocumentContext reportRenderContext = context.getActiveContext();
        String[] urls = reportRenderContext == null ? context.getGlobalAuthenticationStore().getKnownURLs() : reportRenderContext.getAuthenticationStore().getKnownURLs();
        for (int i = 0; i < urls.length; ++i) {
            this.urlModel.addElement(urls[i]);
        }
        this.rememberSettings.setSelected(PublishSettings.getInstance().isRememberSettings());
        if (config != null) {
            this.timeoutField.setValue(PublishUtil.getTimeout(config));
            this.urlCombo.setSelectedItem(config.getUrl());
            this.userField.setText(config.getUsername());
            this.userPasswordField.setText(config.getPassword());
        } else {
            this.timeoutField.setValue(WorkspaceSettings.getInstance().getConnectionTimeout());
            this.urlCombo.setSelectedItem(null);
            this.userField.setText(null);
            this.userPasswordField.setText(null);
        }
        if (!super.performEdit()) {
            return null;
        }
        this.urlCombo.getModel().setSelectedItem(this.urlCombo.getEditor().getItem());
        String url = this.getServerURL();
        if (url == null) {
            return null;
        }
        PublishSettings.getInstance().setRememberSettings(this.isRememberSettings());
        AuthenticationData data = new AuthenticationData(url, this.getUsername(), this.getUserPassword(), this.getTimeout());
        data.setOption("server-version", String.valueOf(this.getVersion()));
        return data;
    }

    protected void init(boolean loginForPublish) {
        this.setTitle(Messages.getInstance().getString("RepositoryLoginDialog.Title"));
        this.loginForPublish = loginForPublish;
        this.urlModel = new DefaultComboBoxModel();
        this.urlCombo = new JComboBox(this.urlModel);
        this.userField = new JTextField(25);
        this.userPasswordField = new JPasswordField();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel();
        spinnerModel.setMinimum(Integer.valueOf(0));
        spinnerModel.setMaximum(Integer.valueOf(99999));
        this.timeoutField = new JSpinner(spinnerModel);
        this.timeoutField.setEditor(new JSpinner.NumberEditor(this.timeoutField, "#####"));
        this.rememberSettings = new JCheckBox(Messages.getInstance().getString("RepositoryLoginDialog.RememberTheseSettings"), true);
        this.urlCombo.setEditable(true);
        this.urlCombo.addActionListener(new URLChangeHandler());
        this.userField.setAction(this.getConfirmAction());
        this.userPasswordField.setAction(this.getConfirmAction());
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Pentaho.RepositoryLogin";
    }

    protected Component createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 17;
        contentPane.add((Component)this.buildServerPanel(), c);
        c.gridy = 1;
        c.insets = new Insets(0, 10, 5, 10);
        contentPane.add((Component)this.buildUserPanel(), c);
        c.gridy = 2;
        contentPane.add((Component)this.rememberSettings, c);
        return contentPane;
    }

    private JPanel buildServerPanel() {
        JPanel serverPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 20, 5, 20);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        serverPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryLoginDialog.URL")), c);
        c.gridy = 1;
        c.insets = new Insets(0, 20, 5, 20);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        serverPanel.add((Component)this.urlCombo, c);
        c.insets = new Insets(0, 20, 5, 20);
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        serverPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryLoginDialog.Timeout")), c);
        c.gridy = 3;
        c.insets = new Insets(0, 20, 5, 20);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        serverPanel.add((Component)this.timeoutField, c);
        serverPanel.setBorder(BorderFactory.createTitledBorder(Messages.getInstance().getString("RepositoryLoginDialog.Server")));
        return serverPanel;
    }

    private JPanel buildUserPanel() {
        JPanel userPanel = new JPanel(new GridBagLayout());
        userPanel.setBorder(BorderFactory.createTitledBorder(Messages.getInstance().getString("RepositoryLoginDialog.PentahoCredentials")));
        JLabel userLabel = new JLabel(Messages.getInstance().getString("RepositoryLoginDialog.User"));
        JLabel passwordLabel = new JLabel(Messages.getInstance().getString("RepositoryLoginDialog.Password"));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 20, 5, 20);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        userPanel.add((Component)userLabel, c);
        c.gridy = 1;
        c.insets = new Insets(0, 20, 0, 20);
        userPanel.add((Component)this.userField, c);
        c.gridy = 2;
        c.insets = new Insets(0, 20, 0, 20);
        userPanel.add((Component)passwordLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 20, 10, 20);
        userPanel.add((Component)this.userPasswordField, c);
        return userPanel;
    }

    public String getServerURL() {
        Object o = this.urlCombo.getSelectedItem();
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public int getVersion() {
        return 5;
    }

    public String getUsername() {
        return this.userField.getText();
    }

    public String getUserPassword() {
        return new String(this.userPasswordField.getPassword());
    }

    public int getTimeout() {
        Object timeout = this.timeoutField.getValue();
        if (timeout instanceof Number) {
            Number number = (Number)timeout;
            return number.intValue();
        }
        return WorkspaceSettings.getInstance().getConnectionTimeout();
    }

    public boolean isRememberSettings() {
        return this.rememberSettings.isSelected();
    }

    private class URLChangeHandler
    implements ActionListener {
        private URLChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String serverURL = (String)RepositoryLoginDialog.this.urlCombo.getSelectedItem();
            AuthenticationData config = RepositoryLoginDialog.getStoredLoginData(serverURL, RepositoryLoginDialog.this.context);
            if (config != null) {
                RepositoryLoginDialog.this.timeoutField.setValue(PublishUtil.getTimeout(config));
                RepositoryLoginDialog.this.userField.setText(config.getUsername());
                RepositoryLoginDialog.this.userPasswordField.setText(config.getPassword());
            }
        }
    }
}

