/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.CreateNewRepositoryFolderDialog;
import org.pentaho.reporting.designer.extensions.pentaho.repository.model.RepositoryTreeModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.RepositoryTreeCellRenderer;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.pensol.WebSolutionFileObject;

public class RepositoryTreeDialog
extends CommonDialog {
    private RepositoryTreeModel repositoryTreeModel;
    private JTree repositoryBrowser;
    private boolean dirty;
    private boolean addNewButtonPanel;

    public RepositoryTreeDialog(JDialog dialog, boolean addNewButtonPanel) {
        super((Dialog)dialog);
        this.init(addNewButtonPanel);
    }

    public RepositoryTreeDialog(boolean addNewButtonPanel) {
        this.init(addNewButtonPanel);
    }

    public RepositoryTreeDialog(Frame owner, boolean addNewButtonPanel) {
        super(owner);
        this.init(addNewButtonPanel);
    }

    protected void init(boolean addNewButtonPanel) {
        this.setModal(true);
        this.setTitle(Messages.getInstance().getString("SolutionRepositoryTreeDialog.Title"));
        this.addNewButtonPanel = addNewButtonPanel;
        this.repositoryTreeModel = new RepositoryTreeModel();
        this.repositoryBrowser = new JTree(this.repositoryTreeModel);
        this.repositoryBrowser.setCellRenderer(new RepositoryTreeCellRenderer());
        this.repositoryBrowser.addMouseListener(new DoubleClickHandler());
        this.repositoryBrowser.setRootVisible(true);
        this.repositoryBrowser.setShowsRootHandles(true);
        this.repositoryBrowser.setToggleClickCount(1);
        super.init();
        this.setDefaultCloseOperation(2);
    }

    protected String getDialogId() {
        return "ReportDesigner.Pentaho.RepositoryTree";
    }

    public FileObject getSelectedPath() {
        TreePath selectionPath = this.repositoryBrowser.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        if (selectionPath.getLastPathComponent() instanceof FileObject) {
            return (FileObject)selectionPath.getLastPathComponent();
        }
        return null;
    }

    public void setSelectedPath(FileObject path) throws FileSystemException {
        TreePath path1 = this.repositoryTreeModel.getTreePathForSelection(path, null);
        if (path1 != null) {
            this.repositoryBrowser.setSelectionPath(path1);
            this.repositoryBrowser.scrollPathToVisible(path1);
        } else {
            this.repositoryBrowser.clearSelection();
        }
    }

    public FileObject performSelectLocation(FileObject fileSystemRoot, String[] filter, FileObject publishLocation) throws FileSystemException {
        this.repositoryTreeModel.setShowFoldersOnly(true);
        this.repositoryTreeModel.setFileSystemRoot(fileSystemRoot);
        this.repositoryTreeModel.setFilters(filter);
        this.repositoryTreeModel.fireTreeDataChanged();
        this.dirty = false;
        this.setSelectedPath(publishLocation);
        if (this.performEdit()) {
            return this.getSelectedPath();
        }
        return null;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected Component createContentPane() {
        JScrollPane treeView = new JScrollPane(this.repositoryBrowser);
        JPanel newFolderButtonPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (this.addNewButtonPanel) {
            JButton newFolder = new JButton(new NewFolderAction());
            newFolder.setBorder(BorderFactory.createEmptyBorder());
            JLabel label = new JLabel(Messages.getInstance().getString("SolutionRepositoryTreeDialog.SelectLocation"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 80));
            newFolderButtonPanel.add((Component)label, "Center");
            newFolderButtonPanel.add((Component)newFolder, "East");
            c.insets = new Insets(2, 10, 0, 10);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            panel.add((Component)newFolderButtonPanel, c);
        }
        c = new GridBagConstraints();
        c.insets = new Insets(0, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)treeView, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        panel.add(new JCheckBox(new ShowHiddenFilesAction()));
        return panel;
    }

    private class NewFolderAction
    extends AbstractAction {
        private NewFolderAction() {
            URL location = RepositoryTreeDialog.class.getResource("/org/pentaho/reporting/designer/extensions/pentaho/repository/resources/newfolder.png");
            this.putValue("SmallIcon", new ImageIcon(location));
            this.putValue("ShortDescription", Messages.getInstance().getString("SolutionRepositoryTreeDialog.NewFolderAction.Name"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            CreateNewRepositoryFolderDialog newFolderDialog = new CreateNewRepositoryFolderDialog((Dialog)((Object)RepositoryTreeDialog.this));
            if (!newFolderDialog.performEdit()) {
                return;
            }
            TreePath selectionPath = RepositoryTreeDialog.this.repositoryBrowser.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            FileObject treeNode = (FileObject)selectionPath.getLastPathComponent();
            if (!StringUtils.isEmpty((String)newFolderDialog.getName())) {
                Component glassPane = SwingUtilities.getRootPane((Component)((Object)RepositoryTreeDialog.this)).getGlassPane();
                try {
                    glassPane.setVisible(true);
                    glassPane.setCursor(new Cursor(3));
                    FileObject child = treeNode.resolveFile(newFolderDialog.getFolderName());
                    if (child instanceof WebSolutionFileObject) {
                        WebSolutionFileObject webSolutionFileObject = (WebSolutionFileObject)child;
                        webSolutionFileObject.setDescription(newFolderDialog.getDescription());
                    }
                    child.createFolder();
                    RepositoryTreeDialog.this.repositoryTreeModel.fireTreeDataChanged();
                    RepositoryTreeDialog.this.repositoryBrowser.setSelectionPath(selectionPath.getParentPath().pathByAddingChild(child));
                    RepositoryTreeDialog.this.setDirty(true);
                }
                catch (Exception e1) {
                    UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
                }
                finally {
                    glassPane.setVisible(false);
                    glassPane.setCursor(new Cursor(0));
                }
            }
        }
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        private DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() <= 1) {
                return;
            }
            try {
                TreePath selectionPath = RepositoryTreeDialog.this.repositoryBrowser.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                Object o = RepositoryTreeDialog.this.repositoryBrowser.getLastSelectedPathComponent();
                if (o instanceof FileObject) {
                    FileObject treeNode = (FileObject)o;
                    if (RepositoryTreeDialog.this.repositoryBrowser.isExpanded(selectionPath) && treeNode.getType() == FileType.FOLDER) {
                        RepositoryTreeDialog.this.setSelectedPath(treeNode);
                        RepositoryTreeDialog.this.setConfirmed(true);
                        RepositoryTreeDialog.this.setVisible(false);
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    private class ShowHiddenFilesAction
    extends AbstractAction {
        private ShowHiddenFilesAction() {
            this.putValue("Name", Messages.getInstance().getString("ShowHiddenFilesAction.Name"));
            this.setSelected(Boolean.FALSE);
        }

        private Boolean getSelected() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        private void setSelected(Boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryTreeDialog.this.repositoryTreeModel.setShowHiddenFiles(Boolean.TRUE.equals(this.getSelected()));
        }
    }
}

