/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.global.OpenReportAction;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishException;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.RepositoryPathEncoder;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.util.URLEncoder;
import org.pentaho.reporting.libraries.pensol.PentahoSolutionsFileSystemConfigBuilder;
import org.pentaho.reporting.libraries.pensol.PublishRestUtil;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class PublishUtil {
    private static final String WEB_SOLUTION_PREFIX = "web-solution:";
    private static final String JCR_SOLUTION_PREFIX = "jcr-solution:";
    public static final String SERVER_VERSION = "server-version";
    public static final int SERVER_VERSION_SUGAR = 5;
    public static final int SERVER_VERSION_LEGACY = 4;
    private static final int HTTP_RESPONSE_FAIL = 504;
    private static final int HTTP_RESPONSE_OK = 200;
    private static final String TIMEOUT = "timeout";
    protected static String reservedChars = "/\\\t\r\n";
    protected static String reservedCharsDisplay = "/, \\, TAB, CR, LF";
    private static Pattern containsReservedCharsPattern = PublishUtil.makePattern(reservedChars);

    private PublishUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportRenderContext openReport(ReportDesignerContext context, AuthenticationData loginData, String path) throws IOException, ReportDataFactoryException, ResourceException {
        if (StringUtils.isEmpty((String)path)) {
            throw new IOException("Path is empty.");
        }
        String urlPath = path.replaceAll("%", "%25").replaceAll("%2B", "+").replaceAll("\\!", "%21").replaceAll(":", "%3A");
        FileObject connection = PublishUtil.createVFSConnection(loginData);
        FileObject object = connection.resolveFile(urlPath);
        if (!object.exists()) {
            throw new FileNotFoundException(path);
        }
        InputStream inputStream = object.getContent().getInputStream();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(Math.max(8192, (int)object.getContent().getSize()));
            IOUtils.getInstance().copyStreams(inputStream, (OutputStream)out);
            MasterReport report = PublishUtil.loadReport(out.toByteArray(), path);
            int index = context.addMasterReport(report);
            ReportRenderContext reportRenderContext = context.getReportRenderContext(index);
            return reportRenderContext;
        }
        finally {
            inputStream.close();
        }
    }

    private static MasterReport loadReport(byte[] data, String fileName) throws IOException, ResourceException {
        if (data == null) {
            throw new NullPointerException();
        }
        ResourceManager resourceManager = new ResourceManager();
        MasterReport resource = OpenReportAction.loadReport((Object)data, (ResourceManager)resourceManager);
        resource.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path", (Object)fileName);
        return resource;
    }

    public static void launchReportOnServer(String baseUrl, String path) throws IOException {
        if (StringUtils.isEmpty((String)path)) {
            throw new IOException("Path is empty.");
        }
        Configuration config = ReportDesignerBoot.getInstance().getGlobalConfig();
        String urlMessage = config.getConfigProperty("org.pentaho.reporting.designer.extensions.pentaho.repository.LaunchReport");
        String fullRepoViewerPath = MessageFormat.format(urlMessage, URLEncoder.encode((String)RepositoryPathEncoder.encodeRepositoryPath(path), (String)"UTF-8"));
        String url = baseUrl + fullRepoViewerPath;
        ExternalToolLauncher.openURL((String)url);
    }

    public static byte[] createBundleData(MasterReport report) throws PublishException, BundleWriterException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BundleWriter.writeReportToZipStream((MasterReport)report, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (ContentIOException e) {
            throw new BundleWriterException("Failed to write report", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new BundleWriterException("Failed to write report", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int publish(byte[] data, String path, AuthenticationData loginData) throws IOException {
        int responseCode = 504;
        String versionText = loginData.getOption(SERVER_VERSION);
        int version = ParserUtil.parseInt((String)versionText, (int)5);
        if (5 == version) {
            PublishRestUtil publishRestUtil = new PublishRestUtil(loginData.getUrl(), loginData.getUsername(), loginData.getPassword());
            responseCode = publishRestUtil.publishFile(path, data, true);
        } else {
            FileObject connection = PublishUtil.createVFSConnection(loginData);
            FileObject object = connection.resolveFile(path);
            OutputStream out = object.getContent().getOutputStream(false);
            try {
                out.write(data);
                responseCode = 200;
            }
            finally {
                out.close();
            }
        }
        return responseCode;
    }

    public static boolean acceptFilter(String[] filters, String name) {
        if (filters == null || filters.length == 0) {
            return true;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (!name.endsWith(filters[i])) continue;
            return true;
        }
        return false;
    }

    public static FileObject createVFSConnection(AuthenticationData loginData) throws FileSystemException {
        return PublishUtil.createVFSConnection(VFS.getManager(), loginData);
    }

    public static FileObject createVFSConnection(FileSystemManager fileSystemManager, AuthenticationData loginData) throws FileSystemException {
        if (fileSystemManager == null) {
            throw new NullPointerException();
        }
        if (loginData == null) {
            throw new NullPointerException();
        }
        String versionText = loginData.getOption(SERVER_VERSION);
        int version = ParserUtil.parseInt((String)versionText, (int)5);
        String normalizedUrl = PublishUtil.normalizeURL(loginData.getUrl(), version);
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        PentahoSolutionsFileSystemConfigBuilder configBuilder = new PentahoSolutionsFileSystemConfigBuilder();
        configBuilder.setTimeOut(fileSystemOptions, PublishUtil.getTimeout(loginData) * 1000);
        configBuilder.setUserAuthenticator(fileSystemOptions, (UserAuthenticator)new StaticUserAuthenticator(normalizedUrl, loginData.getUsername(), loginData.getPassword()));
        return fileSystemManager.resolveFile(normalizedUrl, fileSystemOptions);
    }

    public static int getTimeout(AuthenticationData loginData) {
        String s = loginData.getOption(TIMEOUT);
        return ParserUtil.parseInt((String)s, (int)WorkspaceSettings.getInstance().getConnectionTimeout());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String normalizeURL(String baseURL, int version) {
        String url2;
        if (baseURL == null) {
            throw new NullPointerException();
        }
        StringBuilder prefix = new StringBuilder(100);
        if (version == 4) {
            if (baseURL.toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                url2 = baseURL.substring("http://".length());
                prefix.append(WEB_SOLUTION_PREFIX);
                prefix.append("http://");
                return prefix.append(url2).toString();
            } else {
                if (!baseURL.toLowerCase(Locale.ENGLISH).startsWith("https://")) throw new IllegalArgumentException("Not a expected URL");
                url2 = baseURL.substring("https://".length());
                prefix.append(WEB_SOLUTION_PREFIX);
                prefix.append("https://");
            }
            return prefix.append(url2).toString();
        } else if (baseURL.toLowerCase(Locale.ENGLISH).startsWith("http://")) {
            url2 = baseURL.substring("http://".length());
            prefix.append(JCR_SOLUTION_PREFIX);
            prefix.append("http://");
            return prefix.append(url2).toString();
        } else {
            if (!baseURL.toLowerCase(Locale.ENGLISH).startsWith("https://")) throw new IllegalArgumentException("Not a expected URL");
            url2 = baseURL.substring("https://".length());
            prefix.append(JCR_SOLUTION_PREFIX);
            prefix.append("https://");
        }
        return prefix.append(url2).toString();
    }

    private static Pattern makePattern(String reservedChars) {
        StringBuilder buf = new StringBuilder();
        buf.append(".*[");
        for (int i = 0; i < reservedChars.length(); ++i) {
            buf.append("\\");
            buf.append(reservedChars.substring(i, i + 1));
        }
        buf.append("]+.*");
        return Pattern.compile(buf.toString());
    }

    public static boolean validateName(String name) {
        return !StringUtils.isEmpty((String)name, (boolean)true) && name.trim().equals(name) && !containsReservedCharsPattern.matcher(name).matches() && !".".equals(name) && !"..".equals(name);
    }

    public static void setReservedChars(String reservedChars) {
        containsReservedCharsPattern = PublishUtil.makePattern(reservedChars);
    }

    public static Pattern getPattern() {
        return containsReservedCharsPattern;
    }

    public static String getReservedCharsDisplay() {
        return reservedCharsDisplay;
    }

    public static void setReservedCharsDisplay(String reservedCharsDisplay) {
        PublishUtil.reservedCharsDisplay = reservedCharsDisplay;
    }
}

