/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.guvnor.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.guvnor.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.guvnor.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.guvnor.client.modeldriven.dt.AttributeCol;
import org.drools.guvnor.client.modeldriven.dt.ConditionCol;
import org.drools.guvnor.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.guvnor.client.modeldriven.dt.MetadataCol;

public class GuidedDTXMLPersistence {
    private XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());
    private static GuidedDTXMLPersistence INSTANCE = new GuidedDTXMLPersistence();

    private GuidedDTXMLPersistence() {
        this.xt.alias("decision-table", GuidedDecisionTable.class);
        this.xt.alias("metadata-column", MetadataCol.class);
        this.xt.alias("attribute-column", AttributeCol.class);
        this.xt.alias("condition-column", ConditionCol.class);
        this.xt.alias("set-field-col", ActionSetFieldCol.class);
        this.xt.alias("retract-fact-column", ActionRetractFactCol.class);
        this.xt.alias("insert-fact-column", ActionInsertFactCol.class);
    }

    public static GuidedDTXMLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(GuidedDecisionTable dt) {
        return this.xt.toXML((Object)dt);
    }

    public GuidedDecisionTable unmarshal(String xml) {
        if (xml == null || xml.trim().equals("")) {
            return new GuidedDecisionTable();
        }
        return (GuidedDecisionTable)this.xt.fromXML(xml);
    }
}

