/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.pentaho.database.model.IDatabaseType;

public class DatabaseTypeHelper {
    List<IDatabaseType> databaseTypes;
    List<String> databaseTypeNames = null;
    Map<String, IDatabaseType> databaseTypeByName = null;
    Map<String, IDatabaseType> databaseTypeByShortName = null;

    public DatabaseTypeHelper(List<IDatabaseType> databaseTypes) {
        this.databaseTypes = databaseTypes;
    }

    private void init() {
        ArrayList<String> dbTypeNames = new ArrayList<String>();
        TreeMap<String, IDatabaseType> dbTypeByName = new TreeMap<String, IDatabaseType>();
        TreeMap<String, IDatabaseType> dbTypeByShortName = new TreeMap<String, IDatabaseType>();
        for (IDatabaseType dbtype : this.databaseTypes) {
            dbTypeNames.add(dbtype.getName());
            dbTypeByName.put(dbtype.getName(), dbtype);
            dbTypeByShortName.put(dbtype.getShortName(), dbtype);
        }
        this.databaseTypeNames = dbTypeNames;
        this.databaseTypeByName = dbTypeByName;
        this.databaseTypeByShortName = dbTypeByShortName;
    }

    public List<String> getDatabaseTypeNames() {
        if (this.databaseTypeNames == null) {
            this.init();
        }
        return this.databaseTypeNames;
    }

    public IDatabaseType getDatabaseTypeByName(String name) {
        if (this.databaseTypeByName == null) {
            this.init();
        }
        return this.databaseTypeByName.get(name);
    }

    public IDatabaseType getDatabaseTypeByShortName(String name) {
        if (this.databaseTypeByShortName == null) {
            this.init();
        }
        return this.databaseTypeByShortName.get(name);
    }
}

