/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.StorageKey;
import com.microsoft.windowsazure.storage.core.Base64;

public final class Credentials {
    private String accountName;
    private final StorageKey key;
    private String keyName;
    private String signingAccountName;

    public Credentials(String accountName, byte[] key) {
        if (accountName == null || accountName.length() == 0) {
            throw new IllegalArgumentException("Invalid account name.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key invalid. Cannot be null.");
        }
        this.accountName = accountName;
        this.key = new StorageKey(key);
        this.signingAccountName = accountName;
    }

    public Credentials(String accountName, String key) {
        this(accountName, Base64.decode(key));
    }

    public String exportBase64EncodedKey() {
        return this.getKey().getBase64EncodedKey();
    }

    public byte[] exportKey() {
        return this.getKey().getKey();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getSigningAccountName() {
        return this.signingAccountName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public StorageKey getKey() {
        return this.key;
    }

    protected void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    protected void setSigningAccountName(String signingAccountName) {
        this.signingAccountName = signingAccountName;
    }

    protected void setKeyName(String keyName) {
        this.keyName = keyName;
    }
}

