/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.AccessCondition;
import com.microsoft.windowsazure.storage.Constants;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobListingContext;
import com.microsoft.windowsazure.storage.blob.BlobListingDetails;
import com.microsoft.windowsazure.storage.blob.BlobProperties;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.BlockListingFilter;
import com.microsoft.windowsazure.storage.blob.ContainerRequest;
import com.microsoft.windowsazure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.windowsazure.storage.blob.LeaseAction;
import com.microsoft.windowsazure.storage.blob.PageOperationType;
import com.microsoft.windowsazure.storage.blob.PageProperties;
import com.microsoft.windowsazure.storage.core.BaseRequest;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

final class BlobRequest {
    private static final String BLOCK_QUERY_ELEMENT_NAME = "block";
    private static final String BLOCK_ID_QUERY_ELEMENT_NAME = "blockid";
    private static final String BLOCK_LIST_QUERY_ELEMENT_NAME = "blocklist";
    private static final String BLOCK_LIST_TYPE_QUERY_ELEMENT_NAME = "blocklisttype";
    private static final String COPY_QUERY_ELEMENT_NAME = "copy";
    private static final String PAGE_QUERY_ELEMENT_NAME = "page";
    private static final String PAGE_LIST_QUERY_ELEMENT_NAME = "pagelist";
    private static final String SNAPSHOTS_QUERY_ELEMENT_NAME = "snapshots";
    private static final String UNCOMMITTED_BLOBS_QUERY_ELEMENT_NAME = "uncommittedblobs";

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        BaseRequest.addMetadata(request, name, value, opContext);
    }

    private static void addProperties(HttpURLConnection request, BlobProperties properties) {
        BaseRequest.addOptionalHeader(request, "x-ms-blob-cache-control", properties.getCacheControl());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-disposition", properties.getContentDisposition());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-encoding", properties.getContentEncoding());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-language", properties.getContentLanguage());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-md5", properties.getContentMD5());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-type", properties.getContentType());
    }

    public static HttpURLConnection copyFrom(URI uri, int timeout, String source, String sourceSnapshotID, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        if (sourceSnapshotID != null) {
            source = source.concat("?snapshot=");
            source = source.concat(sourceSnapshotID);
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, null, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-source", source);
        if (sourceAccessCondition != null) {
            sourceAccessCondition.applyConditionToRequest(request, true);
        }
        if (destinationAccessCondition != null) {
            destinationAccessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection abortCopy(URI uri, int timeout, String copyId, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", COPY_QUERY_ELEMENT_NAME);
        builder.add("copyid", copyId);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-action", "abort");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request, true);
        }
        return request;
    }

    private static HttpURLConnection createURLConnection(URI uri, int timeout, UriQueryBuilder query, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.createURLConnection(uri, timeout, query, opContext);
    }

    public static HttpURLConnection delete(URI uri, int timeout, String snapshotVersion, DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (snapshotVersion != null && deleteSnapshotsOption != DeleteSnapshotsOption.NONE) {
            throw new IllegalArgumentException(String.format("The option '%s' must be 'None' to delete a specific snapshot specified by '%s'.", "deleteSnapshotsOption", "snapshot"));
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.delete(uri, timeout, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        switch (deleteSnapshotsOption) {
            case NONE: {
                break;
            }
            case INCLUDE_SNAPSHOTS: {
                request.setRequestProperty("x-ms-delete-snapshots", "include");
                break;
            }
            case DELETE_SNAPSHOTS_ONLY: {
                request.setRequestProperty("x-ms-delete-snapshots", "only");
                break;
            }
        }
        return request;
    }

    public static HttpURLConnection get(URI uri, int timeout, String snapshotVersion, Long offset, Long count, boolean requestRangeContentMD5, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (offset != null && requestRangeContentMD5) {
            Utility.assertNotNull("count", count);
            Utility.assertInBounds("count", count, 1L, Constants.MAX_BLOCK_SIZE);
        }
        HttpURLConnection request = BlobRequest.get(uri, timeout, snapshotVersion, accessCondition, blobOptions, opContext);
        if (offset != null) {
            long rangeStart = offset;
            if (count != null) {
                long rangeEnd = offset + count - 1L;
                request.setRequestProperty("x-ms-range", String.format(Utility.LOCALE_US, "bytes=%d-%d", rangeStart, rangeEnd));
            } else {
                request.setRequestProperty("x-ms-range", String.format(Utility.LOCALE_US, "bytes=%d-", rangeStart));
            }
        }
        if (offset != null && requestRangeContentMD5) {
            request.setRequestProperty("x-ms-range-get-content-md5", "true");
        }
        return request;
    }

    public static HttpURLConnection get(URI uri, int timeout, String snapshotVersion, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getBlockList(URI uri, int timeout, String snapshotVersion, BlockListingFilter blockFilter, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BLOCK_LIST_QUERY_ELEMENT_NAME);
        builder.add(BLOCK_LIST_TYPE_QUERY_ELEMENT_NAME, blockFilter.toString());
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getPageRanges(URI uri, int timeout, String snapshotVersion, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", PAGE_LIST_QUERY_ELEMENT_NAME);
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        BaseRequest.addOptionalHeader(request, "snapshot", snapshotVersion);
        return request;
    }

    public static HttpURLConnection getProperties(URI uri, int timeout, String snapshotVersion, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        BaseRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.getProperties(uri, timeout, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection lease(URI uri, int timeout, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "lease");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("x-ms-lease-action", action.toString());
        request.setRequestProperty("x-ms-lease-duration", leaseTimeInSeconds == null ? "-1" : leaseTimeInSeconds.toString());
        if (proposedLeaseId != null) {
            request.setRequestProperty("x-ms-proposed-lease-id", proposedLeaseId);
        }
        if (breakPeriodInSeconds != null) {
            request.setRequestProperty("x-ms-lease-break-period", breakPeriodInSeconds.toString());
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection list(URI uri, int timeout, BlobListingContext listingContext, BlobRequestOptions blobOptions, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getDelimiter())) {
                builder.add("delimiter", listingContext.getDelimiter());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
            if (listingContext.getListingDetails().size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean started = false;
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.SNAPSHOTS)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append(SNAPSHOTS_QUERY_ELEMENT_NAME);
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.UNCOMMITTED_BLOBS)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append(UNCOMMITTED_BLOBS_QUERY_ELEMENT_NAME);
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.COPY)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append(COPY_QUERY_ELEMENT_NAME);
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.METADATA)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append("metadata");
                }
                builder.add("include", sb.toString());
            }
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection put(URI uri, int timeout, BlobProperties properties, BlobType blobType, long pageBlobSize, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (blobType == BlobType.UNSPECIFIED) {
            throw new IllegalArgumentException("The blob type is not defined.  Allowed types are BlobType.BLOCK_BLOB and BlobType.Page_BLOB.");
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, null, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        BlobRequest.addProperties(request, properties);
        if (blobType == BlobType.PAGE_BLOB) {
            request.setFixedLengthStreamingMode(0);
            request.setRequestProperty("Content-Length", "0");
            request.setRequestProperty("x-ms-blob-type", "PageBlob");
            request.setRequestProperty("x-ms-blob-content-length", String.valueOf(pageBlobSize));
            properties.setLength(pageBlobSize);
        } else {
            request.setRequestProperty("x-ms-blob-type", "BlockBlob");
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putBlock(URI uri, int timeout, String blockId, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BLOCK_QUERY_ELEMENT_NAME);
        builder.add(BLOCK_ID_QUERY_ELEMENT_NAME, blockId);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putBlockList(URI uri, int timeout, BlobProperties properties, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BLOCK_LIST_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        BlobRequest.addProperties(request, properties);
        return request;
    }

    public static HttpURLConnection putPage(URI uri, int timeout, PageProperties properties, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", PAGE_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (properties.getPageOperation() == PageOperationType.CLEAR) {
            request.setFixedLengthStreamingMode(0);
        }
        request.setRequestProperty("x-ms-page-write", properties.getPageOperation().toString());
        request.setRequestProperty("x-ms-range", properties.getRange().toString());
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BaseRequest.setMetadata(uri, timeout, null, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setProperties(URI uri, int timeout, BlobProperties properties, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (properties != null) {
            BlobRequest.addProperties(request, properties);
        }
        return request;
    }

    public static HttpURLConnection resize(URI uri, int timeout, Long newBlobSize, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (newBlobSize != null) {
            request.setRequestProperty("x-ms-blob-content-length", newBlobSize.toString());
        }
        return request;
    }

    public static HttpURLConnection snapshot(URI uri, int timeout, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "snapshot");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, timeout, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    private BlobRequest() {
    }
}

