/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model;

class NullIndicator {
    byte[] bytes;

    public NullIndicator(int numColumns) {
        int numBytes = NullIndicator.ceilXOver8(numColumns);
        this.bytes = new byte[numBytes];
    }

    public boolean isNull(int columnIdx) {
        int byteIdx = columnIdx / 8;
        int bitIdx = columnIdx % 8;
        int val = this.bytes[byteIdx];
        return ((val >>= 7 - bitIdx) & 1) == 1;
    }

    public void setToNull(int columnIdx) {
        int byteIdx = columnIdx / 8;
        int bitIdx = columnIdx % 8;
        int bitSet = 1 << 7 - bitIdx;
        this.bytes[byteIdx] = (byte)(this.bytes[byteIdx] | bitSet);
    }

    public void reset() {
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    private static int ceilXOver8(int x) {
        assert (x >= 0);
        return x == 0 ? 0 : (x - 1) / 8 + 1;
    }
}

