/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import org.pentaho.ui.xul.XulEventSource;

public class ArgumentWrapper
implements XulEventSource {
    private String name;
    private String displayName;
    private boolean flag;
    private Object target;
    private Method getter;
    private Method setter;

    public ArgumentWrapper(String name, String displayName, boolean flag, Object target, Method getter, Method setter) {
        if (name == null || target == null || getter == null || setter == null) {
            throw new NullPointerException();
        }
        this.validateAccessors(getter, setter);
        this.name = name;
        this.displayName = displayName;
        this.flag = flag;
        this.target = target;
        this.getter = getter;
        this.setter = setter;
    }

    private void validateAccessors(Method getter, Method setter) {
        if (getter.getReturnType() != String.class) {
            throw new IllegalArgumentException("Invalid getter method. Method must return a String,");
        }
        if (setter.getParameterTypes().length < 1 || setter.getParameterTypes()[0] != String.class) {
            throw new IllegalArgumentException("Invalid setter method. Method must accept a single String parameter.");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setValue(String value) {
        try {
            if ("".equals(value)) {
                value = null;
            }
            this.setter.invoke(this.target, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("error setting value for argument " + this.getName(), ex);
        }
    }

    public String getValue() {
        try {
            return (String)String.class.cast(this.getter.invoke(this.target, new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException("error retrieving value for argument " + this.getName(), ex);
        }
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentWrapper that = (ArgumentWrapper)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

